theory SL = VDMderived + VDMSoundRecPC:

constdefs HpDistinct:: "heap \<Rightarrow> heap \<Rightarrow> bool"
"HpDistinct h hh \<equiv> (Dom h \<inter> Dom hh = {})"

constdefs HpUnion::"heap \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"HpUnion h1 h2 h \<equiv> (Dom h = Dom h1 \<union> Dom h2 \<and> 
                       (\<forall> l . ((l : Dom h1 \<longrightarrow> h1@@l = h@@l) \<and> (l : Dom h2 \<longrightarrow> h2@@l = h@@l))) \<and> 
                       (\<forall> l R . ((l : Dom h1 \<longrightarrow> h1\<lfloor>l\<diamondsuit>R\<rfloor> = h\<lfloor>l\<diamondsuit>R\<rfloor>) \<and> (l : Dom h2 \<longrightarrow> h2\<lfloor>l\<diamondsuit>R\<rfloor> = h\<lfloor>l\<diamondsuit>R\<rfloor>))) \<and> 
                       (\<forall> l I . ((l : Dom h1 \<longrightarrow> h1<l\<bullet>I> = h<l\<bullet>I>) \<and> (l : Dom h2 \<longrightarrow> h2<l\<bullet>I> = h<l\<bullet>I>))) \<and>
                       (\<forall> c f . h\<lbrace>c\<struct>f\<rbrace> = h1\<lbrace>c\<struct>f\<rbrace> \<and> h\<lbrace>c\<struct>f\<rbrace> = h2\<lbrace>c\<struct>f\<rbrace>))"

(*
constdefs equiv::"(env \<times> heap \<times> val \<times> heap \<times> val) \<Rightarrow> bool"
"equiv (E,h1,v1,h2,v2) \<equiv> (\<forall> 

lemma "E \<turnstile> h , e \<Down>n1 (h1 , v1 , p1) \<Longrightarrow> E \<turnstile> h , e \<Down>n2 (h2 , v2 , p2) \<longrightarrow> equiv (E,h1v1,h2,v2) \<and> n1=n2 \<and> p1=p2"
*)

lemma TerminationMonotoneI:
"\<lbrakk>E \<turnstile> h0 , e1 \<Down>n (hh0 , IVal i , p1);  E \<turnstile> h0 , e1 \<Down>na (h1b , IVal ia , p1a);
          E<x:=ia> \<turnstile> h1b , e2 \<Down>mb (h2 , w , p2a)\<rbrakk>
       \<Longrightarrow> \<exists>h3 m w pp. E<x:=i> \<turnstile> hh0 , e2 \<Down>m (h3 , w , pp)"
apply (subgoal_tac "hh0=h1b \<and> i=ia", clarsimp) apply fast
(*currently our semantics is deterministic..*)
sorry

lemma TerminationMonotoneR:
"\<lbrakk>E \<turnstile> h0 , e1 \<Down>n (hh0 , RVal r , p1); E \<turnstile> h0 , e1 \<Down>na (h1b , RVal ra , p1a);
   E\<lfloor>x:=ra\<rfloor> \<turnstile> h1b , e2 \<Down>mb (h2 , w , p2a)\<rbrakk>
  \<Longrightarrow> \<exists>h2 m w pp. E\<lfloor>x:=r\<rfloor> \<turnstile> hh0 , e2 \<Down>m (h2 , w , pp)"
apply (subgoal_tac "hh0=h1b \<and> r=ra", clarsimp) apply fast
(*currently our semantics is deterministic..*)
sorry
lemma TerminationMonotoneV:
"\<lbrakk>E \<turnstile> h0 , e1 \<Down>n (hh0 , w , p1); E \<turnstile> h0 , e1 \<Down>na (h1b , wb , p1a);
          E \<turnstile> h1b , e2 \<Down>mb (h2 , wa , p2a)\<rbrakk>
       \<Longrightarrow> \<exists>h2 m w pp. E \<turnstile> hh0 , e2 \<Down>m (h2 , w , pp)"
apply (subgoal_tac "hh0=h1b \<and> w=wb", clarsimp) apply fast
(*currently our semantics is deterministic..*)
sorry

lemma TerminationFrame[rule_format]:
"E \<turnstile> h,e \<Down>n (hh,v,p) \<Longrightarrow> 
      (\<forall> h0 . (\<exists> h1. (HpDistinct h0 h1 \<and> HpUnion h0 h1 h)) \<longrightarrow>
              (\<exists> h0_ m w pp . E \<turnstile> h0,e \<Down>m (h0_,w,pp)) \<longrightarrow> 
              (\<exists> hh0 hh1 . E \<turnstile> h0,e \<Down>n (hh0,v,p) \<and> HpDistinct hh0 hh1 \<and> HpUnion hh0 hh1 hh))"
apply (erule semn.induct)
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (rule_tac x=h0 in exI, rule) apply (rule semNull[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (rule_tac x=h0 in exI, rule) apply (rule semInt[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (rule_tac x=h0 in exI, rule) apply (rule semIVar[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (rule_tac x=h0 in exI, rule) apply (rule semRVar[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (rule_tac x=h0 in exI, rule) apply (rule semPrimop[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (rule_tac x=h0 in exI, rule) apply (rule semRPrimop[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (rule_tac x=h0 in exI, rule)
  apply (subgoal_tac "h<a\<bullet>f> = h0<a\<bullet>f>", clarsimp) apply (rule semGetfi [simplified]) apply simp apply assumption
  apply (simp add: HpUnion_def)
  apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (rule_tac x=h0 in exI, rule)
  apply (subgoal_tac "h\<lfloor>a\<diamondsuit>f\<rfloor> = h0\<lfloor>a\<diamondsuit>f\<rfloor>", clarsimp) apply (rule semGetfr [simplified]) apply simp apply assumption
  apply (simp add: HpUnion_def)
  apply fast
apply clarsimp apply (erule eval_cases, clarify)
  apply (rule_tac x="h0<a\<bullet>f:=ienv E y>" in exI, rule, simp)
  apply (rule semPutfi[simplified]) apply simp apply assumption
  apply (rule_tac x=h1 in exI,rule) 
  apply (simp add: HpDistinct_def)
  apply (simp add: HpUnion_def  HpDistinct_def) apply rule apply fast apply clarsimp
   apply (erule_tac x=c in allE, erule_tac x=f in allE) apply fastsimp
apply clarsimp apply (erule eval_cases, clarify)
  apply (rule_tac x="h0\<lfloor>a\<diamondsuit>f:=renv E y\<rfloor>" in exI, rule, simp)
  apply (rule semPutfr[simplified]) apply simp apply assumption
  apply (rule_tac x=h1 in exI,rule) 
  apply (simp add: HpDistinct_def)
  apply (simp add: HpUnion_def  HpDistinct_def) apply rule apply fast apply clarsimp
   apply (erule_tac x=c in allE, erule_tac x=f in allE) apply fastsimp
apply clarsimp apply (erule eval_cases, clarify)
  apply (rule_tac x="h0" in exI, rule, simp)
  apply (subgoal_tac "h\<lbrace>c\<struct>f\<rbrace> = h0\<lbrace>c\<struct>f\<rbrace>", clarsimp) apply (rule semGetstat[simplified]) 
  apply (simp add: HpUnion_def)
  apply fast
apply clarsimp apply (erule eval_cases, clarify)
  apply (rule_tac x="h0\<lbrace>c\<struct>f:=renv E y\<rbrace>" in exI, rule, simp)
  apply (rule semPutstat[simplified]) 
  apply (rule_tac x="h1\<lbrace>c\<struct>f:=renv E y\<rbrace>" in exI,rule) 
  apply (simp add: HpDistinct_def)
  apply (simp add: HpUnion_def  HpDistinct_def) 
  apply clarsimp apply rule
   apply clarsimp apply (erule_tac x=c in allE, erule_tac x=fa in allE) apply fastsimp
   apply clarsimp apply (erule_tac x=ca in allE, erule_tac x=f in allE) apply fastsimp
defer 1
apply clarsimp apply (erule eval_cases, clarsimp) 
 apply (erule_tac x=h0 in allE) apply (erule impE) apply fast
 apply (erule impE) apply fast
 apply clarsimp
 apply (rule_tac x=hh0 in exI, rule)
  apply (rule semIf_True[simplified], assumption+)
  apply fast
 apply clarsimp
apply clarsimp apply (erule eval_cases, clarsimp) 
 apply (erule_tac x=h0 in allE) apply (erule impE) apply fast
 apply (erule impE) apply fast
 apply clarsimp
 apply (rule_tac x=hh0 in exI, rule)
  apply (rule semIf_False[simplified], assumption+)
  apply fast
apply clarsimp
 apply (erule_tac x=h0 in allE) apply (erule impE) apply fast
 apply (erule impE) apply (erule eval_cases) apply fast
 apply clarsimp
 apply (erule_tac x=hh0 in allE) apply (erule impE) apply fast
 apply (erule impE, erule eval_cases, clarsimp) apply (erule TerminationMonotoneI, assumption+) 
 apply clarsimp
 apply (rule_tac x=hh0a in exI, rule)
  apply (rule semLeti [simplified], assumption+)
  apply fast
apply clarsimp
 apply (erule_tac x=h0 in allE) apply (erule impE) apply fast
 apply (erule impE) apply (erule eval_cases) apply fast
 apply clarsimp
 apply (erule_tac x=hh0 in allE) apply (erule impE) apply fast
 apply (erule impE, erule eval_cases, clarsimp) apply (erule TerminationMonotoneR, assumption+) 
 apply clarsimp
 apply (rule_tac x=hh0a in exI, rule)
  apply (rule semLetr [simplified], assumption+)
  apply fast
apply clarsimp
 apply (erule_tac x=h0 in allE) apply (erule impE) apply fast
 apply (erule impE) apply (erule eval_cases) apply fast
 apply clarsimp
 apply (erule_tac x=hh0 in allE) apply (erule impE) apply fast
 apply (erule impE, erule eval_cases, clarsimp) apply (erule TerminationMonotoneV, assumption+)
 apply clarsimp
 apply (rule_tac x=hh0a in exI, rule)
  apply (rule semLetv [simplified], assumption+)
  apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
 apply (erule_tac x=h0 in allE, erule impE) apply fast
 apply (erule impE) apply fast
 apply clarsimp
 apply (rule_tac x=hh0 in exI, rule) apply (erule semCall[simplified])apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
 apply (subgoal_tac "C=Ca", clarsimp)
 prefer 2 apply (rotate_tac 2, erule thin_rl) apply (simp add: HpUnion_def, clarsimp) apply (erule_tac x=a in allE, clarsimp) 
    apply (erule impE, simp add: fmap_dom_def dom_def fmap_lookup_def, simp) 
 apply (erule_tac x=h0 in allE, erule impE) apply fast
 apply (erule impE) apply fast 
 apply clarsimp
 apply (rule_tac x=hh0 in exI, rule) apply (erule semInvoke[simplified], assumption+) apply simp apply assumption apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
 apply (erule_tac x=h0 in allE, erule impE) apply fast
 apply (erule impE) apply fast 
 apply clarsimp
 apply (rule_tac x=hh0 in exI, rule) apply (rule semInvokeStatic[simplified]) apply simp apply assumption apply fast
(*case new left*)
apply clarsimp apply (erule eval_cases, clarsimp) 
  apply (rule_tac x="newObj h0 (freshloc (Dom h)) E c ifldvals rfldvals" in exI, rule)
  apply (rule semNew[simplified]) defer 1
  apply (rule_tac x=h1 in exI, rule)
  apply (simp add: HpDistinct_def HpUnion_def newObj_def) apply (erule thin_rl)+ apply (simp add: freshloc_def) defer 1
  apply (simp add: HpUnion_def HpDistinct_def, safe)
sorry (*properties oif freshloc. will prove this once we have non-deterministic semantics*)

lemma "E \<turnstile> h,e \<Down>n (hh,v,p) \<Longrightarrow> (\<forall> h0 h1. HpDistinct h0 h1 \<longrightarrow> (HpUnion h0 h1 h \<longrightarrow>
          ((\<forall> hh0 v0 p0 m. \<not> E \<turnstile> h0,e \<Down>m (hh0,v0,p0)) \<or> (\<exists> hh0 hh1 . E \<turnstile> h0,e \<Down>n (hh0,v,p) \<and> HpDistinct hh0 hh1 \<and> HpUnion hh0 hh1 hh))))"
apply (erule semn.induct)
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (erule_tac x=h0 in allE, erule impE) apply (rule semNull[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (erule_tac x=h0 in allE, erule impE) apply (rule semInt[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (erule_tac x=h0 in allE, erule impE) apply (rule semIVar[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (erule_tac x=h0 in allE, erule impE) apply (rule semRVar[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (erule_tac x=h0 in allE, erule impE) apply (rule semPrimop[simplified]) apply fast
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (erule_tac x=h0 in allE, erule impE) apply (rule semRPrimop[simplified]) apply fast
apply (rule, rule, rule, rule)
  apply (case_tac "a:Dom h0")
  apply (rule disjI2)
  apply (rule_tac x=h0 in exI, rule_tac x=h1 in exI, rule) 
  apply (subgoal_tac "h<a\<bullet>f> = h0<a\<bullet>f>", clarsimp) apply (rule semGetfi [simplified]) apply simp apply assumption
  apply (simp add: HpUnion_def)
  apply fast
  apply (rule disjI1) apply clarsimp
  apply (erule eval_cases, clarsimp)
apply (rule, rule, rule, rule)
  apply (case_tac "a:Dom h0")
  apply (rule disjI2)
  apply (rule_tac x=h0 in exI,rule_tac x=h1 in exI, rule) 
  apply (subgoal_tac "h\<lfloor>a\<diamondsuit>f\<rfloor> = h0\<lfloor>a\<diamondsuit>f\<rfloor>", clarsimp) apply (rule semGetfr [simplified]) apply simp apply assumption
  apply (simp add: HpUnion_def)
  apply fast
  apply (rule disjI1) apply clarsimp
  apply (erule eval_cases, clarsimp)
apply (rule, rule, rule, rule)
  apply (case_tac "a:Dom h0")
  apply (rule disjI2)
  apply (rule_tac x="h0<a\<bullet>f:=ienv E y>" in exI, rule_tac x=h1 in exI,rule) 
  apply (rule semPutfi) apply simp apply assumption
  apply (rule, simp add: HpDistinct_def)
  apply (simp add: HpUnion_def  HpDistinct_def) apply rule apply fast apply clarsimp
   apply (erule_tac x=c in allE, erule_tac x=f in allE) apply fastsimp
  apply (rule disjI1) apply clarsimp
  apply (erule eval_cases, clarsimp)
apply (rule, rule, rule, rule)
  apply (case_tac "a:Dom h0")
  apply (rule disjI2)
  apply (rule_tac x="h0\<lfloor>a\<diamondsuit>f:=renv E y\<rfloor>" in exI, rule_tac x=h1 in exI, rule) 
  apply (rule semPutfr) apply simp apply assumption
  apply (rule, simp add: HpDistinct_def)
  apply (simp add: HpUnion_def  HpDistinct_def)  apply rule apply fast apply clarsimp
   apply (erule_tac x=c in allE, erule_tac x=f in allE) apply fastsimp 
  apply (rule disjI1) apply clarsimp
  apply (erule eval_cases, clarsimp)
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (erule_tac x=h0 in allE, erule impE)
  apply (subgoal_tac "h\<lbrace>c\<struct>f\<rbrace> = h0\<lbrace>c\<struct>f\<rbrace>", clarsimp) apply (rule semGetstat[simplified]) 
  apply (simp add: HpUnion_def  HpDistinct_def) apply fast 
apply clarsimp apply (erule eval_cases, clarsimp)
  apply (erule_tac x="h0\<lbrace>c\<struct>f:=renv E y\<rbrace>" in allE, erule impE, simp)
  apply (rule semPutstat[simplified])
  apply (erule_tac x="h1\<lbrace>c\<struct>f:=renv E y\<rbrace>" in allE) 
  apply (erule impE)
  apply (simp add:  HpDistinct_def) 
  apply (simp add: HpUnion_def HpDistinct_def)  apply clarsimp
  apply (erule impE)
  apply clarsimp
  apply (case_tac "ca=c", clarsimp) 
  apply (case_tac "fa=f", clarsimp) apply clarsimp apply (erule_tac x=c in allE, erule_tac x=fa in allE, clarsimp)
  apply clarsimp apply (erule_tac x=ca in allE, erule_tac x=fa in allE, clarsimp)
defer 1
apply clarsimp apply (erule eval_cases, clarsimp)
 apply (erule_tac x=h0 in allE) apply (rotate_tac -1) apply(erule_tac x=h1a in allE, clarsimp)
 apply (erule disjE) apply (rotate_tac -1, erule_tac x=hh0 in allE) apply fast
 apply clarsimp
 apply (erule_tac x=hh0a in allE) 
 apply (erule impE) 
 apply (rule semIf_True[simplified]) apply assumption+
 apply fast
 apply clarsimp 
apply clarsimp apply (erule eval_cases, clarsimp)
 apply (erule_tac x=h0 in allE) apply (rotate_tac -1) apply(erule_tac x=h1a in allE, clarsimp)
 apply (erule disjE) apply (rotate_tac -1, erule_tac x=hh0 in allE) apply fast
 apply clarsimp
 apply (erule_tac x=hh0a in allE) 
 apply (erule impE) 
 apply (rule semIf_False[simplified]) apply assumption+
 apply fast
defer 1 defer 1
apply clarsimp  apply (erule eval_cases, clarsimp)
 apply (erule_tac x=h0 in allE) apply (rotate_tac -1) apply(erule_tac x=h1a in allE, clarsimp)
 apply (erule disjE) apply (rotate_tac -1, erule_tac x=h1b in allE) apply fast
 apply clarsimp
 apply (erule_tac x=h1 in allE) apply (rotate_tac -1) apply(erule_tac x=hh1 in allE, clarsimp)
 apply (erule disjE) apply (rotate_tac -1, erule_tac x=h1b in allE) apply fast
 apply clarsimp
 apply (erule semIf_True[simplified]) apply assumption
done(*new*)
apply clarsimp apply (erule eval_cases, clarsimp)
h0  apply (erule_tac x="newObj h0 (freshloc (Dom h0)) E c ifldvals rfldvals" in allE)
  apply (erule impE) 
  apply (subgoal_tac "\<exists> l . l = freshloc (Dom h0) \<and> l = freshloc (Dom h)", erule exE, erule conjE) 
   apply (subgoal_tac "E \<turnstile> h0 , NEW <c> (ifldvals,rfldvals) \<Down>Suc 0 (newObj h0 l E c ifldvals
                                                        rfldvals , RVal (Ref l) , tickRo)", simp) apply (erule semNew[simplified]) 
   defer 1
  apply (erule_tac x=h1 in allE, erule impE)
   apply (simp add: HpDistinct_def)
   apply (subgoal_tac "renv Ea xa = Ref a \<Longrightarrow> Ea \<turnstile> ha , xa\<bullet>fa \<Down>Suc 0 (ha , IVal ha<a\<bullet>fa> , mkRescomp 2 0 0 0)", simp)
   apply fast

datatype rExp = rVar rname | rVal ref

consts interpret:: "rExp \<Rightarrow> env \<Rightarrow> ref"
primrec
"interpret (rVar x) E = E\<lfloor>x\<rfloor>"
"interpret (rVal r) E = r"

consts object::"(heap \<times>  locn \<times> (ifldname \<times> int) list \<times> (rfldname \<times> ref) list) \<Rightarrow> bool"
recdef object "measure (\<lambda> (h,l,iflds,rflds) . length iflds + length rflds)"
"object (h,l,[],[]) = True"
"object (h,l,[],(F,r) # t) = (h\<lfloor>l\<diamondsuit>F\<rfloor> = r \<and> object (h,l,[],t))"
"object (h,l,(F,i) # t, R) = (h<l\<bullet>F> = i \<and> object (h,l,t,R))"

constdefs maps::"rExp => (ifldname \<times> int) list \<Rightarrow> (rfldname \<times> ref) list \<Rightarrow> vdmassn" (" _ \<mapsto> _,_ " [1000,1000,1000] 1000)
"maps e iflds rflds E h hh v p \<equiv> \<exists> l . interpret e E = Ref l \<and> Dom h = {l} \<and> object(h,l,iflds,rflds)"

constdefs MAPS::"rExp => (ifldname \<times> int) list \<Rightarrow> (rfldname \<times> ref) list \<Rightarrow> vdmassn" (" _ \<leadsto> (_,_) " [1000,1000,1000] 1000)
"MAPS e iflds rflds E h hh v p \<equiv> \<exists> l . interpret e E = Ref l \<and> Dom hh = {l} \<and> object(hh,l,iflds,rflds)"

constdefs oHp_restr::"oheap \<Rightarrow> (locn set) \<Rightarrow> oheap"
"oHp_restr ohp S == Abs_Finmap(\<lambda> l . if l \<in> S then (Rep_Finmap ohp) l else None)"

constdefs Hp_restr::"heap \<Rightarrow> (locn set) \<Rightarrow> heap"
"Hp_restr h S == h\<lparr>oheap := oHp_restr (oheap h) S\<rparr>"

constdefs star::"vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn" (" _ \<star> _ " [1000,1000] 1000)
"star P Q \<equiv> \<lambda> E h hh v p . \<exists> H1 H2 . H1 \<inter> H2 = {} \<and> H1 \<union> H2 = Dom h \<and> 
                                      P E (Hp_restr h H1) hh v p \<and>  
                                      Q E (Hp_restr h H2) hh v p"

constdefs STAR::"vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn" (" _ \<div> _ " [1000,1000] 1000)
"STAR P Q \<equiv> \<lambda> E h hh v p . \<exists> H1 H2 . H1 \<inter> H2 = {} \<and> H1 \<union> H2 = Dom hh \<and> 
                                      P E h (Hp_restr hh H1) v p \<and>  
                                      Q E h (Hp_restr hh H2) v p"

constdefs true::vdmassn
"true == (\<lambda> E h hh v p . True)"

constdefs emp::vdmassn
"emp == (\<lambda> E h hh v p . Dom h = {})"
constdefs EMP::vdmassn
"EMP == (\<lambda> E h hh v p . Dom hh = {})"

lemma "P \<star> Q = Q \<star> P"
apply (rule, rule, rule, rule, rule, simp add: star_def, safe)
apply (rule_tac x=H2 in exI, rule_tac x=H1 in exI, fastsimp)
apply (rule_tac x=H2 in exI, rule_tac x=H1 in exI, fastsimp)
done
lemma "P \<div> Q = Q \<div> P"
apply (rule, rule, rule, rule, rule, simp add: STAR_def, safe)
apply (rule_tac x=H2 in exI, rule_tac x=H1 in exI, fastsimp)
apply (rule_tac x=H2 in exI, rule_tac x=H1 in exI, fastsimp)
done

lemma Dom_restr[simp]: "Dom (Hp_restr h S) = S"
apply (simp add: Hp_restr_def oHp_restr_def fmap_dom_def dom_def, auto)
sorry
lemma restr_restr[simp]:"Hp_restr (Hp_restr h S1) S2 = Hp_restr h (S1 \<inter> S2)"
apply (simp add: Hp_restr_def oHp_restr_def fmap_dom_def dom_def)
apply (rule)
apply auto
sorry
lemma restr_triv[simp]:"Hp_restr h (Dom h) = h"
apply (simp add: Hp_restr_def oHp_restr_def fmap_dom_def dom_def)
apply (rule)
apply auto
sorry

lemma "P \<star> emp = P"
by (rule, rule, rule, rule, rule, simp add: star_def emp_def)
lemma "P \<div> EMP = P"
by (rule, rule, rule, rule, rule, simp add: STAR_def EMP_def)

lemma "P \<star> (Q \<star> R) = (P \<star> Q) \<star> R"
apply (rule, rule, rule, rule, rule, simp add: star_def, safe)
apply (rule_tac x="H1a \<union> H1" in exI, rule_tac x=H2a in exI)
 apply rule apply fast
 apply rule apply fast
 apply rule apply (rule_tac x=H1 in exI, rule_tac x=H1a in exI)
   apply rule apply fast
   apply rule apply fast
   apply rule apply (subgoal_tac "(H1a \<union> H1) \<inter> H1 = H1", clarsimp) apply fast
    apply (subgoal_tac "(H1a \<union> H2a) \<inter> H1a = H1a", clarsimp)
    apply (subgoal_tac "(H1a \<union> H1) \<inter> H1a = H1a", clarsimp) apply fast apply fast
   apply (subgoal_tac "(H1a \<union> H2a) \<inter> H2a = H2a", clarsimp) apply fast
apply (rule_tac x="H1a" in exI, rule_tac x="H2a \<union> H2" in exI)
 apply rule apply fast
 apply rule apply fast
 apply rule apply (subgoal_tac "(H1a \<union> H2a) \<inter> H1a = H1a", clarsimp) apply fast 
 apply (rule_tac x=H2a in exI, rule_tac x=H2 in exI)
   apply rule apply fast
   apply rule apply fast
   apply rule apply (subgoal_tac "(H1a \<union> H2a) \<inter> H2a = H2a", clarsimp) 
              apply (subgoal_tac "(H2a \<union> H2) \<inter> H2a = H2a", clarsimp) apply fast apply fast
    apply (subgoal_tac "(H2a \<union> H2) \<inter> H2 = H2", clarsimp) apply fast 
done
lemma "P \<div> (Q \<div> R) = (P \<div> Q) \<div> R"
apply (rule, rule, rule, rule, rule, simp add: STAR_def, safe)
apply (rule_tac x="H1a \<union> H1" in exI, rule_tac x=H2a in exI)
 apply rule apply fast
 apply rule apply fast
 apply rule apply (rule_tac x=H1 in exI, rule_tac x=H1a in exI)
   apply rule apply fast
   apply rule apply fast
   apply rule apply (subgoal_tac "(H1a \<union> H1) \<inter> H1 = H1", clarsimp) apply fast
    apply (subgoal_tac "(H1a \<union> H2a) \<inter> H1a = H1a", clarsimp)
    apply (subgoal_tac "(H1a \<union> H1) \<inter> H1a = H1a", clarsimp) apply fast apply fast
   apply (subgoal_tac "(H1a \<union> H2a) \<inter> H2a = H2a", clarsimp) apply fast
apply (rule_tac x="H1a" in exI, rule_tac x="H2a \<union> H2" in exI)
 apply rule apply fast
 apply rule apply fast
 apply rule apply (subgoal_tac "(H1a \<union> H2a) \<inter> H1a = H1a", clarsimp) apply fast 
 apply (rule_tac x=H2a in exI, rule_tac x=H2 in exI)
   apply rule apply fast
   apply rule apply fast
   apply rule apply (subgoal_tac "(H1a \<union> H2a) \<inter> H2a = H2a", clarsimp) 
              apply (subgoal_tac "(H2a \<union> H2) \<inter> H2a = H2a", clarsimp) apply fast apply fast
    apply (subgoal_tac "(H2a \<union> H2) \<inter> H2 = H2", clarsimp) apply fast 
done

consts V0::ifldname
consts R1::rfldname

consts models_list :: "int list \<Rightarrow> rExp \<Rightarrow> vdmassn"
primrec
"models_list [] e = (\<lambda> E h hh v p . interpret e E = Nullref)"
"models_list (i # t) e = (\<lambda> E h hh v p . (\<exists> r . ((e \<mapsto> [(V0,i)],[(R1,r)]) \<star> (models_list t (rVal r))) E h hh v p))"

consts MODELS_list :: "int list \<Rightarrow> rExp \<Rightarrow> vdmassn"
primrec
"MODELS_list [] e = (\<lambda> E h hh v p . interpret e E = Nullref)"
"MODELS_list (i # t) e = (\<lambda> E h hh v p . (\<exists> r . ((e \<leadsto> [(V0,i)],[(R1,r)]) \<div> (MODELS_list t (rVal r))) E h hh v p))"

constdefs implies::"vdmassn \<Rightarrow> vdmassn \<Rightarrow> vdmassn" (" _ \<longmapsto> _ " [1000,1000] 1000)
"implies A B \<equiv> (\<lambda> E h hh v p . A E h hh v p \<longrightarrow> B E h hh v p)"

constdefs rRESULT::"(rExp \<Rightarrow> vdmassn) \<Rightarrow> vdmassn"
"rRESULT f \<equiv> (\<lambda> E h hh v p . \<exists> r . v = RVal r \<and> f (rVal r) E h hh v p)"

lemma modelslist_MODELSlist[rule_format]:
"\<forall> w1 w2 h h1 h2 E v p EE w pp. (models_list a w1 E h h1 v p \<longrightarrow> interpret w1 E = interpret w2 EE \<longrightarrow> MODELS_list a w2 EE h2 h w pp)"
apply (induct a)
apply simp
apply (simp add: star_def STAR_def, clarsimp)
apply (rule_tac x=r in exI, rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp)
apply (simp add: maps_def MAPS_def)
apply (erule_tac x="rVal r" in allE)
apply (erule_tac x="rVal r" in allE)
apply (erule_tac x="Hp_restr h H2" in allE)
apply (erule_tac x="h1" in allE)
apply (erule_tac x="h2" in allE)
apply (erule_tac x="E" in allE)
apply clarsimp
apply (erule impE) apply fast
apply fastsimp
done

lemma MODELSlist_modelslist[rule_format]:
"\<forall> w1 w2 h h1 h2 E v p EE w pp. (MODELS_list a w1 E h1 h v p \<longrightarrow> interpret w1 E = interpret w2 EE \<longrightarrow> models_list a w2 EE h h2 w pp)"
apply (induct a)
apply simp
apply (simp add: star_def STAR_def, clarsimp)
apply (rule_tac x=r in exI, rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp)
apply (simp add: maps_def MAPS_def)
apply (erule_tac x="rVal r" in allE)
apply (erule_tac x="rVal r" in allE)
apply (erule_tac x="Hp_restr h H2" in allE)
apply (erule_tac x="h1" in allE)
apply (erule_tac x="h2" in allE)
apply (erule_tac x="E" in allE)
apply clarsimp
apply (erule impE) apply fast
apply fastsimp
done

lemma modelslist_modelslist[rule_format]:
"\<forall> w1 w2 h h1 h2 E v p EE w pp. (models_list a w1 E h h1 v p \<longrightarrow> interpret w1 E = interpret w2 EE \<longrightarrow> models_list a w2 EE h h2 w pp)"
apply (induct a)
apply simp
apply (simp add: star_def, clarsimp)
apply (rule_tac x=r in exI, rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp)
apply (simp add: maps_def)
apply (erule_tac x="rVal r" in allE)
apply (erule_tac x="rVal r" in allE)
apply (erule_tac x="Hp_restr h H2" in allE)
apply (erule_tac x="h1" in allE)
apply (erule_tac x="h2" in allE)
apply (erule_tac x="E" in allE)
apply clarsimp
apply (erule impE) apply fast
apply fastsimp
done

lemma MODELSlist_MODELSlist[rule_format]:
"\<forall> w1 w2 h h1 h2 E v p EE w pp. (MODELS_list a w1 E h1 h v p \<longrightarrow> interpret w1 E = interpret w2 EE \<longrightarrow> MODELS_list a w2 EE h2 h w pp)"
apply (induct a)
apply simp
apply (simp add: STAR_def, clarsimp)
apply (rule_tac x=r in exI, rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp)
apply (simp add: MAPS_def)
apply (erule_tac x="rVal r" in allE)
apply (erule_tac x="rVal r" in allE)
apply (erule_tac x="Hp_restr h H2" in allE)
apply (erule_tac x="h1" in allE)
apply (erule_tac x="h2" in allE)
apply (erule_tac x="E" in allE)
apply clarsimp
apply (erule impE) apply fast
apply fastsimp
done

lemma "G \<rhd> RVar x : ((models_list a (rVar x)) \<longmapsto> (rRESULT (\<lambda> r . MODELS_list a r)))"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: implies_def rRESULT_def, clarsimp)
apply (erule modelslist_MODELSlist)
apply simp
done
lemma "G \<rhd> RVar x : (((models_list a (rVar x)) \<star> P) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list a r))))"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: implies_def rRESULT_def, clarsimp)
apply (simp add: star_def STAR_def, clarsimp)
sorry
lemma "G \<rhd> RVar x : (((models_list a (rVar x)) \<star> P) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list a r)) \<div> P))"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: implies_def rRESULT_def, clarsimp)
apply (simp add: star_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp)
apply (rule,erule modelslist_MODELSlist)
apply simp
sorry
lemma "G \<rhd> RVar x : (((models_list a (rVar x)) \<star> P) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list a r)) \<star> P))"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: implies_def rRESULT_def, clarsimp)
apply (simp add: star_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp)
apply (rule modelslist_MODELSlist)
sorry
lemma "G \<rhd> RVar x : (((models_list a (rVar x)) \<star> P) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list a r)) \<div> true))"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: implies_def rRESULT_def, clarsimp)
apply (simp add: star_def STAR_def true_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp)
apply (erule modelslist_MODELSlist)
apply simp
done
lemma "G \<rhd> RVar x : (((models_list a (rVar x))) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list a r)) \<div> true))"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: implies_def rRESULT_def, clarsimp)
apply (simp add: STAR_def true_def)
apply (rule_tac x="Dom h" in exI, rule_tac x="{}" in exI, simp)
apply (erule modelslist_MODELSlist)
apply simp
done

lemma "G \<rhd> RVar x : (((models_list a (rVar x)) \<star> (models_list b (rVar y))) \<longmapsto> 
                     ((rRESULT (\<lambda> r . MODELS_list a r)) \<div> (MODELS_list b (rVar y))))"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: implies_def rRESULT_def, clarsimp)
apply (simp add: star_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp)
apply (rule,erule modelslist_MODELSlist)
apply simp
apply (erule modelslist_MODELSlist)
apply simp
done

lemma "G \<rhd> RVar x : (((models_list a (rVar x)) \<star> (models_list b (rVar y))) \<longmapsto> 
                     (\<lambda> E h hh v p . (a \<noteq> [] \<or> b \<noteq> []) \<longrightarrow> x \<noteq> y))"
apply (rule vdm_conseq, rule vdm_rvar)
apply (simp add: implies_def, clarsimp)
apply (simp add: star_def maps_def, clarsimp)
apply (case_tac a)
apply (case_tac b)
apply simp
apply (simp add: star_def maps_def)
apply (case_tac b)
apply (simp add: star_def maps_def)
apply (simp add: star_def maps_def)
apply clarsimp
done

lemma L1:"\<lbrakk>G \<rhd> e : (((models_list a (rVar y))) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list b r))))\<rbrakk> \<Longrightarrow>
       G \<rhd> e : ( ((((models_list a (rVar y)))) \<star> (models_list d (rVar y))) \<longmapsto> 
                  (((rRESULT (\<lambda> r . MODELS_list b r))) \<star> (models_list d (rVar y))))"
apply (rule vdm_conseq)
apply (drule vdm_sound_ctxt)
apply (simp add: vdm_valid_in_ctxt_def vdm_context_valid_def vdm_valid_def)
apply (erule vdm_conseq, clarsimp)
apply (simp add: implies_def star_def, clarsimp)
apply (erule impE) 
apply (rule_tac x="H1" in exI, rule_tac x="H2" in exI) 
apply (rule, fast) 
apply (rule, fast) 
apply (simp add: true_def)
apply (rule_tac x="H1" in exI, rule_tac x=H2 in exI, simp)
apply (simp add: STAR_def rRESULT_def, clarsimp) 
apply (rule_tac x="H1a" in exI, rule_tac x=H2a in exI, simp)
apply rule
apply (erule MODELSlist_MODELSlist, simp)
apply (simp add: true_def)
done

lemma "\<lbrakk>G \<rhd> e : ((models_list a (rVar y)) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list b r))));
        G \<rhd> ee : (((models_list b (rVar x)) \<star> (models_list d (rVar z))) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list c r)) \<div> (MODELS_list d (rVar z))))
       \<rbrakk> \<Longrightarrow>
       G \<rhd> (LET rf x = e IN ee END): ((models_list a (rVar y)) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list c r)) \<div> true))"
apply (rule vdm_conseq) apply (rule vdm_letr)
apply (simp add: vdm_valid_in_ctxt_def, clarsimp)
apply (simp add: vdm_valid_def, clarsimp)
apply (simp add: sem_def, clarsimp)
apply (erule semn.elims, simp_all, clarsimp)
apply(,erule vdm_letr, assumption)
apply (erule thin_rl)+
apply (simp add: implies_def, clarsimp)
apply (erule impE)
apply (erule modelslist_modelslist, simp)
apply (rotate_tac 1, erule thin_rl)
apply (erule impE)
apply (simp add: rRESULT_def star_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp add: true_def)
apply (erule MODELSlist_modelslist) apply simp
apply (erule thin_rl)
apply (simp add: rRESULT_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp add: true_def)
apply (erule MODELSlist_MODELSlist) apply simp
done

lemma "\<lbrakk>G  \<Turnstile> e : ((models_list a (rVar y)) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list b r))));
        G  \<Turnstile> ee : (((models_list b (rVar x)) \<star> (models_list d (rVar z))) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list c r)) \<div> (MODELS_list d (rVar z))))
       \<rbrakk> \<Longrightarrow>
       G  \<Turnstile> (LET rf x = e IN ee END): ((models_list a (rVar y)) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list c r)) \<div> true))"
apply (simp add: vdm_valid_in_ctxt_def, clarsimp)
apply (simp add: vdm_valid_def, clarsimp)
apply (simp add: sem_def, clarsimp)
apply (erule semn.elims, simp_all, clarsimp)
apply(,erule vdm_letr, assumption)
apply (erule thin_rl)+
apply (simp add: implies_def, clarsimp)
apply (erule impE)
apply (erule modelslist_modelslist, simp)
apply (rotate_tac 1, erule thin_rl)
apply (erule impE)
apply (simp add: rRESULT_def star_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp add: true_def)
apply (erule MODELSlist_modelslist) apply simp
apply (erule thin_rl)
apply (simp add: rRESULT_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp add: true_def)
apply (erule MODELSlist_MODELSlist) apply simp
done

lemma "\<lbrakk>G \<rhd> e : ((models_list a (rVar y)) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list b r)) \<div> true));
        G \<rhd> ee : (((models_list b (rVar x)) \<star> true) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list c r)) \<div> true))
       \<rbrakk> \<Longrightarrow>
       G \<rhd> (LET rf x = e IN ee END): ((models_list a (rVar y)) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list c r)) \<div> true))"
apply (rule vdm_conseq,erule vdm_letr, assumption)
apply (erule thin_rl)+
apply (simp add: implies_def, clarsimp)
apply (erule impE)
apply (erule modelslist_modelslist, simp)
apply (rotate_tac 1, erule thin_rl)
apply (erule impE)
apply (simp add: rRESULT_def star_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp add: true_def)
apply (erule MODELSlist_modelslist) apply simp
apply (erule thin_rl)
apply (simp add: rRESULT_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp add: true_def)
apply (erule MODELSlist_MODELSlist) apply simp
done

lemma "\<lbrakk>G \<rhd> e : (((models_list a (rVar y)) \<star> true) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list b r)) \<div> true))\<rbrakk> \<Longrightarrow>
       G \<rhd> e : ( ((((models_list a (rVar y)) \<star> true)) \<star> (models_list d (rVar y))) \<longmapsto> 
                  (((rRESULT (\<lambda> r . MODELS_list b r)) \<div> true) \<star> (models_list d (rVar y))))"
apply (erule vdm_conseq, clarsimp)
apply (simp add: implies_def star_def, clarsimp)
apply (erule impE) 
apply (rule_tac x="H1a" in exI, rule_tac x="H2a \<union> H2" in exI) 
apply (rule, fast) 
apply (rule, fast) 
apply (subgoal_tac "(H1a \<union> H2a) \<inter> H1a = H1a", clarsimp)
apply (simp add: true_def)
apply fast
apply (simp add: STAR_def, clarsimp)
apply (rule_tac x="H1a \<union> H2a" in exI, rule_tac x=H2 in exI, simp)
apply (rule_tac x="H1" in exI, rule_tac x=H2b in exI, simp)
apply rule apply (simp add: rRESULT_def, clarsimp) 
apply (erule MODELSlist_MODELSlist, simp)
apply (simp add: true_def)
done

lemma L1:"\<lbrakk>G \<rhd> e : (((models_list a (rVar y)) \<star> true) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list b r)) \<div> true))\<rbrakk> \<Longrightarrow>
       G \<rhd> e : ( ((((models_list a (rVar y)))) \<star> (models_list d (rVar y))) \<longmapsto> 
                  (((rRESULT (\<lambda> r . MODELS_list b r)) \<div> true) \<star> (models_list d (rVar y))))"
apply (erule vdm_conseq, clarsimp)
apply (simp add: implies_def star_def, clarsimp)
apply (erule impE) 
apply (rule_tac x="H1" in exI, rule_tac x="H2" in exI) 
apply (rule, fast) 
apply (rule, fast) 
apply (simp add: true_def)
apply (rule_tac x="H1" in exI, rule_tac x=H2 in exI, simp)
apply (simp add: STAR_def rRESULT_def, clarsimp) 
apply (rule_tac x="H1a" in exI, rule_tac x=H2a in exI, simp)
apply rule
apply (erule MODELSlist_MODELSlist, simp)
apply (simp add: true_def)
done

lemma L2:
"\<lbrakk>G \<rhd> e : (((models_list a (rVar y)) \<star> true) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list b r)) \<div> true))\<rbrakk> \<Longrightarrow>
       G \<rhd> e : ( ((((models_list a (rVar y)) \<star> true)) \<div> (models_list d (rVar y))) \<longmapsto> 
                  (((rRESULT (\<lambda> r . MODELS_list b r)) \<div> true) \<div> (models_list d (rVar y))))"
apply (erule vdm_conseq)
apply (simp add: implies_def STAR_def star_def, clarsimp)
apply (erule impE) 
apply (rule_tac x="H1a" in exI, rule_tac x="H2a" in exI) 
apply (rule, fast) 
apply (rule, fast) 
apply (rule, erule modelslist_modelslist, simp) apply (simp add: true_def)
apply clarsimp
apply (rule_tac x="H1b" in exI, rule_tac x=H2b in exI, simp)
apply rule
apply (rule_tac x="H1b" in exI, rule_tac x="{}" in exI, simp)
apply (simp add: true_def)
apply (erule modelslist_modelslist, simp)
done

lemma "\<lbrakk>G \<rhd> e : (((models_list a (rVar y))\<star> true) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list b r)) \<div> true));
        G \<rhd> ee : (((models_list b (rVar x)) \<star> (models_list d (rVar y))) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list c r)) \<div> (MODELS_list d (rVar y))))
       \<rbrakk> \<Longrightarrow>
       G \<rhd> (LET rf x = e IN ee END): (((models_list a (rVar y)) \<star> (models_list d (rVar y))) \<longmapsto> ((rRESULT (\<lambda> r . MODELS_list c r)) \<div> true))"
apply (rule vdm_conseq,rule vdm_letr)
apply (erule L2)
apply assumption
apply (erule thin_rl)+
apply (simp add: implies_def, clarsimp)
apply (erule impE)
apply (erule thin_rl)
apply (simp add: STAR_def star_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp)
apply (rule, erule modelslist_modelslist, simp) apply(erule modelslist_modelslist, simp)
apply (rotate_tac 1, erule thin_rl)
apply (erule impE)
apply (simp add: rRESULT_def star_def star_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp)
apply (rule, erule MODELSlist_modelslist, simp)
apply (erule thin_rl)
apply (simp add: rRESULT_def STAR_def, clarsimp)
apply (rule_tac x=H1 in exI, rule_tac x=H2 in exI, simp add: true_def)
apply (erule MODELSlist_MODELSlist) apply simp
done



apply (simp add: star_def maps_def, clarsimp)
apply (case_tac a)
apply (case_tac b)
apply simp
apply (simp add: star_def maps_def)
apply (case_tac b)
apply (simp add: star_def maps_def)
apply (simp add: star_def maps_def)
apply clarsimp
done
done
end
