theory Registers = VDMderived :

types effect = "(iname set) \<times> (rname set)"

constdefs getIVarargs::"ARGTYPE \<Rightarrow> iname set"
"getIVarargs y == (List.foldl (\<lambda> S a . (case a of (INarg x) \<Rightarrow> insert x S
                                                      | (RNarg x) \<Rightarrow> S
                                                      | (VALarg v) \<Rightarrow> S))
                                             ({}::iname set)) y"
constdefs getRVarargs::"ARGTYPE \<Rightarrow> rname set"
"getRVarargs y == (List.foldl (\<lambda> S a . (case a of (INarg x) \<Rightarrow> S
                                                       | (RNarg x) \<Rightarrow> insert x S
                                                       | (VALarg v) \<Rightarrow> S)) ({}::rname set) y)"

consts Get_effect::"expr \<Rightarrow> effect"
primrec
"Get_effect (IVar x) = ({x}, {})"
"Get_effect (RVar x) = ({},{x})"
"Get_effect (Primop f x y) = ({x,y}, {})"
"Get_effect (RPrimop f x y) = ({},{x,y})"

"Get_effect (x\<bullet>T) = ({},{x})"
"Get_effect (x\<diamondsuit>T) = ({},{x})"
"Get_effect (x\<bullet>T := y) = ({y}, {x})"
"Get_effect (x\<diamondsuit>T := y) = ({},{x,y})"
"Get_effect (c\<struct>T := y) = ({},{y})"

"Get_effect (New c iflds rflds) = (set(List.map snd iflds), set(List.map snd rflds))"
"Get_effect (A\<diamondsuit>m(y)) =  (getIVarargs y, insert A (getRVarargs y))"
"Get_effect (C\<bullet>m(y)) = (getIVarargs y, getRVarargs y)"
"Get_effect (Leti x e1 e2) = ({x},{})"
"Get_effect (Letr x e1 e2) = ({}, {x})"
"Get_effect (Ifg x e1 e2) = ({x}, {})"

constdefs Register ::"effect EFF"
"Register == \<lparr>
  Int_effect = (\<lambda> eEh . ({},{})),
  IVar_effect = (\<lambda> eEh . Get_effect (fst eEh)),
  Primop_effect = (\<lambda> eEh . Get_effect (fst eEh)),
  Null_effect = (\<lambda> eEh . ({},{})),
  RVar_effect = (\<lambda> eEh . Get_effect (fst eEh)),
  RPrimop_effect = (\<lambda> eEh . Get_effect (fst eEh)),
  New_effect = (\<lambda> eEh . Get_effect (fst eEh)),
  GetFi_effect = (\<lambda> eEh . Get_effect (fst eEh)),
  GetFr_effect = (\<lambda> eEh . Get_effect (fst eEh)),
  PutFi_effect = (\<lambda> eEh . Get_effect (fst eEh)),
  PutFr_effect = (\<lambda> eEh . Get_effect (fst eEh)),
  GetStat_effect = (\<lambda> eEh . ({},{})),
  PutStat_effect = (\<lambda> eEh .  Get_effect (fst eEh)),

  InvV_effect = (\<lambda> eEh p . let P=Get_effect (fst eEh) in (fst P \<union> fst p, snd P \<union> snd p)),
  InvS_effect = (\<lambda> eEh p . let P=Get_effect (fst eEh) in (fst P \<union> fst p, snd P \<union> snd p)),
     
  Leti_effect = (\<lambda> eEh p1 p2 . let P=Get_effect (fst eEh) in (fst P \<union> fst p1 \<union> fst p2, snd P \<union> snd p1 \<union> snd p2)),
  Letr_effect = (\<lambda> eEh p1 p2 . let P=Get_effect (fst eEh) in (fst P \<union> fst p1 \<union> fst p2, snd P \<union> snd p1 \<union> snd p2)),
  Letv_effect = (\<lambda> eEh p1 p2 . (fst p1 \<union> fst p2, snd p1 \<union> snd p2)),
  If_effect = (\<lambda> eEh p. let P=Get_effect (fst eEh) in (fst P \<union> fst p, snd P \<union> snd p)),
  Call_effect = (\<lambda> eEh p . p)\<rparr>"

constdefs Even::mname
"Even == MN ''Even''"
constdefs Odd::mname
"Odd == MN ''Odd''"
constdefs x::iname
"x == In ''x''"
constdefs y::iname
"y == In ''y''"
constdefs b::iname
"b == In ''b''"
consts SysC::cname
axioms MT_even:
  "methtable SysC Even = ([INpar x], LET   b = x :0?; x = x :-- IN IF b THEN tt ELSE SysC\<bullet>Odd([INarg x]) END)"
axioms MT_odd:
  "methtable SysC Odd = ([INpar y], LET   b = y :0?; y = y :-- IN IF b THEN ff ELSE SysC\<bullet>Even([INarg y]) END)"

(*constdefs evenSpec::"ARGTYPE \<Rightarrow> effect vdmassn"
"evenSpec z ==  (\<lambda> P E h hh v p. z = [INarg y] \<longrightarrow> P = Register \<longrightarrow> p = ({x,b,y},{}))"
constdefs oddSpec::"ARGTYPE \<Rightarrow> effect vdmassn"
"oddSpec z ==  (\<lambda> P E h hh v p. z = [INarg x] \<longrightarrow> P = Register \<longrightarrow> p = ({x,b,y},{}))"
*)

constdefs evenSpec::"ARGTYPE \<Rightarrow> effect vdmassn"
"evenSpec z ==  (\<lambda> P E h hh v p. (\<forall> a . (z=[INarg a]) \<longrightarrow> P = Register \<longrightarrow> ((E<a> = 0 \<longrightarrow> p = ({a, x,b},{})) \<and> 
                                                                             (0 < E<a> \<longrightarrow> p = ({a, x,b,y},{})))))"
constdefs oddSpec::"ARGTYPE \<Rightarrow> effect vdmassn"
"oddSpec z ==  (\<lambda> P E h hh v p. (\<forall> a . (z=[INarg a]) \<longrightarrow> P = Register \<longrightarrow> ((E<a> = 0 \<longrightarrow> p = ({a, y,b},{})) \<and> 
                                                                             (0 < E<a> \<longrightarrow> p = ({a, x,b,y},{})))))"

consts FST ::"effect FS_T"
       vMST::"effect vMS_T"
constdefs sMST::"effect sMS_T"
"sMST == (\<lambda> c m y . if c=SysC \<and> m = Even then evenSpec y else
                    if c=SysC \<and> m = Odd then oddSpec y else (\<lambda> P E h hh v p . False))"

constdefs G::"effect vdmcontext"
"G == {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}"

lemma G_good: "goodContext FST vMST sMST G"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (simp add: G_def)
apply (erule disjE)
apply (rule disjI2, rule disjI2)
apply clarsimp
  apply (simp add: MT_even)
  apply (rule vdm_conseq)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_if) 
  apply (rule vdm_int)
  apply (rule vdm_ax) 
    apply (subgoal_tac "(SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])
         \<in> {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}",
            assumption) apply simp
  apply clarsimp apply (case_tac "E<x>=0")
  apply clarsimp apply (simp add: b_def x_def y_def sMST_def newframe_env_def evalARGS_def evenSpec_def Register_def
    getIVarargs_def getRVarargs_def Let_def) apply clarsimp apply fast
  apply clarsimp apply (simp add: b_def x_def y_def sMST_def newframe_env_def evalARGS_def oddSpec_def evenSpec_def Register_def) 
    apply clarsimp 
    apply(simp add: x_def b_def y_def Even_def Odd_def oddSpec_def getIVarargs_def
                    getRVarargs_def Let_def Register_def) apply clarsimp
    apply (case_tac "ienv E' ad - 1 = 0") 
     apply clarsimp apply fast
     apply clarsimp apply fast
  apply clarsimp 
  apply (simp add: MT_odd)
  apply (rule vdm_conseq)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_if) 
  apply (rule vdm_int)
  apply (rule vdm_ax) 
    apply (subgoal_tac "(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y])
         \<in> {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}",
            assumption) apply simp
  apply clarsimp apply (case_tac "E<y>=0")
  apply clarsimp apply (simp add: Even_def Odd_def b_def x_def y_def sMST_def newframe_env_def evalARGS_def oddSpec_def Register_def getIVarargs_def getRVarargs_def Let_def) apply clarsimp apply fast
  apply clarsimp apply (simp add: b_def x_def y_def sMST_def newframe_env_def evalARGS_def oddSpec_def evenSpec_def Register_def x_def b_def y_def Even_def Odd_def oddSpec_def getIVarargs_def getRVarargs_def Let_def Register_def) 
   apply clarsimp apply (case_tac "ienv E' ad - 1 = 0") 
     apply clarsimp apply fast
     apply clarsimp apply fast
done

lemma Even1: "\<rhd> (SysC\<bullet>Even([INarg y])) : evenSpec [INarg y]" 
apply (rule MUTREC)
apply (subgoal_tac "finite G", assumption, simp add: G_def)
apply (simp add: G_def)
apply (rule G_good)
apply (simp add: G_def Even_def Odd_def sMST_def)
done
lemma Even2: "\<rhd> (SysC\<bullet>Even([INarg z])) : sMST SysC Even [INarg z]" 
apply (rule GCInvs)
apply (rule G_good)
apply (simp add: G_def)
apply (simp add: G_def Even_def Odd_def)
apply fast
done
lemma Even3: "\<rhd> (SysC\<bullet>Even([INarg z])) : evenSpec [INarg z]" 
apply (rule vdm_conseq)
apply (rule Even2)
apply (simp add: sMST_def)
done
lemma "\<rhd> (SysC\<bullet>Even([INarg z])) :  (\<lambda> P E h hh v p . (P=Register \<longrightarrow> (E<z> = 5 \<longrightarrow> p=({z,y,b,x},{}))))"
apply (rule vdm_conseq, rule Even3)
apply (simp add: evenSpec_def, clarsimp) apply fast
done
lemma "\<rhd> (SysC\<bullet>Even([INarg z])) :  (\<lambda> P E h hh v p . (P=Register \<longrightarrow> (E<z> = 0 \<longrightarrow> p=({z,b,x},{}))))"
apply (rule vdm_conseq, rule Even3)
apply (simp only: evenSpec_def) apply fast
done

lemma Odd1: "\<rhd> (SysC\<bullet>Odd([INarg x])) : oddSpec [INarg x]" 
apply (rule MUTREC)
apply (subgoal_tac "finite G", assumption, simp add: G_def)
apply (simp add: G_def)
apply (rule G_good)
apply (simp add: G_def Even_def Odd_def sMST_def)
done
lemma Odd2: "\<rhd> (SysC\<bullet>Odd([INarg z])) : sMST SysC Odd [INarg z]" 
apply (rule GCInvs)
apply (rule G_good)
apply (simp add: G_def)
apply (simp add: G_def Even_def Odd_def)
apply fast
done
lemma Odd3: "\<rhd> (SysC\<bullet>Odd([INarg z])) : oddSpec [INarg z]" 
apply (rule vdm_conseq)
apply (rule Odd2)
apply (simp add: sMST_def Odd_def Even_def)
done

lemma "\<rhd> (SysC\<bullet>Odd([INarg z])) :  (\<lambda> P E h hh v p . (P=Register \<longrightarrow> (E<z> = 5 \<longrightarrow> p=({z,y,b,x},{}))))"
apply (rule vdm_conseq, rule Odd3)
apply (simp only: oddSpec_def) apply fastsimp
done
lemma "\<rhd> (SysC\<bullet>Odd([INarg z])) :  (\<lambda> P E h hh v p . (P=Register \<longrightarrow> (E<z> = 0 \<longrightarrow> p=({z,b,y},{}))))"
apply (rule vdm_conseq, rule Odd3)
apply (simp only: oddSpec_def) apply fast
done
lemma "\<rhd> (SysC\<bullet>Odd([INarg y])) :  (\<lambda> P E h hh v p . (P=Register \<longrightarrow> (E<y> = 0 \<longrightarrow> p=({b,y},{}))))"
apply (rule vdm_conseq, rule Odd3)
apply (simp only: oddSpec_def) apply fast
done

end
