theory Policy1 = test:
(* Here is a policy that requires the first argument to the system method 
 to be an integer argument that is less than 42*)
defs Policy1:
"InvS_policy e E h p == 
   \<forall> y . (e = SysC\<bullet>SysM(y) \<longrightarrow> (case y of [] \<Rightarrow> False
                                   | (arg # args) \<Rightarrow> (case arg of INarg x \<Rightarrow> (E<x> < 42)
                                                                     | RNarg x \<Rightarrow> False
                                                                     | VALarg v \<Rightarrow> case v of IVal i \<Rightarrow> i < 42
                                                                                           | RVal r \<Rightarrow> False)))"

(*Specialising vdmSys for this policy gives a more readable form*)
lemma vdmSysExplicit:" \<rhd> (SysC\<bullet>SysM([INarg x])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> p = (E<x> < 42))"
by (rule vdm_conseq, rule vdmSys, simp add: InvS_effect_def Policy1)

(*A first test of the policy*)
lemma " \<rhd> (Leti x (expr.Int 21) (SysC\<bullet>SysM([INarg x]))): (\<lambda> E h hh v p. p = True)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdmSysExplicit, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
done
(*Second test*)
lemma "{} \<rhd> (Leti x (expr.Int 55) (SysC\<bullet>SysM([INarg x]))): (\<lambda> E h hh v p. p = False)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdmSysExplicit, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
done
(*More general:*)
lemma "{} \<rhd> (Leti x (expr.Int i) (SysC\<bullet>SysM([INarg x]))): (\<lambda> E h hh v p. p = (i < 42))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdmSysExplicit, clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
done

(*policy-independent proof rule for immediate integer arguments*)
lemma vdmSys2:" \<rhd> (SysC\<bullet>SysM([VALarg (IVal i)])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                           p = InvS_policy (SysC\<bullet>SysM([VALarg (IVal i)])) E h True)"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: InvS_effect_def)
apply (simp add: Null_effect_def)
done

(*policy-independent proof rule for reference arguments*)
lemma vdmSys3:" \<rhd> (SysC\<bullet>SysM([RNarg y])) : (\<lambda> E h hh v p . h=hh \<and> v= RVal Nullref \<and> 
                                                           p = InvS_policy (SysC\<bullet>SysM([RNarg y])) E h True)"
apply (rule vdm_invokestatic)
apply clarsimp
apply (simp add: MTSys)
apply (rule vdm_conseq)
apply (rule vdm_null)
apply clarsimp
apply (simp add: InvS_effect_def)
apply (simp add: Null_effect_def)
done

(*we can prove that a reference argument violates policy1*)
lemma " \<rhd> (Leti x (expr.Int 21) (SysC\<bullet>SysM([RNarg y]))): (\<lambda> E h hh v p. p = False)"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdmSys3)
apply( clarsimp)
apply (simp add: Leti_effect_def Int_effect_def) 
apply (simp add: Policy1)
done
end
