theory InsSortNondestrProof = InsSortNondestrProg + VCG:

defs SPEC_def:"SPEC M == 
  (if M = Ins then \<lbrace> {l_}, 1, emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0 1)) \<ggreater> ListET 0 0, 0\<rbrace> else
  if M = Sort then \<lbrace> {l_}, 0, emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0 0)) \<ggreater> ListET 0 0, 0\<rbrace> else
  (\<lambda> E h hh v p . False))"
text{*FST and vMST remain unspecified.*}

text {*In order to prove the body correct we define a 
       context which contains an one entry for each syntactic method invocation.*}
constdefs  InsSortContext:: vdmcontext
"InsSortContext \<equiv> {(InsSort\<bullet>Ins([INarg a_,RNarg v2_]), sMST InsSort Ins [INarg a_, RNarg v2_]),
                   (InsSort\<bullet>Ins([INarg v3_,RNarg l_]), sMST InsSort Ins [INarg v3_, RNarg l_]),
                   (InsSort\<bullet>Sort([RNarg v2_]), sMST InsSort Sort [RNarg v2_])}"
lemmas context_simp = InsSortContext_def

lemma InsContext_finite[simp]: "finite InsSortContext"
by (simp add: InsSortContext_def)

lemmas dmp_defs = dominates_def isMergePoint_def
lemmas meth_defs = Meth_Ins Meth_Sort SPEC_def
lemmas fun_defs = Fun_fIns Fun_fzeroIns Fun_foneIns Fun_ftwoIns Fun_fthreeIns
                   Fun_fSort Fun_fzeroSort Fun_foneSort
lemmas ctxt_def  = InsSortContext_def

method_setup method_W = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) ctxt 1)) *}
  "Method for starting: use weakening, simplification with args, fast" 

method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast" 

lemmas ins_pdefs = Meth_Ins Fun_fIns Fun_fzeroIns Fun_foneIns Fun_ftwoIns Fun_fthreeIns SPEC_def
lemmas sort_pdefs = Meth_Sort Fun_fSort Fun_fzeroSort Fun_foneSort Meth_Ins SPEC_def

method_setup method_leaf = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 1))  *}
 "Method for solving leaf cases in the derivation."    
 
method_setup method_If = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => if_tac ctxt stop stop 1)) *}
  "Method for If, reduces to two subgoals"

method_setup method_Let = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt (thms,thms,thms) stop 1)) *}
  "Method for LetPrim/LetRPrim/LetNull, reduces to one subgoal"

method_setup method_Letinv = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for Letrinvoke"

method_setup method_Letinvs = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             stop 1)) *}
  "Method for Letrinvoke"

(* apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def) *)
method_setup method_Call = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (stop ctxt) 1)) *}
  "Method for Call, leaves dominates subgoal"
(*
method_setup method_CallDom = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (fn ctxt => fn thms => dom_tac ctxt thms (K stop)) 1)) *}
  "Method for Call, leaves dominates subgoal"
*)

(* apply (simp?, (rule DA_NullResult, simp) | rule DA_NullTree | rule DA_NullList) *)
method_setup method_Null = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => null_tac ctxt 1)) *}
  "Method for Nullresult, nulltree and nulllist"

(* FIXME: to combine method_Call with method_Dom or mergepoint stuff, we need to
   ideally need a method which accepts more than one parameter *)

(* apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs) *)
method_setup method_Dom = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => dom_tac ctxt thms stop stop 1)) *}
  "Method for Dom" 

method_setup ltac = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac2 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac2 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac3 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac3 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac4 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac4 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac5 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac5 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac6 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup rmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for resultmatchd"

method_setup rmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt stop 1)) *}
  "test for resultmatchd"

method_setup lmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for listmatchd"

method_setup lmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_matchd_tac ctxt stop 1)) *}
  "test for listmatchd"

method_setup tmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for treematchd"

method_setup tmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_matchd_tac ctxt stop 1)) *}
  "test for treematchd"
method_setup method_fast = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => fst_tac 1)) *}
  "Method for fast"

method_setup method_simp = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1)) *}
  "Method for simp"

method_setup method_Weaks = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") stop 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup method_Weak = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letrmakelist = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letrmakelist_tac ctxt (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letrmakelists = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letrmakelist_tac ctxt (thms "meth_defs") stop 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letcons = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => let_cons ctxt (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup letconsML = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => let_cons_ML ctxt (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup method_REN = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => REN_tac 1)) *}
  "Method for starting: use weakening, simplification with args, fast"


lemma Ins_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Ins) : SPEC Ins"
by (Wp ins_pdefs)

lemmas DA_intros = DA_Call2 DA_Let_RPrim DA_Let_Prim DA_If  
                   vcg_letrmakelist vcg_makelist vcg_ListMatchD  DA_ListMatch  DA_Letr 

(*With sort (destructive or non-destructive), the program analysis is infeasible.
So the following proof attempt rightly fails*)
lemma Sort_DAss:
"InsSortContext \<rhd> snd (methtable InsSort Sort) : SPEC Sort"
apply (method_Weaks)
apply ltac2
apply ltac6
apply ltac2
apply (rule vcg_letrinvokeconstRename)
 prefer 2 apply (simp add: ctxt_def)
 prefer 2 apply (simp add: meth_defs)
 prefer 2 apply (simp add: meth_defs)
 prefer 2 apply simp
 prefer 2 apply simp
 prefer 2 apply simp
 prefer 2 apply (simp add: meth_defs)
 prefer 2 apply simp
 prefer 2 apply simp
 prefer 2 apply simp
 prefer 2 apply simp
 prefer 2 apply (simp add: meth_defs)
  apply method_REN
 prefer 2 apply (simp add: evalARGS_def meth_defs newframe_env_def)
 prefer 2 apply simp
 prefer 2 apply (rule vcg_invokeconstRename)
   apply (simp add: ctxt_def)
   apply (simp add: meth_defs)
   apply (simp add: meth_defs)
   apply (simp add: meth_defs)
   apply simp
   apply simp
   apply simp
   apply simp
   apply simp
oops
(*this needs a different l to be of L(1) - I think we should not expect a successful verification
  since LFD said that the whole program is infeasible*)

lemmas DAss_lemmas = Sort_DAss Ins_DAss

(*This lemma is absolutely trivial, but it allows us to unfold the InssortContext more cautiously*)
lemma triv: "\<lbrakk>x:S; S=S1; x:S1 \<longrightarrow> P\<rbrakk>\<Longrightarrow> P" by simp

lemma InsSortContext_good: "goodContext FST vMST sMST InsSortContext"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (rule disjI2, rule disjI2)
apply (erule triv, simp add: InsSortContext_def)
apply safe
by (simp only: sMST_def, clarsimp, rule vdm_conseq, rule DAss_lemmas, 
    clarify, simp add: SPEC_def , erule DAss_PConst)+

text {*Thus, we can prove that arbitrary invocations of @{text Sort} honour
       the entry in the specification table, in the empty VDM context.*}
theorem ISCorrect: "\<rhd> InsSort\<bullet>Sort([RNarg x]): sMST InsSort Sort [RNarg x]"
apply (rule GCInvs)
apply (rule InsSortContext_good)
apply (simp_all add: InsSortContext_def)
apply fastsimp
done 

theorem "\<rhd> InsSort\<bullet>Sort([RNarg y]): \<lbrace> {y}, 0 , (emptyfinmap(y \<mapsto>\<^sub>f(ListET 1)))  \<ggreater> (ListET 0) , 0 \<rbrace>"
apply (rule InvokeRename)
apply (rule ISCorrect)
apply (simp_all add: prog_defs newframe_env_def evalARGS_def)
apply (fastsimp intro: REN.intros)
apply simp+
done

end

(* Adaptation lemmas and previous tactics and methods:
lemma Siftdown_Invoke1:
"\<lbrakk>sMST HS Siftdown [INarg x, RNarg y, RNarg z] E h hh v p; distinct [y,z]\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))(z \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"
apply (simp add: SPEC_def)
apply (erule AdaptRename)
apply (subgoal_tac "distinct (fst (methtable HS Siftdown))", assumption)
apply (simp add: MFS_defs)
apply (subgoal_tac "distinct [INarg x, RNarg y, RNarg z]", assumption)
apply simp
apply (simp add: MFS_defs)
apply (rule REN_IN)
apply (rule REN_RN)
apply (rule REN_RN)
apply (rule REN_NIL)
apply simp
apply simp
apply (simp add: MFS_defs)
apply simp
apply (simp add: MFS_defs)
apply clarsimp
apply (case_tac "xa=y", clarsimp)
apply (case_tac "xa=z", clarsimp)
apply clarsimp
apply clarsimp
apply (case_tac "x=y", clarsimp)
apply (case_tac "x=z", clarsimp)
apply clarsimp
done

(&uses Renaming with functions
lemma Siftdown_Invoke1:
"\<lbrakk>sMST HS Siftdown [INarg x, RNarg y, RNarg z] E h hh v p; f y = t1_; f z=t2_\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))(z \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (erule DAss_Rename)
apply fastsimp
apply fastsimp
apply clarsimp
apply (erule disjE, rule, simp)
apply (subgoal_tac "renv E z =
            renv \<lparr>ienv = emptyi, renv = emptyr(RN ''self'' := Nullref)\<rparr><w_:=ienv E x>\<lfloor>t1_:=renv E y\<rfloor>\<lfloor>t2_:=renv E z\<rfloor> (f z)", assumption) apply simp
apply simp
apply simp
apply (subgoal_tac "y \<noteq> z", simp) apply fastsimp
apply fastsimp
apply fastsimp
done
&)

lemma LL2: "\<lbrakk>(E, h, U,C,R,m):CS; U = V\<rbrakk> \<Longrightarrow> (E, h, V,C,R,m):CS" (&<&)by simp(&>&)

lemma Siftdown_Invoke:
"\<lbrakk>sMST HS Siftdown [INarg x, RNarg y, RNarg z] E h hh v p; y \<noteq>z\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))(z \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Make_heap_Invoke:
"sMST HS Make_heap [RNarg x] E h hh v p 
 \<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)))  \<ggreater> (TreeET 0) , 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Sort_Invoke:
"sMST HS Sort [RNarg x] E h hh v p 
 \<Longrightarrow> \<lbrace>{x}, 0, emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)) \<ggreater> ListET 0, 0\<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Extract_Invoke:
"sMST HS Extract [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0)))  \<ggreater> (ListET 0) , 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Insert_Invoke:
"sMST HS Insert [INarg x, RNarg y] E h hh v p 
\<Longrightarrow> \<lbrace> {y} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Removetop_Invoke:
"sMST HS Removetop [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x} , 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (ResultET 0 (TreeET 0) 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemma Removesome_Invoke:
"sMST HS Removesome [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x} , 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (ResultET 0 (TreeET 0) 0), 0 \<rbrace> E h hh v p"
apply (simp add: sMST_def SPEC_def MFS_defs self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done

lemmas adaptations = 
   Siftdown_Invoke Make_heap_Invoke Sort_Invoke Extract_Invoke
   Insert_Invoke 
   Removetop_Invoke Removesome_Invoke 
(&=================================================================&)
(& Methods &)

ML_setup {&
  fun localsimp_tac ctxt = simp_tac (Simplifier.get_local_simpset ctxt)
  fun asm_localsimp_tac ctxt = asm_simp_tac (Simplifier.get_local_simpset ctxt)
  fun localsimp_tac_thms ctxt thms = 
     simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)
  fun asm_localsimp_tac_thms ctxt thms = 
     asm_simp_tac ((Simplifier.get_local_simpset ctxt) addsimps thms)

  fun repeat 0 tac = all_tac
    | repeat n tac = tac THEN (repeat (n-1) tac)


  (& Bind Isar ids to ML ids &)
  val vcg_weak = thm "DA_Weak"

  val vcg_int = thm "vcg_int"
  val vcg_ivar = thm "vcg_ivar"
  val vcg_rvar = thm "vcg_rvar"
  val vcg_prim = thm "vcg_prim"
  val vcg_rprim = thm "vcg_rprim"
  val vcg_if = thm "DA_If"
  val vcg_letint = thm "DA_Let_Int"
  val vcg_letprim = thm "vcg_letprim"
  val vcg_letrprim = thm "vcg_letrprim"
  val vcg_letnull = thm "vcg_letnull"
  val vcg_call = thm "vcg_call"

  val vcg_nullresult = thm "DA_NullResult"
  val vcg_nulltree = thm "DA_NullTree"
  val vcg_nulllist = thm "DA_NullList"
  val vcg_listmatchd = thm "vcg_ListMatchD"
  val vcg_treematchd = thm "vcg_TreeMatchD"
  val vcg_resultmatchd = thm "vcg_ResultMatchD"

  val vcg_domcallcons = thm "vcg_domcallcons"
  val vcg_domcallnil = thm "vcg_domcallnil"

  val vcg_makelist = thm "vcg_makelist"
  val vcg_makeresult = thm "vcg_makeresult"
  val vcg_maketree = thm "vcg_maketree"
  val vcg_letrmaketree = thm "vcg_letrmaketree"

  val vcg_letrinvokeconst = thm "vcg_letrinvokeconst"
  val vcg_letrinvokeconstRename = thm "vcg_letrinvokeconstRename"

  val vcg_ren_in = thm "REN_IN"
  val vcg_ren_rn = thm "REN_RN"
  val vcg_ren_nil = thm "REN_NIL"

  val vcg_rinvokeconst = thm "DA_InvokeConst"
  val vcg_rinvokeconstRename = thm "vcg_invokeconstRename"

  val Siftdown_Invoke = thm "Siftdown_Invoke"
  val Make_heap_Invoke = thm "Make_heap_Invoke"
  val Sort_Invoke = thm "Sort_Invoke"
  val Extract_Invoke = thm "Extract_Invoke"
  val Insert_Invoke = thm "Insert_Invoke"
  val Removetop_Invoke = thm "Removetop_Invoke"
  val Removesome_Invoke = thm "Removesome_Invoke"

  (& Define tactics &)

  fun adapt_tac ctxt i =
   FIRST [EVERY [etac Siftdown_Invoke i, localsimp_tac ctxt i],
          etac Make_heap_Invoke i,
          etac Sort_Invoke i,
          etac Extract_Invoke i,
          etac Insert_Invoke i,
          etac Removetop_Invoke i,
          etac Removesome_Invoke i]

   (& apply (fast intro: REN.intros) i.e. (apply (rule REN_IN | rule REN_RN | rule REN_NIL)+&)
   fun REN_tac i state = state |> 
    FIRST [EVERY [rtac vcg_ren_in i, REN_tac i],
           EVERY [rtac vcg_ren_rn i, REN_tac i],
           rtac vcg_ren_nil i]

  fun invr_tac ctxt (f_defs,d_defs,c_defs) i =
          EVERY [rtac vcg_rinvokeconst i,
                 localsimp_tac_thms ctxt c_defs i,
                 clarify_tac HOL_cs i,
                 adapt_tac ctxt i,
                 repeat 3 (localsimp_tac ctxt i)]

  fun invrRename_tac ctxt (f_defs,d_defs,c_defs) i =
          EVERY [rtac vcg_rinvokeconstRename i,
                 localsimp_tac_thms ctxt c_defs i,
                 repeat 3 (localsimp_tac_thms ctxt d_defs i),
                 repeat 6 (localsimp_tac ctxt i),
                 localsimp_tac_thms ctxt d_defs i, REN_tac i,
                 localsimp_tac_thms ctxt d_defs i,
                 localsimp_tac ctxt i]

  fun leaf_tac ctxt thms i = 
  FIRST
   [resolve_tac [vcg_int, vcg_ivar, vcg_rvar, vcg_prim] i,
    (EVERY [resolve_tac [vcg_rprim] i,
	    localsimp_tac ctxt i,
	    localsimp_tac ctxt i]),
    (EVERY [resolve_tac [vcg_makelist] i,
	    repeat 2 (localsimp_tac ctxt i)]),
    (EVERY [resolve_tac [vcg_makeresult] i,
	    repeat 2 (localsimp_tac ctxt i)]),
    (EVERY [resolve_tac [vcg_maketree] i,
	    repeat 4 (localsimp_tac ctxt i)]),
    invrRename_tac ctxt thms i]

  fun if_tac ctxt rec_tacTHEN rec_tacELSE i =
   EVERY [rtac vcg_if i,
	  rec_tacELSE ctxt (i+1),
          rec_tacTHEN ctxt i]
  (& for datatypes &)

  fun null_tac ctxt i =
   EVERY [TRY (localsimp_tac ctxt i),
          ((rtac vcg_nullresult i) THEN (localsimp_tac ctxt i))
          ORELSE (rtac vcg_nulltree i)
          ORELSE (rtac vcg_nulllist i)]


  fun res_matchd_tac ctxt rec_tac i state = state |> 
          EVERY
           [rtac vcg_resultmatchd i,
            localsimp_tac ctxt (i+1),
	    rtac conjI (i+1),
            localsimp_tac ctxt (i+1),
	    rtac conjI (i+1),
            localsimp_tac ctxt (i+1),
	    repeat 3 (localsimp_tac ctxt (i+1)),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun tree_matchd_tac ctxt rec_tac i state = state |> 
          EVERY
           [rtac vcg_treematchd i,
	    repeat 3 (localsimp_tac ctxt (i+1)),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun list_matchd_tac ctxt rec_tac i state = state |> 
    EVERY [(rtac vcg_listmatchd i),
           (localsimp_tac ctxt (i+1)),
           (localsimp_tac ctxt (i+1)),
	   (CHANGED (localsimp_tac ctxt (i+1))),
            rec_tac ctxt (i+1),
            localsimp_tac ctxt i]

  fun matchd_tac ctxt rec_tac i =
   FIRST [list_matchd_tac ctxt rec_tac i,
          tree_matchd_tac ctxt rec_tac i,
          res_matchd_tac ctxt rec_tac i]

  (& works for: Letint, Letprim, LetRPrim, LetNull &)
  fun let_tac ctxt (f_defs,d_defs,c_defs) rec_tac i =
   FIRST [EVERY [rtac vcg_letint i,
		 rec_tac ctxt i],
          EVERY [rtac vcg_letprim i,
		 rec_tac ctxt i],
          EVERY [resolve_tac [vcg_letrprim] i,
	         localsimp_tac ctxt i,
	         localsimp_tac ctxt i,
	         rec_tac ctxt i],
	  EVERY [rtac vcg_letnull i,
	         localsimp_tac ctxt (i+1),
	         localsimp_tac ctxt (i+1),
	         rec_tac ctxt (i+1),
                 null_tac ctxt (i+1),
		 localsimp_tac ctxt i],
	  EVERY [rtac vcg_letrmaketree i,
	         repeat 4 (localsimp_tac ctxt i),
                 rec_tac ctxt i,
                 localsimp_tac ctxt i]]

   fun letinv_tac ctxt (f_defs,d_defs,c_defs) rec_tac i =
          EVERY [rtac vcg_letrinvokeconst i,
                 localsimp_tac_thms ctxt c_defs (i+1),
                 clarify_tac HOL_cs (i+1),
                 adapt_tac ctxt (i+1),
                 repeat 4 (localsimp_tac ctxt (i+1)),
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt i]

   fun letrinvRename_tac ctxt (f_defs,d_defs,c_defs) rec_tac i =
          EVERY [rtac vcg_letrinvokeconstRename i,
                 localsimp_tac_thms ctxt c_defs (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac ctxt (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1), REN_tac (i+1),
                 localsimp_tac_thms ctxt d_defs (i+1),
                 localsimp_tac ctxt (i+1),
                 rec_tac ctxt (i+1),
                 localsimp_tac ctxt i]

  fun call_tac ctxt thms tac i =
   EVERY [rtac vcg_call i, 
	  localsimp_tac_thms ctxt thms i,
          tac i]

     (& here: solve a subgoal of the same form, then simplify with MFS_defs to expand method body
        in other subgoals (for each of the dominators?)
	We want to do this to maintain invariant for VCG.
        asm_localsimp_tac_thms ctxt thms 2
     &)
  (& rec_tac : ctxt \<rightarrow> thms \<rightarrow> int \<rightarrow> tactic \<rightarrow> tactic \<rightarrow> int \<rightarrow> tactic&)
  fun dom_tac ctxt thms rec_tac tac2 i =
    let fun domcall n state = state |> 
       ((((rtac vcg_domcallcons i) THEN domcall (n+1))
	 ORELSE
	 (EVERY 
	  ([(rtac vcg_domcallnil i),
	    asm_localsimp_tac ctxt i,
	    asm_localsimp_tac_thms ctxt thms i,
	    rec_tac ctxt i] @
	   (map (tac2 ctxt) (rev (i upto (i+n-1)))))))
	 ORELSE
	 (& solve for a merge point by projecting on the context, 
	    solving a set-equality subgoal &)
	 (EVERY
	  [rtac conjI i,  (& leaves subgoal of form ?U = X &)
           localsimp_tac_thms ctxt thms i,
	   rtac disjI1 i,
	   localsimp_tac_thms ctxt thms i]))
      in domcall 0 end

  fun stop ctxt i = all_tac
  fun stop_thms thms ctxt i = all_tac

  fun fst_tac i = fast_tac (claset()) i

  fun weak_tac ctxt thms tac i = 
    EVERY
      [localsimp_tac_thms ctxt thms i,  (& expand SPEC, methtable &)
       rtac vcg_weak i,
       tac ctxt i]
  
  fun w_tac thms tac ctxt i = 
    EVERY
      [localsimp_tac_thms ctxt thms i,  (& expand SPEC, methtable &)
       rtac vcg_weak i,
       tac ctxt i,
       fst_tac i]

   fun l_tac (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac thms) (l_tac thms) i,
           let_tac ctxt thms (l_tac thms) i,
           call_tac ctxt f_defs (l_tac thms ctxt) i,
           dom_tac ctxt d_defs (l_tac thms) (w_tac d_defs (l_tac thms)) i,
           matchd_tac ctxt (l_tac thms) i,
           letinv_tac ctxt thms (l_tac thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac2 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt stop stop i,
           let_tac ctxt thms (l_tac2 thms) i,
           call_tac ctxt f_defs (l_tac2 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac2 thms) stop i,
           matchd_tac ctxt stop i,
           letinv_tac ctxt thms (l_tac2 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac3 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac3 thms) (l_tac3 thms) i,
           let_tac ctxt thms (l_tac3 thms) i,
           call_tac ctxt f_defs (l_tac3 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac3 thms) stop i,
           res_matchd_tac ctxt (l_tac3 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac4 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt stop (l_tac4 thms) i,
           let_tac ctxt thms (l_tac4 thms) i,
           call_tac ctxt f_defs (l_tac4 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac4 thms) stop i,
           matchd_tac ctxt (l_tac4 thms) i,
           letinv_tac ctxt thms (l_tac4 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac5 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac5 thms) (l_tac5 thms) i,
           let_tac ctxt thms (l_tac5 thms) i,
           call_tac ctxt f_defs (l_tac5 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac5 thms) (w_tac d_defs (l_tac5 thms)) i,
           matchd_tac ctxt (l_tac5 thms) i,
           letinv_tac ctxt thms (l_tac5 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]

   fun l_tac6 (thms as (f_defs,d_defs,c_defs)) ctxt i state = state |> 
    FIRST [if_tac ctxt (l_tac6 thms) (l_tac6 thms) i,
           let_tac ctxt thms (l_tac6 thms) i,
           call_tac ctxt f_defs (l_tac6 thms ctxt) i,
           dom_tac ctxt d_defs (l_tac6 thms) (w_tac d_defs (l_tac6 thms)) i,
           matchd_tac ctxt (l_tac6 thms) i,
           letrinvRename_tac ctxt thms (l_tac6 thms) i,
           null_tac ctxt i,
           leaf_tac ctxt thms i]
&}
method_setup method_leaf = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt (thms "dmp_defs", thms "prog_defs", thms "ctxt_def") 1))  &}
 "Method for solving leaf cases in the derivation."    
 
method_setup method_If = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => if_tac ctxt stop stop 1)) &}
  "Method for If, reduces to two subgoals"

method_setup method_Let = {& Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt (thms,thms,thms) stop 1)) &}
  "Method for LetPrim/LetRPrim/LetNull, reduces to one subgoal"

method_setup method_Letinv = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "prog_defs", thms "ctxt_def") 
                                             (l_tac (thms "dmp_defs", thms "prog_defs", thms "ctxt_def")) 1)) &}
  "Method for Letrinvoke"

method_setup method_Letinvs = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "prog_defs", thms "ctxt_def") 
                                             stop 1)) &}
  "Method for Letrinvoke"

(& apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def) &)
method_setup method_Call = {& Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (stop ctxt) 1)) &}
  "Method for Call, leaves dominates subgoal"
(&
method_setup method_CallDom = {& Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (fn ctxt => fn thms => dom_tac ctxt thms (K stop)) 1)) &}
  "Method for Call, leaves dominates subgoal"
&)

(& apply (simp?, (rule DA_NullResult, simp) | rule DA_NullTree | rule DA_NullList) &)
method_setup method_Null = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => null_tac ctxt 1)) &}
  "Method for Nullresult, nulltree and nulllist"

method_setup method_MatchD = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => matchd_tac ctxt stop 1)) &}
  "Method for matches"

(& FIXME: to combine method_Call with method_Dom or mergepoint stuff, we need to
   ideally need a method which accepts more than one parameter &)

(& apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs) &)
method_setup method_Dom = {& Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => dom_tac ctxt thms stop stop 1)) &}
  "Method for Dom" 

method_setup ltac = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac (thms "dmp_defs", thms "prog_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac2 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac2 (thms "dmp_defs", thms "prog_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac3 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac3 (thms "dmp_defs", thms "prog_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac4 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac4 (thms "dmp_defs", thms "prog_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac5 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac5 (thms "dmp_defs", thms "prog_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup ltac6 = {& Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6 (thms "dmp_defs", thms "prog_defs", thms "ctxt_def") ctxt 1)) &}
  "Main method"

method_setup rmd = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "prog_defs", thms "ctxt_def")) 1)) &}
  "test for resultmatchd"

method_setup rmds = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt stop 1)) &}
  "test for resultmatchd"

method_setup lmd = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => list_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "prog_defs", thms "ctxt_def")) 1)) &}
  "test for listmatchd"

method_setup lmds = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => list_matchd_tac ctxt stop 1)) &}
  "test for listmatchd"

method_setup tmd = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => tree_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "prog_defs", thms "ctxt_def")) 1)) &}
  "test for treematchd"

method_setup tmds = {& Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => tree_matchd_tac ctxt stop 1)) &}
  "test for treematchd"
method_setup method_fast = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => fst_tac 1)) &}
  "Method for fast"

method_setup method_simp = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1)) &}
  "Method for simp"

method_setup method_Weaks = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "prog_defs") stop 1)) &}
  "Method for starting: use weakening, simplification with args" 

method_setup method_Weak = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "prog_defs") (l_tac6 (thms "dmp_defs", thms "prog_defs", thms "ctxt_def")) 1)) &}
  "Method for starting: use weakening, simplification with args" 

method_setup method_REN = {& Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => REN_tac 1)) &}
  "Method for starting: use weakening, simplification with args, fast"

A proof of the final correctness theorem using invoke lemmas
theorem "\<rhd> HS\<bullet>Sort([RNarg x]): \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)))  \<ggreater> (ListET 0) , 0 \<rbrace>"
by (rule vdm_conseq, rule HSCorrect, simp add: Sort_Invoke)
*)
