theory IFlow = VDMderived:

consts SEC :: "iname \<Rightarrow> bool"

constdefs i_args::"bool \<Rightarrow> ARG \<Rightarrow> bool"
"i_args b arg == (case arg of (INarg x) \<Rightarrow> b
                            | (RNarg x) \<Rightarrow> False
                            | (VALarg v) \<Rightarrow> (case v of (IVal i) \<Rightarrow> b
                                                     | (RVal r) \<Rightarrow> False))"

consts typecorrect::"(ARGTYPE \<times> PARAMTYPE) set"
inductive typecorrect intros
tc_NIL: "([],[]):typecorrect"
(*later, we will have the following cases: but then we need to consider information flow via parameter passing
tc_IN: "\<lbrakk>(A,P):typecorrect\<rbrakk> \<Longrightarrow> ((INarg x) # A, (INpar y) # P) :typecorrect"
tc_IV: "\<lbrakk>(A,P):typecorrect\<rbrakk> \<Longrightarrow> ((VALarg (IVal i)) # A, (INpar y) # P):typecorrect"
tc_RN: "\<lbrakk>(A,P):typecorrect\<rbrakk> \<Longrightarrow> ((RNarg x) # A, (RNpar y) # P) :typecorrect"
tc_RV: "\<lbrakk>(A,P):typecorrect\<rbrakk> \<Longrightarrow> ((VALarg (RVal r)) # A, (RNpar y) # P):typecorrect"
*)
consts heapfree::"expr \<Rightarrow> bool"
primrec
"heapfree (expr.Int i) = True"
"heapfree (IVar x) = True"
"heapfree (Primop f x y) = True"
"heapfree Null = False"
"heapfree (RVar x) = False"
"heapfree (RPrimop f x y) = False"
"heapfree (New c iflds rflds) = False"
"heapfree (GetFi x T) = False"
"heapfree (GetFr x T) = False"
"heapfree (PutFi x T y) = False"
"heapfree (PutFr x T y) = False"
"heapfree (GetStat c T) = False"
"heapfree (PutStat c T y) = False"
"heapfree (Invoke x m A) = False"
"heapfree (InvokeStatic c m A) = ((foldl i_args True A) \<and> (A, fst (methtable c m)):typecorrect)"
"heapfree (Leti x e1 e2) = (heapfree e1 \<and> heapfree e2)"
"heapfree (Letr x e1 e2) = False"
"heapfree (Letv e1 e2) = (heapfree e1 \<and> heapfree e2)"
"heapfree (Ifg x e1 e2) = (heapfree e1 \<and> heapfree e2)"
"heapfree (Call f) = True" 

axioms HP_free: "(\<forall> f. heapfree (snd (funtable f))) \<and> (\<forall> c m . heapfree (snd(methtable c m)))"

consts IFlow_effect0::"expr \<Rightarrow> bool"
primrec
"IFlow_effect0 (IVar x) = SEC x"
"IFlow_effect0 (Primop f x y) = ((SEC x) \<or> (SEC y))"

consts IFlow_effect1::"expr \<Rightarrow> bool \<Rightarrow> bool"
primrec
"IFlow_effect1 (IF x THEN e1 ELSE e2) p = (p \<or> (SEC x))"

consts IFlow_effect2::"expr \<Rightarrow> bool \<Rightarrow> bool \<Rightarrow> bool"
primrec
"IFlow_effect2 (LET x = e1 IN e2 END) p1 p2 = ((p1 \<and> \<not> (SEC x)) \<or> p2)"

(*consts parameterFlow::"(ARGTYPE \<times> PARAMTYPE) \<Rightarrow> bool"
recdef parameterFlow "measure (\<lambda> (A,P) . size A)"
"parameterFlow ([],[]) = False"
"parameterFlow ((INarg x) # A, (INpar y) # P) = (if SEC x \<and> \<not> (SEC y) then True else parameterFlow (A,P))"
"parameterFlow ((VALarg (IVal i)) # A, (INpar y) # P) = (parameterFlow (A,P))"
"parameterFlow ((RNarg x) # A, (RNpar y) # P) = (parameterFlow (A,P))"
"parameterFlow ((VALarg (RVal r)) # A, (RNpar y) # P) = (parameterFlow (A,P))"
*)

consts InvS_effect::"expr \<Rightarrow> bool"
primrec
"InvS_effect (c\<bullet>m(y)) = False" (*(parameterFlow (y, (fst (methtable c m))))"*)

constdefs IFlow::"bool EFF"
"IFlow == \<lparr>
  Int_effect = (\<lambda> eEh . False),
  IVar_effect = (\<lambda> eEh . IFlow_effect0 (fst eEh)),
  Primop_effect = (\<lambda> eEh .IFlow_effect0 (fst eEh)),
  Null_effect = (\<lambda> eEh . False),
  RVar_effect = (\<lambda> eEh . False),
  RPrimop_effect = (\<lambda> eEh . False),
  New_effect = (\<lambda> eEh . False),
  GetFi_effect = (\<lambda> eEh . False),
  GetFr_effect = (\<lambda> eEh . False),
  PutFi_effect = (\<lambda> eEh . False),
  PutFr_effect = (\<lambda> eEh . False),
  GetStat_effect = (\<lambda> eEh . False),
  PutStat_effect = (\<lambda> eEh . False),
  InvV_effect = (\<lambda> eEh p . False),
  InvS_effect = (\<lambda> eEh p . (InvS_effect (fst eEh) \<or> p)),
  Leti_effect = (\<lambda> eEh p1 p2 . IFlow_effect2 (fst eEh) p1 p2),
  Letr_effect = (\<lambda> eEh p1 p2 . False),
  Letv_effect = (\<lambda> eEh p1 p2 . (p1 \<or> p2)),
  If_effect = (\<lambda> eEh p. IFlow_effect1 (fst eEh) p),
  Call_effect = (\<lambda> eEh p . p)\<rparr>"

constdefs safe ::"env \<Rightarrow> env \<Rightarrow> bool"
"safe E EE == (\<forall> x. (\<not> SEC x) \<longrightarrow> E<x> = EE<x>)"
(*
lemma "distinct P \<Longrightarrow> (\<forall> x . INpar x : set P \<longrightarrow> (\<forall> y . INpar y : set P \<longrightarrow> 
                      (\<forall> A . (A,P):typecorrect \<longrightarrow>
                              (\<forall> E i . (assign (map (evalARG E) A, P) \<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr><y:=i>)<x> =
                                        (assign (map (evalARG E) A, P) \<lparr>ienv = emptyi, renv = emptyr(self := Nullref)\<rparr>)<x>))))"
apply (induct P)
apply clarsimp
apply clarsimp
apply rule apply clarsimp  
apply rule apply clarsimp  
apply (erule typecorrect.elims, simp_all)
apply clarsimp
apply (erule typecorrect.elims, simp_all)
apply clarsimp
*)
(*
lemma safe_newenv: "(x,M):typecorrect \<Longrightarrow> (distinct M \<longrightarrow> (\<not> (parameterFlow (x,M))) \<longrightarrow> (\<forall> E EE. safe E EE \<longrightarrow>
  safe (newframe_env Nullref M x E) (newframe_env Nullref M x EE)))"*)
lemma safe_newenv[rule_format]: "(x,M):typecorrect \<Longrightarrow> (\<forall> E EE. safe E EE \<longrightarrow>
  safe (newframe_env Nullref M x E) (newframe_env Nullref M x EE))"
apply (erule typecorrect.induct)
apply clarsimp apply (simp add: safe_def newframe_env_def evalARGS_def)
done

constdefs Phi::"expr \<Rightarrow> (bool vdmassn)"
"Phi e == (\<lambda> (P::(bool EFF)) E h hh v p. (P = IFlow \<longrightarrow> (\<not> p) \<longrightarrow> 
          (\<forall> EE h1 h2 w q. (safe E EE \<longrightarrow> (P | EE \<turnstile> h1,e \<Down> h2,w,q) \<longrightarrow> w=v))))"

constdefs FST ::"bool FS_T"
"FST == (\<lambda> f . Phi(Call f))"
constdefs vMST::"bool vMS_T"
"vMST == (\<lambda> x m y . Phi(x\<diamondsuit>m(y)))"
constdefs sMST::"bool sMS_T"
"sMST == (\<lambda> c m y . Phi (c\<bullet>m(y)))"

constdefs G::"bool vdmcontext"
"G == {(e,A) . A = Phi e \<and> ((\<exists> f . e = Call f) \<or> (\<exists> c m y . e = c\<bullet>m(y)) \<or> (\<exists> x m y . e = x\<diamondsuit>m(y)))}"

constdefs tc::"expr \<Rightarrow> bool"
"tc e == (\<forall> c m x . e = c\<bullet>m(x) \<longrightarrow> (x,fst(methtable c m)) : typecorrect)"

lemma flow_Aux: "\<lbrakk>heapfree e; tc e\<rbrakk> \<Longrightarrow> G \<rhd> e : Phi e"
apply (induct e)
apply (rule vdm_conseq, rule vdm_int, simp add: Phi_def, clarsimp)
  apply (simp add: IFlow_def sem_def, clarsimp) apply (erule eval_cases, simp)
apply (rule vdm_conseq, rule vdm_ivar, simp add: Phi_def, clarsimp)
  apply (simp add: IFlow_def sem_def safe_def, clarsimp) apply (erule eval_cases, simp)
apply (rule vdm_conseq, rule vdm_prim, simp add: Phi_def, clarsimp)
  apply (simp add: IFlow_def sem_def safe_def, clarsimp) apply (erule eval_cases, simp)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply (rule vdm_ax) apply (simp add: G_def)
apply simp
apply (rule vdm_conseq, rule vdm_leti) apply (simp add: tc_def)
  apply (case_tac expr1, simp_all)
  apply (simp add: tc_def) apply (case_tac expr2, simp_all)
  apply (simp add: Phi_def, clarsimp) 
  apply (erule thin_rl, erule thin_rl)
  apply (simp add: sem_def) apply clarsimp apply (erule eval_cases)
  apply (subgoal_tac "\<not> IFlow_effect2 (LET iname =expr1 IN expr2 END) p1 p2", clarsimp)
  prefer 2 apply (simp add: IFlow_def)
  apply (rotate_tac 5) apply (erule thin_rl)
  apply (case_tac p1)
  apply clarsimp 
    apply (erule_tac x="EE<iname:=ia>" in allE, erule impE)
      apply (simp add: safe_def, clarsimp)
      apply (case_tac "x=iname")
      apply clarsimp 
      apply (erule_tac x=x in allE, clarsimp)
    apply (subgoal_tac "IFlow | EE<iname:=ia> \<turnstile> h1a , expr2 \<Down> h2 , w , p2a")
    prefer 2 apply (simp add: sem_def) apply fast
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
    apply rule apply assumption 
    apply assumption 
  apply clarsimp 
    apply (erule_tac x=EE in allE, clarsimp)
    apply (erule_tac x=h1 in allE, erule_tac x=h1a in allE, erule_tac x="IVal ia" in allE, clarsimp)
    apply (erule impE) apply rule apply(simp add: sem_def)  apply fast 
    apply clarsimp 
    apply (erule_tac x="EE<iname:=i>" in allE, erule impE)
      apply (simp add: safe_def, clarsimp)
      apply (case_tac "x=iname")
      apply clarsimp 
      apply (erule_tac x=x in allE, clarsimp)
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE)
    apply (erule impE) apply rule apply(simp add: sem_def)  apply fast 
    apply assumption
(*Letv*)
apply (rule vdm_conseq, rule vdm_letv) 
  apply (simp add: tc_def) apply (case_tac expr1, simp_all)
  apply (simp add: tc_def) apply (case_tac expr2, simp_all)
  apply (simp add: Phi_def, clarsimp) 
  apply (erule thin_rl, erule thin_rl)
  apply (subgoal_tac "\<not> (p1 \<or> p2)", clarsimp)
  prefer 2 apply (simp add: IFlow_def)
  apply (rotate_tac 4) apply (erule thin_rl) apply (rotate_tac -4)
  apply (simp add: sem_def, clarsimp) apply (erule eval_cases) 
    apply (erule_tac x="EE" in allE, clarsimp)
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
    apply rule apply (simp add: sem_def) apply fast 
    apply assumption 
defer 1 (*If*)
(*call*)
apply (rule vdm_ax) apply (simp add: G_def)
(*If*)
apply clarsimp
apply (rule vdm_conseq, rule vdm_if)
  apply (simp add: tc_def) apply (case_tac expr1, simp_all)
  apply (simp add: tc_def) apply (case_tac expr2, simp_all)
apply (erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule disjE)
apply clarsimp
  apply (simp add: Phi_def) apply clarsimp 
  apply (subgoal_tac "\<not> IFlow_effect1 (IF iname THEN expr1 ELSE expr2) pp")
  prefer 2 apply (simp add: IFlow_def)
  apply simp
  apply (simp add: sem_def) apply clarsimp 
  apply (subgoal_tac "EE<iname>=1") 
  prefer 2 apply (simp add: safe_def)
  apply (erule eval_cases)  
  apply clarsimp apply (erule_tac x=EE in allE, clarsimp) 
                 apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
                 apply rule apply (simp add: sem_def) apply fast
                 apply assumption
  apply clarsimp
apply clarsimp
  apply (simp add: Phi_def) apply clarsimp 
  apply (subgoal_tac "\<not> IFlow_effect1 (IF iname THEN expr1 ELSE expr2) pp")
  prefer 2 apply (simp add: IFlow_def)
  apply simp
  apply (simp add: sem_def) apply clarsimp 
  apply (subgoal_tac "EE<iname>=0") 
  prefer 2 apply (simp add: safe_def)
  apply (erule eval_cases)  
  apply clarsimp apply (erule_tac x=EE in allE, clarsimp) 
                 apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
                 apply rule apply (simp add: sem_def) apply fast
                 apply assumption
done

axioms TC: "(\<forall> f. tc(snd(funtable f))) \<and> (\<forall> c m . tc(snd(methtable c m)))"

lemma good: "goodContext FST vMST sMST G"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (simp add: G_def)
apply (erule conjE)
apply (erule disjE)
(*Call*)
apply (rule disjI1) apply clarsimp
  apply (simp add: FST_def)
  apply (subgoal_tac "G \<rhd>  snd (funtable
                                          f) : (\<lambda>P E h hh v p.
                                                   Phi (CALL f) P E h hh v (Call_effect P (CALL f, E, h) p))")
  apply (simp add: G_def)
  apply (rule vdm_conseq) apply (rule flow_Aux) apply (simp add: HP_free) apply (simp add: TC)
   apply (simp add: Phi_def) apply clarsimp
  apply (simp add: sem_def) apply clarsimp apply (erule eval_cases) apply clarsimp
  apply (erule impE, simp add: IFlow_def)
  apply (erule_tac x=EE in allE, erule impE, assumption)
  apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
  apply (rule, simp add: sem_def) apply fast
  apply assumption
apply (erule disjE)
(*InvS*)
apply (rule disjI2,rule disjI2) apply clarsimp
  apply (simp add: sMST_def) apply clarsimp
  apply (subgoal_tac "G \<rhd> snd (methtable c
                                              m) : (\<lambda>P E h hh v p.
                                                       \<forall>E'. E = newframe_env Nullref (fst (methtable c m)) x E' \<longrightarrow>
                                                            Phi (c\<bullet>m(x)) P E' h hh v
                                                             (Effect.InvS_effect P (c\<bullet>m(x), E', h) p))")
  apply (simp add: G_def)
  apply (rule vdm_conseq) apply (rule flow_Aux) apply (simp add: HP_free) apply (simp add: TC)
  apply (simp add: Phi_def) apply clarsimp
  apply (simp add: sem_def) apply clarsimp apply (erule eval_cases) apply clarsimp
  apply (erule impE, simp add: IFlow_def)
  apply (erule_tac x="newframe_env Nullref (fst (methtable c m)) x EE" in allE, erule impE)
  apply (rule safe_newenv) apply (subgoal_tac "heapfree (c\<bullet>m(x))") prefer 2 apply (simp add: HP_free)
   apply (
  apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
  apply (rule, simp add: sem_def) apply fast
  apply assumption
(*InvV*)
apply (rule disjI2,rule disjI1) apply clarsimp
  apply (simp add: vMST2_def) apply clarsimp
  apply (subgoal_tac "G2 \<rhd> snd (methtable C
                                         m) : (\<lambda>P E h hh v p.
                                                  \<forall>E'. classOf E' h B C \<and>
E = newframe_env (renv E' B) (fst (methtable C m)) x E' \<longrightarrow>
Phi2 (B\<diamondsuit>m(x)) P E' h hh v (InvV_effect P (B\<diamondsuit>m(x), E', h) p))")
  apply (simp add: G2_def)
  apply (rule vdm_conseq) apply (rule flow2_Aux)
  apply (simp add: Phi2_def)
done
  
lemma "finite G2 \<Longrightarrow> \<rhd> (c\<bullet>m(x)) : Phi2 (c\<bullet>m(x))"
apply (erule MUTREC)
apply simp
apply (rule good2)
apply (simp add: G2_def)
done


constdefs Phi2::"expr \<Rightarrow> (bool vdmassn)"
"Phi2 e == (\<lambda> (P::(bool EFF)) E h hh v p. (heapfree e \<longrightarrow> P = IFlow \<longrightarrow> (\<not> p) \<longrightarrow> 
           (\<forall> EE h1 h2 w q. (safe E EE \<longrightarrow> (P | EE \<turnstile> h1,e \<Down> h2,w,q) \<longrightarrow> w=v))))"

constdefs FST2 ::"bool FS_T"
"FST2 == (\<lambda> f . Phi2(Call f))"
constdefs vMST2::"bool vMS_T"
"vMST2 == (\<lambda> x m y . Phi2(x\<diamondsuit>m(y)))"
constdefs sMST2::"bool sMS_T"
"sMST2 == (\<lambda> c m y . Phi2 (c\<bullet>m(y)))"

constdefs G2::"bool vdmcontext"
"G2 == {(e,A) . A = Phi2 e \<and> ((\<exists> f . e = Call f) \<or> (\<exists> c m y . e = c\<bullet>m(y)) \<or> (\<exists> x m y . e = x\<diamondsuit>m(y)))}"

lemma flow2_Aux: "G2 \<rhd> e : Phi2 e"
apply (induct e)
apply (rule vdm_conseq, rule vdm_int, simp add: Phi2_def, clarsimp)
  apply (simp add: IFlow_def sem_def, clarsimp) apply (erule eval_cases, simp)
apply (rule vdm_conseq, rule vdm_ivar, simp add: Phi2_def, clarsimp)
  apply (simp add: IFlow_def sem_def safe_def, clarsimp) apply (erule eval_cases, simp)
apply (rule vdm_conseq, rule vdm_prim, simp add: Phi2_def, clarsimp)
  apply (simp add: IFlow_def sem_def safe_def, clarsimp) apply (erule eval_cases, simp)
apply (rule vdm_conseq, rule vdm_null, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_rvar, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_rprim, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_new, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_getfi, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_getfr, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_putfi, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_putfr, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_getstat, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_putstat, simp add: Phi2_def)
apply (rule vdm_ax) apply (simp add: G2_def)
apply (rule vdm_ax) apply (simp add: G2_def)
apply (rule vdm_conseq, erule vdm_leti, assumption, simp add: Phi2_def, clarsimp) 
  apply (erule thin_rl, erule thin_rl)
  apply (simp add: sem_def) apply clarsimp apply (erule eval_cases)
  apply (subgoal_tac "\<not> IFlow_effect2 (LET iname =expr1 IN expr2 END) p1 p2", clarsimp)
  prefer 2 apply (simp add: IFlow_def)
  apply (rotate_tac 2) apply (erule thin_rl)
  apply (case_tac p1)
  apply clarsimp 
    apply (erule_tac x="EE<iname:=ia>" in allE, erule impE)
      apply (simp add: safe_def, clarsimp)
      apply (case_tac "x=iname")
      apply clarsimp 
      apply (erule_tac x=x in allE, clarsimp)
    apply (subgoal_tac "IFlow | EE<iname:=ia> \<turnstile> h1a , expr2 \<Down> h2 , w , p2a")
    prefer 2 apply (simp add: sem_def) apply fast
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
    apply rule apply assumption 
    apply assumption 
  apply clarsimp 
    apply (erule_tac x=EE in allE, clarsimp)
    apply (erule_tac x=h1 in allE, erule_tac x=h1a in allE, erule_tac x="IVal ia" in allE, clarsimp)
    apply (erule impE) apply rule apply(simp add: sem_def)  apply fast 
    apply clarsimp 
    apply (erule_tac x="EE<iname:=i>" in allE, erule impE)
      apply (simp add: safe_def, clarsimp)
      apply (case_tac "x=iname")
      apply clarsimp 
      apply (erule_tac x=x in allE, clarsimp)
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE)
    apply (erule impE) apply rule apply(simp add: sem_def)  apply fast 
    apply assumption
(*Letr*)
apply (rule vdm_conseq, erule vdm_letr, assumption, simp add: Phi2_def) 
(*Letv*)
apply (rule vdm_conseq, erule vdm_letv, assumption, simp add: Phi2_def, clarsimp) 
  apply (erule thin_rl, erule thin_rl)
  apply (subgoal_tac "\<not> (p1 \<or> p2)", clarsimp)
  prefer 2 apply (simp add: IFlow_def)
  apply (rotate_tac 2) apply (erule thin_rl) apply (rotate_tac -2)
  apply (simp add: sem_def, clarsimp) apply (erule eval_cases) 
    apply (erule_tac x="EE" in allE, clarsimp)
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
    apply rule apply (simp add: sem_def) apply fast 
    apply assumption 
defer 1 (*If*)
(*call*)
apply (rule vdm_ax) apply (simp add: G2_def)
(*If*)
apply (rule vdm_conseq, erule vdm_if, assumption) apply (erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule disjE)
apply clarsimp
  apply (simp add: Phi2_def) apply clarsimp 
  apply (subgoal_tac "\<not> IFlow_effect1 (IF iname THEN expr1 ELSE expr2) pp")
  prefer 2 apply (simp add: IFlow_def)
  apply simp
  apply (simp add: sem_def) apply clarsimp 
  apply (subgoal_tac "EE<iname>=1") 
  prefer 2 apply (simp add: safe_def)
  apply (erule eval_cases)  
  apply clarsimp apply (erule_tac x=EE in allE, clarsimp) 
                 apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
                 apply rule apply (simp add: sem_def) apply fast
                 apply assumption
  apply clarsimp
apply clarsimp
  apply (simp add: Phi2_def) apply clarsimp 
  apply (subgoal_tac "\<not> IFlow_effect1 (IF iname THEN expr1 ELSE expr2) pp")
  prefer 2 apply (simp add: IFlow_def)
  apply simp
  apply (simp add: sem_def) apply clarsimp 
  apply (subgoal_tac "EE<iname>=0") 
  prefer 2 apply (simp add: safe_def)
  apply (erule eval_cases)  
  apply clarsimp apply (erule_tac x=EE in allE, clarsimp) 
                 apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
                 apply rule apply (simp add: sem_def) apply fast
                 apply assumption
done

lemma good2: "goodContext FST2 vMST2 sMST2 G2"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (simp add: G2_def)
apply (erule conjE)
apply (erule disjE)
(*Call*)
apply (rule disjI1) apply clarsimp
  apply (simp add: FST2_def)
  apply (subgoal_tac "G2 \<rhd>  snd (funtable
                                          f) : (\<lambda>P E h hh v p.
                                                   Phi2 (CALL f) P E h hh v (Call_effect P (CALL f, E, h) p))")
  apply (simp add: G2_def)
  apply (rule vdm_conseq) apply (rule flow2_Aux)
  apply (simp add: Phi2_def)
  apply clarsimp
  apply (erule impE) apply (simp add: HP_free)
  apply (simp add: sem_def) apply clarsimp apply (erule eval_cases) apply clarsimp
  apply (erule impE, simp add: IFlow_def)
  apply (erule_tac x=EE in allE, erule impE, assumption)
  apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
  apply (rule, simp add: sem_def) apply fast
  apply assumption
apply (erule disjE)
(*InvS*)
apply (rule disjI2,rule disjI2) apply clarsimp
  apply (simp add: sMST2_def) apply clarsimp
  apply (subgoal_tac "G2 \<rhd>  snd (methtable c m): (\<lambda>P E h hh v p.
\<forall>E'. E = newframe_env Nullref (fst (methtable c m)) x E' \<longrightarrow>
     Phi2 (c\<bullet>m(x)) P E' h hh v (InvS_effect P (c\<bullet>m(x), E', h) p))")
  apply (simp add: G2_def)
  apply (rule vdm_conseq) apply (rule flow2_Aux)
  apply (simp add: Phi2_def)
  apply clarsimp
  apply (erule impE) apply (simp add: HP_free)
  apply (simp add: sem_def) apply clarsimp apply (erule eval_cases) apply clarsimp
  apply (erule impE, simp add: IFlow_def)
  apply (erule_tac x="newframe_env Nullref (fst (methtable c m)) x EE" in allE, erule impE)
  apply (erule safe_newenv, assumption)
  apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
  apply (rule, simp add: sem_def) apply fast
  apply assumption
(*InvV*)
apply (rule disjI2,rule disjI1) apply clarsimp
  apply (simp add: vMST2_def) apply clarsimp
  apply (subgoal_tac "G2 \<rhd> snd (methtable C
                                         m) : (\<lambda>P E h hh v p.
                                                  \<forall>E'. classOf E' h B C \<and>
E = newframe_env (renv E' B) (fst (methtable C m)) x E' \<longrightarrow>
Phi2 (B\<diamondsuit>m(x)) P E' h hh v (InvV_effect P (B\<diamondsuit>m(x), E', h) p))")
  apply (simp add: G2_def)
  apply (rule vdm_conseq) apply (rule flow2_Aux)
  apply (simp add: Phi2_def)
done
  
lemma "finite G2 \<Longrightarrow> \<rhd> (c\<bullet>m(x)) : Phi2 (c\<bullet>m(x))"
apply (erule MUTREC)
apply simp
apply (rule good2)
apply (simp add: G2_def)
done
