theory IFlow = VDMderived + VDMSoundRecPC:

types D = bool

constdefs less::"D \<Rightarrow> D \<Rightarrow> bool"
"less d1 d2 == (((d1 \<or> d2) = d2) \<and> d1 \<noteq> d2)"

constdefs lesseq::"D \<Rightarrow> D \<Rightarrow> bool"
"lesseq d1 d2 == ((d1 \<or> d2) = d2)"

consts SEC :: "iname \<Rightarrow> D"

(* NO invocations allowed -- see IFlowTC for an attempt with Invokestatic*)
consts heapfree::"expr \<Rightarrow> bool"
primrec
"heapfree (expr.Int i) = True"
"heapfree (IVar x) = True"
"heapfree (Primop f x y) = True"
"heapfree Null = False"
"heapfree (RVar x) = False"
"heapfree (RPrimop f x y) = False"
"heapfree (New c iflds rflds) = False"
"heapfree (GetFi x T) = False"
"heapfree (GetFr x T) = False"
"heapfree (PutFi x T y) = False"
"heapfree (PutFr x T y) = False"
"heapfree (GetStat c T) = False"
"heapfree (PutStat c T y) = False"
"heapfree (Invoke x m A) = False"
"heapfree (InvokeStatic c m A) = False"
"heapfree (Leti x e1 e2) = (heapfree e1 \<and> heapfree e2)"
"heapfree (Letr x e1 e2) = False"
"heapfree (Letv e1 e2) = (heapfree e1 \<and> heapfree e2)"
"heapfree (Ifg x e1 e2) = (heapfree e1 \<and> heapfree e2)"
"heapfree (Call f) = True" 

axioms HP_free: "(\<forall> f. heapfree (snd (funtable f)))"

consts IFlow_effect0::"expr \<Rightarrow> bool"
primrec
"IFlow_effect0 (IVar x) = SEC x"
"IFlow_effect0 (Primop f x y) = ((SEC x) \<or> (SEC y))"

consts IFlow_effect1::"expr \<Rightarrow> bool \<Rightarrow> bool"
primrec
"IFlow_effect1 (IF x THEN e1 ELSE e2) p = (p \<or> (SEC x))"

consts IFlow_effect2::"expr \<Rightarrow> bool \<Rightarrow> bool \<Rightarrow> bool"
primrec
"IFlow_effect2 (LET x = e1 IN e2 END) p1 p2 = (if (less (SEC x) p1) then True else p2)"

constdefs IFlow::"bool EFF"
"IFlow == \<lparr>
  Int_effect = (\<lambda> eEh . False),
  IVar_effect = (\<lambda> eEh . IFlow_effect0 (fst eEh)),
  Primop_effect = (\<lambda> eEh .IFlow_effect0 (fst eEh)),
  Null_effect = (\<lambda> eEh . False),
  RVar_effect = (\<lambda> eEh . False),
  RPrimop_effect = (\<lambda> eEh . False),
  New_effect = (\<lambda> eEh . False),
  GetFi_effect = (\<lambda> eEh . False),
  GetFr_effect = (\<lambda> eEh . False),
  PutFi_effect = (\<lambda> eEh . False),
  PutFr_effect = (\<lambda> eEh . False),
  GetStat_effect = (\<lambda> eEh . False),
  PutStat_effect = (\<lambda> eEh . False),
  InvV_effect = (\<lambda> eEh p . False),
  InvS_effect = (\<lambda> eEh p . False),
  Leti_effect = (\<lambda> eEh p1 p2 . IFlow_effect2 (fst eEh) p1 p2),
  Letr_effect = (\<lambda> eEh p1 p2 . False),
  Letv_effect = (\<lambda> eEh p1 p2 . (p1 \<or> p2)),
  If_effect = (\<lambda> eEh p. IFlow_effect1 (fst eEh) p),
  Call_effect = (\<lambda> eEh p . p)\<rparr>"

constdefs equiv ::"env \<Rightarrow> env \<Rightarrow> bool"
"equiv E EE == (\<forall> x. (\<not> SEC x) \<longrightarrow> E<x> = EE<x>)"
(*
lemma equiv_newenv[rule_format]: "(x,M):typecorrect \<Longrightarrow> (\<forall> E EE. safe E EE \<longrightarrow>
  equiv (newframe_env Nullref M x E) (newframe_env Nullref M x EE))"
apply (erule typecorrect.induct)
apply clarsimp apply (simp add: equiv_def newframe_env_def evalARGS_def)
done
*)

constdefs safe::"expr \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> val \<Rightarrow> bool"
"safe e E h hh v == (\<forall> p. (IFlow | E \<turnstile> h,e \<Down> hh,v,p) \<longrightarrow> 
                          (\<forall> EE. equiv E EE \<longrightarrow> (\<forall> h1 h2 w q . (IFlow | EE \<turnstile> h1,e \<Down> h2,w,q) \<longrightarrow> w=v)))"

constdefs safe1::"expr \<Rightarrow> env \<Rightarrow> bool"
"safe1 e E == (\<forall> h hh v p. (IFlow | E \<turnstile> h,e \<Down> hh,v,p) \<longrightarrow> 
                          (\<forall> EE. equiv E EE \<longrightarrow> (\<forall> h1 h2 w q . (IFlow | EE \<turnstile> h1,e \<Down> h2,w,q) \<longrightarrow> w=v)))"

lemma "safe1 e E \<Longrightarrow> \<forall> h hh v. safe e E h hh v"
by (simp add: safe_def safe1_def)

lemma Sound: "\<lbrakk>\<rhd> e : (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> (\<not> p) \<longrightarrow> safe1 e E);
               IFlow | E \<turnstile> h,e \<Down> hh,v,p; \<not> p; equiv E EE; IFlow | EE \<turnstile> h1,e \<Down> h2,w,q\<rbrakk> \<Longrightarrow> w=v"
apply (drule vdm_sound)
apply (simp add: vdm_valid_def)
apply (subgoal_tac "safe1 e E")
prefer 2 apply fastsimp
apply (simp add: safe1_def) apply fastsimp
done

lemma heapfree_safe1: "heapfree e \<Longrightarrow> \<rhd> e : (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> (\<not> p) \<longrightarrow> safe1 e E)"
apply (induct e)
apply (rule vdm_conseq, rule vdm_int, clarsimp) apply (simp add: safe1_def, clarsimp)
  apply (simp add: sem_def, clarsimp)
  apply (erule eval_cases)+ apply clarsimp
apply (rule vdm_conseq, rule vdm_ivar, clarsimp) apply (simp add: safe1_def, clarsimp)
  apply (simp add: sem_def, clarsimp)
  apply (erule eval_cases)+ apply clarsimp apply (simp add: IFlow_def equiv_def)
apply (rule vdm_conseq, rule vdm_prim, clarsimp) apply (simp add: safe1_def, clarsimp)
  apply (simp add: sem_def, clarsimp)
  apply (erule eval_cases)+ apply clarsimp apply (simp add: IFlow_def equiv_def)
apply simp+
apply clarsimp
apply (rule vdm_conseq, erule vdm_leti, assumption, clarsimp) 
  apply (erule thin_rl, erule thin_rl, simp add: IFlow_def)
  apply (simp add: safe1_def sem_def, clarsimp)
    apply (erule eval_cases)+ apply clarsimp
  apply (case_tac p1)
oops 

constdefs Phi::"expr \<Rightarrow> (bool vdmassn)"
"Phi e == (\<lambda> (P::(bool EFF)) E h hh v p. (P = IFlow \<longrightarrow> (\<not> p) \<longrightarrow> 
          (\<forall> EE h1 h2 w q. (equiv E EE \<longrightarrow> (P | EE \<turnstile> h1,e \<Down> h2,w,q) \<longrightarrow> w=v))))"

lemma PHI_safe[rule_format]: 
"Phi e IFlow E h hh v p \<Longrightarrow> ((IFlow | E \<turnstile> h,e \<Down> hh,v,p) \<longrightarrow> (\<not> p) \<longrightarrow> (safe e E h hh v))"
by (simp add: Phi_def safe_def) 

constdefs FST ::"bool FS_T"
"FST == (\<lambda> f . Phi(Call f))"
constdefs vMST::"bool vMS_T"
"vMST == (\<lambda> x m y . Phi(x\<diamondsuit>m(y)))"
constdefs sMST::"bool sMS_T"
"sMST == (\<lambda> c m y . Phi (c\<bullet>m(y)))"

constdefs G::"bool vdmcontext"
"G == {(e,A) . heapfree e \<and> A = Phi e \<and> ((\<exists> f . e = Call f) \<or> (\<exists> c m y . e = c\<bullet>m(y)) \<or> (\<exists> x m y . e = x\<diamondsuit>m(y)))}"

lemma flow_Aux: "\<lbrakk>heapfree e\<rbrakk> \<Longrightarrow> G \<rhd> e : Phi e"
apply (induct e)
apply (rule vdm_conseq, rule vdm_int, simp add: Phi_def, clarsimp)
  apply (simp add: IFlow_def sem_def, clarsimp) apply (erule eval_cases, simp)
apply (rule vdm_conseq, rule vdm_ivar, simp add: Phi_def, clarsimp)
  apply (simp add: IFlow_def sem_def equiv_def, clarsimp) apply (erule eval_cases, simp)
apply (rule vdm_conseq, rule vdm_prim, simp add: Phi_def, clarsimp)
  apply (simp add: IFlow_def sem_def equiv_def, clarsimp) apply (erule eval_cases, simp)
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply simp
apply (rule vdm_conseq, erule vdm_leti, assumption) 
  apply (erule thin_rl, erule thin_rl)
  apply (simp add: Phi_def, clarsimp) 
  apply (simp add: sem_def) apply clarsimp apply (erule eval_cases)
  apply (subgoal_tac "\<not> IFlow_effect2 (LET iname =expr1 IN expr2 END) p1 p2", clarsimp)
  prefer 2 apply (simp add: IFlow_def)
  apply (rotate_tac 4) apply (erule thin_rl)
  apply (case_tac "SEC iname")
   apply (simp add: less_def)
    apply (erule_tac x="EE<iname:=ia>" in allE, rotate_tac -1, erule impE)
      apply (simp add: equiv_def, clarsimp)
      apply (case_tac "x=iname")
      apply clarsimp 
      apply simp
    apply (subgoal_tac "IFlow | EE<iname:=ia> \<turnstile> h1a , expr2 \<Down> h2 , w , p2a")
    prefer 2 apply (simp add: sem_def) apply fast
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, rotate_tac -1,erule impE)
    apply rule apply assumption 
    apply assumption 
  apply clarsimp apply (simp add: less_def)
    apply (case_tac p1) apply simp apply simp
    apply (erule_tac x=EE in allE, clarsimp)
    apply (erule_tac x=h1 in allE, erule_tac x=h1a in allE, erule_tac x="IVal ia" in allE, clarsimp)
    apply (erule impE) apply rule apply(simp add: sem_def)  apply fast 
    apply clarsimp 
    apply (erule_tac x="EE<iname:=i>" in allE, erule impE)
      apply (simp add: equiv_def, clarsimp)
      apply (case_tac "x=iname")
      apply clarsimp 
      apply (erule_tac x=x in allE, clarsimp)
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE)
    apply (erule impE) apply rule apply(simp add: sem_def)  apply fast 
    apply assumption
(*Letr*)
apply simp
(*Letv*)
apply simp
apply (rule vdm_conseq, erule vdm_letv, assumption) 
  apply (erule thin_rl, erule thin_rl)
  apply (simp add: Phi_def, clarsimp) 
  apply (subgoal_tac "\<not> (p1 \<or> p2)", clarsimp)
  prefer 2 apply (simp add: IFlow_def)
  apply (rotate_tac 3) apply (erule thin_rl) apply (rotate_tac -3)
  apply (simp add: sem_def, clarsimp) apply (erule eval_cases) 
    apply (erule_tac x="EE" in allE, clarsimp)
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
    apply rule apply (simp add: sem_def) apply fast 
    apply assumption
(*If*)
apply clarsimp
apply (rule vdm_conseq, erule vdm_if, assumption)
apply (erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule disjE)
apply clarsimp
  apply (simp add: Phi_def) apply clarsimp 
  apply (subgoal_tac "\<not> IFlow_effect1 (IF iname THEN expr1 ELSE expr2) pp")
  prefer 2 apply (simp add: IFlow_def)
  apply simp
  apply (simp add: sem_def) apply clarsimp 
  apply (subgoal_tac "EE<iname>=1") 
  prefer 2 apply (simp add: equiv_def)
  apply (erule eval_cases)  
  apply clarsimp apply (erule_tac x=EE in allE, clarsimp) 
                 apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
                 apply rule apply (simp add: sem_def) apply fast
                 apply assumption
  apply clarsimp
apply clarsimp
  apply (simp add: Phi_def) apply clarsimp 
  apply (subgoal_tac "\<not> IFlow_effect1 (IF iname THEN expr1 ELSE expr2) pp")
  prefer 2 apply (simp add: IFlow_def)
  apply simp
  apply (simp add: sem_def) apply clarsimp 
  apply (subgoal_tac "EE<iname>=0") 
  prefer 2 apply (simp add: equiv_def)
  apply (erule eval_cases)  
  apply clarsimp apply (erule_tac x=EE in allE, clarsimp) 
                 apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
                 apply rule apply (simp add: sem_def) apply fast
                 apply assumption
(*call*)
apply (rule vdm_ax) apply (simp add: G_def)
done

lemma good: "goodContext FST vMST sMST G"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (simp add: G_def)
apply (erule conjE)
apply (erule conjE)
apply (erule disjE)
(*Call*)
apply (rule disjI1) apply clarsimp
  apply (simp add: FST_def)
  apply (subgoal_tac "G \<rhd>  snd (funtable
                                          f) : (\<lambda>P E h hh v p.
                                                   Phi (CALL f) P E h hh v (Call_effect P (CALL f, E, h) p))")
  apply (simp add: G_def)
  apply (rule vdm_conseq) apply (rule flow_Aux) apply (simp add: HP_free) 
   apply (simp add: Phi_def) apply clarsimp
  apply (simp add: sem_def) apply clarsimp apply (erule eval_cases) apply clarsimp
  apply (erule impE, simp add: IFlow_def)
  apply (erule_tac x=EE in allE, erule impE, assumption)
  apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
  apply (rule, simp add: sem_def) apply fast
  apply assumption
apply (erule disjE)
(*InvS*)
apply clarsimp
(*InvV*)
apply clarsimp
done
  
lemma goodcall:"finite G \<Longrightarrow> \<rhd> (Call f) : Phi (Call f)"
apply (erule MUTREC)
apply simp
apply (rule good)
apply (simp add: G_def)
done

lemma PhiDerivable_all: "\<lbrakk>heapfree e; finite G\<rbrakk> \<Longrightarrow> \<rhd> e : Phi e"
apply (rule cut2, assumption)
apply (erule flow_Aux)
apply simp
apply (simp add: contextProvable_def G_def, clarsimp)
apply (erule MUTREC)
apply simp
apply (insert good) apply (simp add: G_def)
apply simp
done

lemma PhiDerivable_implies_noLeak: 
 "\<lbrakk>\<rhd> e : Phi e;IFlow | E \<turnstile> h,e \<Down> hh,v,False; equiv E EE; IFlow | EE \<turnstile> h1,e \<Down> h2,w,q\<rbrakk> \<Longrightarrow> w=v"
apply (simp add: Phi_def)
apply (drule vdm_sound)
apply (simp add: vdm_valid_def)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=hh in allE,
       erule_tac x=v in allE, erule_tac x="False" in allE, clarsimp)
apply (erule_tac x=EE in allE, clarsimp)
apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE,
       erule_tac x=w in allE, clarsimp)
done


lemma flow_sound: "\<lbrakk>heapfree e; finite G; IFlow | E \<turnstile> h,e \<Down> hh,v,False;
                     equiv E EE; IFlow | EE \<turnstile> h1,e \<Down> h2,w,q\<rbrakk> \<Longrightarrow> w=v"
apply (drule PhiDerivable_all, assumption)
apply (erule PhiDerivable_implies_noLeak, assumption+)
done

lemma "\<lbrakk>SEC x; \<not> SEC y; e=LET y = IVar x IN IVar y END\<rbrakk> \<Longrightarrow> IFlow | E \<turnstile> h,e \<Down> h,IVal (E<x>),False"
apply (subgoal_tac "\<exists> hh v p. (IFlow | E \<turnstile> h,e \<Down>  hh,v,p) \<and> hh=h \<and> v=IVal (E<x>) \<and> p=False")
  apply clarsimp 
apply (rule, rule, rule, simp add: sem_def, rule, rule)
apply (rule semn.intros)+
apply (rule, simp)
apply (rule, simp)
apply clarsimp
apply (simp add: IFlow_def)
oops (*That's correct, there IS a flow: the content of x is leaked to y!*)

lemma "\<lbrakk>SEC y; \<not> SEC x; e=LET y = IVar x IN IVar y END\<rbrakk> \<Longrightarrow> IFlow | E \<turnstile> h,e \<Down> h,IVal (E<x>),False"
apply (subgoal_tac "\<exists> hh v p. (IFlow | E \<turnstile> h,e \<Down>  hh,v,p) \<and> hh=h \<and> v=IVal (E<x>) \<and> p=False")
  apply clarsimp 
apply (rule, rule, rule, simp add: sem_def, rule, rule)
apply (rule semn.intros)+
apply (rule, simp)
apply (rule, simp)
apply clarsimp
apply (simp add: IFlow_def)
oops (*Again, that's correct, there IS a flow: the content of a secret variable (y) is returned *)

lemma Prog1: "\<lbrakk>SEC x; \<not> SEC y; e=LET x = IVar y IN IVar y END\<rbrakk> \<Longrightarrow> IFlow | E \<turnstile> h,e \<Down> h,IVal (E<y>),False"
apply (subgoal_tac "\<exists> hh v p. (IFlow | E \<turnstile> h,e \<Down>  hh,v,p) \<and> hh=h \<and> v=IVal (E<y>) \<and> p=False")
  apply clarsimp 
apply (rule, rule, rule, simp add: sem_def, rule, rule)
apply (rule semn.intros)+
apply (rule, simp)
apply (rule, simp)
apply clarsimp
apply (subgoal_tac "x \<noteq> y", simp) apply fast
apply (simp add: IFlow_def less_def)
done (*Again correct, here no flow happens*)

lemma Ex1Phi: "\<lbrakk>SEC x; \<not> SEC y; e=LET x = IVar y IN IVar y END\<rbrakk> \<Longrightarrow> \<rhd> e : Phi e"
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: Phi_def)
apply clarsimp
apply (simp add: sem_def, clarsimp)
apply (erule eval_cases)+
apply clarsimp
apply (case_tac "x=y", simp) apply simp apply (simp add: equiv_def)
done

lemma "\<lbrakk>SEC x; \<not> SEC y; e=LET x = IVar y IN IVar y END; equiv E EE; IFlow | EE \<turnstile> h1,e \<Down> h2,w,q\<rbrakk> \<Longrightarrow> w=IVal (E<y>)"
apply (frule Prog1, assumption) apply simp
apply (frule Ex1Phi, assumption) apply simp
apply (erule PhiDerivable_implies_noLeak) apply auto
done
(*This is an interesting result!*)

subsection{*A simple type system*}
types venv = "iname \<leadsto>\<^sub>f D"
types fenv = "funame \<Rightarrow> D"

consts sectp::"(venv \<times> fenv \<times> expr \<times> D) set"
inductive sectp intros
sectpInt: "(Gam,Sig,expr.Int i,t0):sectp"
sectpVar: "\<lbrakk>fmap_lookup Gam x = Some t\<rbrakk> \<Longrightarrow> (Gam,Sig,IVar x,t):sectp"
sectpPrim: "\<lbrakk>(Gam,Sig,IVar x,t1):sectp; (Gam,Sig,IVar y,t2):sectp;t=(t1 \<or>t2)\<rbrakk> \<Longrightarrow> (Gam,Sig,Primop f x y,t):sectp"
sectpLeti: "\<lbrakk>(Gam,Sig,e1,t1):sectp; (Gam(x\<mapsto>\<^sub>f(SEC x)),Sig,e2,t2):sectp; (lesseq t1 (SEC x))\<rbrakk>
                 \<Longrightarrow> (Gam,Sig,LET x = e1 IN e2 END,t2):sectp"
sectpIf: "\<lbrakk>(Gam,Sig,IVar x,t0):sectp; (Gam,Sig,e1,t1):sectp;
             (Gam,Sig,e2,t2):sectp;
             lesseq t0 t1; lesseq t0 t2;t=(t1 \<or>t2)\<rbrakk> \<Longrightarrow> (Gam,Sig,IF x THEN e1 ELSE e2,t):sectp"
sectpCall: "\<lbrakk>Sig f=t\<rbrakk> \<Longrightarrow> (Gam,Sig,CALL f,t):sectp"

lemma sectp_heapfree: "(Gam,Sig,e,t):sectp \<Longrightarrow> heapfree e"  by(erule sectp.induct, simp+)
lemma tpvdm: "\<lbrakk>(Gam,Sig,e,t):sectp\<rbrakk> \<Longrightarrow> G \<rhd> e : Phi e"
by (rule flow_Aux, erule sectp_heapfree)

(*This is soundness of type system, if we are prepared to execute e once (to get p=False)*)
lemma sectp_soundExecute:
  "\<lbrakk>(Gam,Sig,e,t):sectp; finite G; IFlow | E \<turnstile> h,e \<Down> hh,v,False;
     equiv E EE; IFlow | EE \<turnstile> h1,e \<Down> h2,w,q\<rbrakk> \<Longrightarrow> w=v"
by (rule flow_sound, erule sectp_heapfree, assumption+)


constdefs satisfies::" venv \<Rightarrow> bool"
"satisfies Gam == (\<forall> x t . ((fmap_lookup Gam x = Some t) \<longrightarrow> lesseq (SEC x) t))"

constdefs opProp::"expr \<Rightarrow> bool \<Rightarrow> bool"
"opProp e t == (\<not> t) \<longrightarrow> (\<forall> E h hh v p . (IFlow | E \<turnstile> h,e \<Down> hh, v, p) \<longrightarrow> p = False)"

constdefs opContext::"fenv \<Rightarrow> bool"
"opContext Sig == (\<forall> f t . Sig f = t \<longrightarrow> opProp (snd (funtable f)) t)"

lemma sectp_safe_operationalProof_Aux1[rule_format]:
"(Gam,Sig,e,t):sectp \<Longrightarrow> (satisfies Gam \<longrightarrow> opContext Sig \<longrightarrow> opProp e t)"
apply (erule sectp.induct)
(*int*)
apply (clarsimp, simp add: opProp_def sem_def, clarsimp) apply (erule eval_cases) apply (simp add: IFlow_def)
(*ivar*)
apply (clarsimp, simp add: opProp_def sem_def, clarsimp) apply (erule eval_cases) apply (simp add: IFlow_def)
  apply (simp add: satisfies_def) apply (erule_tac x=x in allE, erule_tac x=False in allE, simp add: lesseq_def)
(*prim*)
apply (clarsimp, simp add: opProp_def sem_def, clarsimp)
apply (erule eval_cases, clarsimp)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h in allE,
       erule_tac x="IVal (E<x>)" in allE, erule_tac x="(IVar_effect IFlow) (IVar x, E, h)" in allE)
apply (erule impE) apply (rule, rule semIVar)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h in allE,
       erule_tac x="IVal (E<y>)" in allE, erule_tac x="(IVar_effect IFlow) (IVar y, E, h)" in allE)
apply (erule impE) apply (rule, rule semIVar)
apply (simp add: IFlow_def)
(* leti*)
apply (clarsimp, simp add: opProp_def sem_def, clarsimp)
apply (erule eval_cases, clarsimp)
apply (subgoal_tac "if (less (SEC x) p1) then True else p2")
prefer 2 apply (simp add: IFlow_def) 
apply (case_tac "less (SEC x) p1")
(*1*)
apply clarsimp
apply (subgoal_tac "(\<not> SEC x) \<and> p1")
prefer 2 apply (case_tac "SEC x") apply (case_tac p1) apply (simp add: less_def) apply (simp add: less_def) 
  apply (case_tac p1) apply (simp add: less_def) apply (simp add: less_def)  
apply clarsimp
apply (case_tac t1)
apply (clarsimp) apply (simp add: lesseq_def)
apply clarsimp
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h1 in allE,
       erule_tac x="IVal i" in allE, erule_tac x=True in allE, rotate_tac -1, erule impE) 
apply (rule, fast)
apply simp
(*2*)
apply clarsimp
apply (erule impE) apply (simp add: satisfies_def, clarsimp)
  apply (case_tac "xa=x")
  apply clarsimp apply (simp add: lesseq_def)
  apply (simp add: FMAPlookup1)
apply (erule_tac x="E<x:=i>" in allE, erule_tac x=h1 in allE, erule_tac x=hh in allE,
       erule_tac x=v in allE, erule_tac x=True in allE, rotate_tac -1, erule impE) 
apply (rule, fast)
apply simp
(*If*)
apply (clarsimp, simp add: opProp_def sem_def, clarsimp)
apply (simp add: lesseq_def)
apply (erule eval_cases, clarsimp)
apply(subgoal_tac "IFlow | E \<turnstile> h , IVar x \<Down>1 (h, IVal(E<x>), (IVar_effect IFlow) (IVar x, E, h))")
  prefer 2 apply (rule semIVar)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h in allE,
       erule_tac x="IVal (E<x>)" in allE, erule_tac x="(IVar_effect IFlow) (IVar x, E, h)" in allE,
       rotate_tac -1, erule impE) 
       apply rule apply assumption
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=hh in allE,
       erule_tac x=v in allE, erule_tac x=pa in allE,
       rotate_tac -1, erule impE) 
       apply rule apply assumption
apply (simp add: IFlow_def)
apply(subgoal_tac "IFlow | E \<turnstile> h , IVar x \<Down>1 (h, IVal(E<x>), (IVar_effect IFlow) (IVar x, E, h))")
  prefer 2 apply (rule semIVar)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=h in allE,
       erule_tac x="IVal (E<x>)" in allE, erule_tac x="(IVar_effect IFlow) (IVar x, E, h)" in allE,
       rotate_tac -1, erule impE) 
       apply rule apply assumption
apply (rotate_tac 10)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=hh in allE,
       erule_tac x=v in allE, erule_tac x=pa in allE,
       rotate_tac -1, erule impE) 
       apply rule apply assumption
apply (simp add: IFlow_def)
(*Call*)
apply (clarsimp, simp add: opProp_def sem_def, clarsimp)
apply (erule eval_cases, clarsimp)
apply (simp add: opContext_def)
apply (erule_tac x=f in allE, clarsimp)
apply (simp add: opProp_def sem_def)
apply (erule_tac x=E in allE, erule_tac x=h in allE, erule_tac x=hh in allE,
       erule_tac x=v in allE, erule_tac x=pa in allE)
apply (erule impE, fast)
apply (simp add: IFlow_def)
done

lemma sectp_safe_operationalProof_Aux2[rule_format]:
"\<lbrakk>(Gam,Sig,e,False):sectp; satisfies Gam; opContext Sig; (IFlow | E \<turnstile> h,e \<Down> hh, v, p)\<rbrakk> \<Longrightarrow> p = False"
by (drule sectp_safe_operationalProof_Aux1, assumption+, simp add: opProp_def, fast)

(*This is real safety, using the proof Aux1 that inducts on the exution relation -
  and opContext property should of course be replaced by derivability. But it's a starting point*)
lemma sectp_safe_operationalProof[rule_format]:
"\<lbrakk>(Gam,Sig,e,False):sectp; satisfies Gam; opContext Sig; IFlow.equiv E EE; finite G;
  (IFlow | E \<turnstile> h,e \<Down> hh, v, p); (IFlow | EE \<turnstile> h1,e \<Down> hh1, w, q)\<rbrakk> \<Longrightarrow> w=v"
apply (rule sectp_soundExecute, assumption+)
apply (subgoal_tac "p=False", clarsimp, assumption)
apply (rule sectp_safe_operationalProof_Aux2, assumption+)
done

constdefs tpG::"fenv \<Rightarrow> (bool vdmcontext)"
"tpG Sig == {(e,A) . (A = (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> \<not> p) \<and> (\<exists> f . e = Call f \<and> Sig f = False)) \<or>
                     (A = (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> True) \<and> (\<exists> f . e = Call f \<and> Sig f = True))}"

lemma SatisfiesExtend: "satisfies Gam \<Longrightarrow> satisfies (Gam(x\<mapsto>\<^sub>fSEC x))"
apply (simp add: satisfies_def, clarsimp)
apply (case_tac "xa=x") apply (simp add: lesseq_def)
apply (simp add: FMAPlookup1)
done

lemma sectp_good_Aux[rule_format]: 
"(Gam,Sig,e,t):sectp \<Longrightarrow> (satisfies Gam \<longrightarrow> 
                        (((\<not> t) \<longrightarrow> (tpG Sig) \<rhd> e: (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> \<not> p)) \<and>
                         ( t \<longrightarrow> (tpG Sig) \<rhd> e: (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> True))))"
apply (erule sectp.induct)
apply (clarsimp, rule)
  apply(clarsimp, rule vdm_conseq, rule vdm_int) apply (simp add: IFlow_def)
  apply(clarsimp, rule vdm_conseq, rule vdm_int) apply clarsimp
apply (clarsimp, rule)
  apply (clarsimp, rule vdm_conseq, rule vdm_ivar, clarsimp)
  apply (simp add: IFlow_def satisfies_def lesseq_def)
  apply (erule_tac x=x in allE, erule_tac x=False in allE, simp)
  apply (clarsimp, rule vdm_conseq, rule vdm_ivar, clarsimp)
apply (clarsimp, rule)
  apply (clarsimp, rule vdm_conseq, rule vdm_prim, clarsimp)
  apply (erule sectp.elims, simp_all, clarsimp)
  apply (erule sectp.elims, simp_all, clarsimp)
  apply (rotate_tac 3, erule thin_rl, erule thin_rl)
  apply (simp add: IFlow_def satisfies_def)
  apply (subgoal_tac "lesseq (SEC xa) False")
  apply (subgoal_tac "lesseq (SEC x) False") apply (simp add: lesseq_def)
  apply fast
  apply fast
  apply rule
  apply (clarsimp, rule vdm_conseq, rule vdm_prim, clarsimp)
  apply (clarsimp, rule vdm_conseq, rule vdm_prim, clarsimp)
apply (clarsimp, rule)
  apply (case_tac t1)
  (*1*)
  apply (clarsimp, rule vdm_conseq, erule vdm_leti)
  apply (erule impE) apply (erule SatisfiesExtend)
  apply assumption
  apply clarsimp apply (simp add: lesseq_def)
  apply (simp add: less_def IFlow_def)
  (*2*)
  apply (clarsimp, rule vdm_conseq, erule vdm_leti)
  apply (erule impE) apply (erule SatisfiesExtend)
  apply assumption
  apply clarsimp 
  apply (simp add: less_def IFlow_def)

  apply clarsimp
  apply (erule impE) apply (erule SatisfiesExtend)
  apply (case_tac t1)
  apply (clarsimp, rule vdm_conseq, erule vdm_leti, assumption) apply simp
  apply (clarsimp, rule vdm_conseq, erule vdm_leti, assumption) apply simp
apply (clarsimp, rule)
  apply clarsimp apply (simp add: lesseq_def)
  apply (rule vdm_conseq, erule vdm_if, assumption) apply clarsimp
  apply (subgoal_tac "SEC x")
  prefer 2 apply (subgoal_tac "pp \<or> (SEC x)")
           prefer 2 apply (simp add: IFlow_def)  
    apply (erule disjE, clarsimp, clarsimp)
  apply (erule sectp.elims, simp_all) apply clarsimp
  apply (simp add: satisfies_def lesseq_def) apply (erule_tac x=xa in allE, erule_tac x=False in allE, clarsimp)

  apply (rule, clarsimp)
  apply (case_tac t2)
  apply (clarsimp, rule vdm_conseq, erule vdm_if, assumption) apply clarsimp
  apply (clarsimp, rule vdm_conseq, erule vdm_if, assumption) apply clarsimp
  apply clarsimp
  apply (case_tac t1)
  apply (clarsimp, rule vdm_conseq, erule vdm_if, assumption) apply clarsimp
  apply (clarsimp, rule vdm_conseq, erule vdm_if, assumption) apply clarsimp
(*call*)
apply (clarsimp, rule)
  apply clarsimp apply (rule vdm_ax) apply (simp add: tpG_def)
  apply clarsimp apply (rule vdm_ax) apply (simp add: tpG_def)
done

constdefs vdm_FST ::"fenv \<Rightarrow> bool FS_T"
"vdm_FST Sig == (\<lambda> f . if (Sig f) then (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> True) else (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> \<not> p))"
consts vdm_vMST::"bool vMS_T"
consts vdm_sMST::"bool sMS_T"

(*This is a better constraint on Sigma than the opContext one, of course, we expect Gam to be 
  [x \<mapsto> SEC x | x \in fv (snd (funtable f))], but that's not actually needed*)
constdefs Sig_good::"fenv \<Rightarrow> bool"
"Sig_good Sig == (\<forall> f . \<exists> Gam. satisfies Gam \<and> (Gam,Sig,snd(funtable f),Sig f):sectp)"

lemma sectp_good: "Sig_good Sig \<Longrightarrow> goodContext (vdm_FST Sig) vdm_vMST vdm_sMST (tpG Sig)"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (simp add: tpG_def)
apply (rule disjI1)
apply (erule disjE)
(*\<not> Sig f*)
apply clarsimp 
  apply (simp add: vdm_FST_def)
  apply (subgoal_tac "(tpG Sig) \<rhd>  snd (funtable
                                          f) : (\<lambda>P E h hh v p. P = IFlow \<longrightarrow> \<not> Call_effect IFlow (CALL f, E, h) p)")
  apply (simp add: tpG_def)
  apply (simp add: Sig_good_def) apply (erule_tac x=f in allE, clarsimp)
  apply (rule vdm_conseq) apply (frule sectp_good_Aux, assumption) apply simp
  apply clarsimp apply (simp add: IFlow_def)
(*Sig f*)
apply clarsimp 
  apply (simp add: vdm_FST_def)
  apply (subgoal_tac "(tpG Sig) \<rhd>  snd (funtable
                                          f) : (\<lambda>P E h hh v p. True)")
  apply (simp add: tpG_def)
  apply (simp add: Sig_good_def) apply (erule_tac x=f in allE, clarsimp)
  apply (rule vdm_conseq) apply (frule sectp_good_Aux, assumption) apply simp
  apply clarsimp 
done

constdefs Rho:: "bool vdmassn"
"Rho == (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> \<not> p)"

lemma sectp_Rho_G:
"\<lbrakk>(Gam,Sig,e,False):sectp; satisfies Gam\<rbrakk> \<Longrightarrow> (tpG Sig) \<rhd> e: Rho"
apply (simp add: Rho_def)
by (frule sectp_good_Aux, assumption, simp)

lemma sectp_Rho_Call: 
"\<lbrakk>finite (tpG Sig); Sig_good Sig; \<not> Sig f\<rbrakk> \<Longrightarrow> \<rhd> (Call f): Rho"
apply (erule MUTREC)
apply simp
apply (erule sectp_good)
apply (simp add: tpG_def Rho_def) 
done

lemma sectp_Rho: 
"\<lbrakk>finite (tpG Sig); (Gam,Sig,e,False):sectp; satisfies Gam; Sig_good Sig\<rbrakk> \<Longrightarrow> \<rhd> e: Rho"
apply (rule cut2, assumption)
apply (erule sectp_Rho_G)
apply simp+
apply (simp add: contextProvable_def tpG_def, clarsimp)
apply rule
apply clarsimp
apply (erule MUTREC)
apply simp
apply (drule sectp_good) apply (simp add: tpG_def)
apply simp
apply clarsimp
apply (erule MUTREC)
apply simp
apply (drule sectp_good) apply (simp add: tpG_def)
apply simp
done

lemma finiteClaim:"finite G = finite (tpG Sig)"
apply (simp add: G_def tpG_def)
sorry

lemma RhoPhi_safe:"\<lbrakk>\<rhd> e: Rho; \<rhd> e:(Phi e)\<rbrakk> \<Longrightarrow> safe e E h hh v"
apply (simp add: safe_def, clarsimp)
apply (erule PhiDerivable_implies_noLeak) 
defer 1 apply assumption+ 
apply (subgoal_tac "p=False",clarsimp)
prefer 2 apply (frule vdm_sound)
   apply (simp add: Rho_def vdm_valid_def) apply fast
apply assumption
done

(*This is the desired soundness result: we don't have to execute the program at all*)

lemma sectp_safe: 
"\<lbrakk>(Gam,Sig,e,False):sectp; satisfies Gam; Sig_good Sig; finite (tpG Sig)\<rbrakk> \<Longrightarrow> safe e E h hh v"
apply (rule RhoPhi_safe)
apply (rule sectp_Rho, assumption+)
apply (rule PhiDerivable_all)
apply (erule sectp_heapfree)
apply (insert finiteClaim[of Sig], simp) 
done


done
end

(*lemma "\<lbrakk>SEC x; \<not> SEC y; e=LET y = IVar x IN IVar y END\<rbrakk> \<Longrightarrow> \<rhd> e : Phi e"
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: IFlow_def Phi_def)
done*)\<rbrakk> \<Longrightarrow> G \<rhd> e : Phi e"
by (rule flow_Aux, erule sectp.induct, simp+)



done 
end 
end
lemma "\<lbrakk>SEC x; \<not> SEC y; e=LET x = IVar y IN IVar x END\<rbrakk> \<Longrightarrow> \<rhd> e : (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> p=True)"
apply (rule vdm_conseq)
apply simp
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: IFlow_def)
done

lemma Ex3Phi: "\<lbrakk>SEC x; \<not> SEC y; e=LET x = IVar y IN IVar y END\<rbrakk> \<Longrightarrow> \<rhd> e : Phi2 e"
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: Phi2_def)
apply clarsimp
apply (simp add: sem_def, clarsimp)
apply (erule eval_cases)+
apply clarsimp
apply (simp add: IFlow_def)
apply (subgoal_tac "x \<noteq> y")
apply simp
apply (simp add: equiv_def)
apply fast
done

lemma "\<lbrakk>SEC x; \<not> SEC y; e=LET x = IVar y IN IVar y END\<rbrakk> \<Longrightarrow> \<rhd> e : (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> p=False)"
apply (rule vdm_conseq)
apply simp
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: IFlow_def)
done
lemma

done
constdefs Phi2::"expr \<Rightarrow> (bool vdmassn)"
"Phi2 e == (\<lambda> (P::(bool EFF)) E h hh v p. (heapfree e \<longrightarrow> P = IFlow \<longrightarrow> (\<not> p) \<longrightarrow> 
           (\<forall> EE h1 h2 w q. (equiv E EE \<longrightarrow> (P | EE \<turnstile> h1,e \<Down> h2,w,q) \<longrightarrow> w=v))))"

constdefs FST2 ::"bool FS_T"
"FST2 == (\<lambda> f . Phi2(Call f))"
constdefs vMST2::"bool vMS_T"
"vMST2 == (\<lambda> x m y . Phi2(x\<diamondsuit>m(y)))"
constdefs sMST2::"bool sMS_T"
"sMST2 == (\<lambda> c m y . Phi2 (c\<bullet>m(y)))"

constdefs G2::"bool vdmcontext"
"G2 == {(e,A) . A = Phi2 e \<and> ((\<exists> f . e = Call f) \<or> (\<exists> c m y . e = c\<bullet>m(y)) \<or> (\<exists> x m y . e = x\<diamondsuit>m(y)))}"

lemma flow2_Aux: "G2 \<rhd> e : Phi2 e"
apply (induct e)
apply (rule vdm_conseq, rule vdm_int, simp add: Phi2_def, clarsimp)
  apply (simp add: IFlow_def sem_def, clarsimp) apply (erule eval_cases, simp)
apply (rule vdm_conseq, rule vdm_ivar, simp add: Phi2_def, clarsimp)
  apply (simp add: IFlow_def sem_def equiv_def, clarsimp) apply (erule eval_cases, simp)
apply (rule vdm_conseq, rule vdm_prim, simp add: Phi2_def, clarsimp)
  apply (simp add: IFlow_def sem_def equiv_def, clarsimp) apply (erule eval_cases, simp)
apply (rule vdm_conseq, rule vdm_null, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_rvar, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_rprim, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_new, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_getfi, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_getfr, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_putfi, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_putfr, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_getstat, simp add: Phi2_def)
apply (rule vdm_conseq, rule vdm_putstat, simp add: Phi2_def)
apply (rule vdm_ax) apply (simp add: G2_def)
apply (rule vdm_ax) apply (simp add: G2_def)
apply (rule vdm_conseq, erule vdm_leti, assumption, simp add: Phi2_def, clarsimp) 
  apply (erule thin_rl, erule thin_rl)
  apply (simp add: sem_def) apply clarsimp apply (erule eval_cases)
  apply (subgoal_tac "\<not> IFlow_effect2 (LET iname =expr1 IN expr2 END) p1 p2", clarsimp)
  prefer 2 apply (simp add: IFlow_def)
  apply (rotate_tac 2) apply (erule thin_rl)
  apply (case_tac p1)
  apply clarsimp 
    apply (erule_tac x="EE<iname:=ia>" in allE, erule impE)
      apply (simp add: equiv_def, clarsimp)
      apply (case_tac "x=iname")
      apply clarsimp 
      apply (erule_tac x=x in allE, clarsimp)
    apply (subgoal_tac "IFlow | EE<iname:=ia> \<turnstile> h1a , expr2 \<Down> h2 , w , p2a")
    prefer 2 apply (simp add: sem_def) apply fast
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
    apply rule apply assumption 
    apply assumption 
  apply clarsimp 
    apply (erule_tac x=EE in allE, clarsimp)
    apply (erule_tac x=h1 in allE, erule_tac x=h1a in allE, erule_tac x="IVal ia" in allE, clarsimp)
    apply (erule impE) apply rule apply(simp add: sem_def)  apply fast 
    apply clarsimp 
    apply (erule_tac x="EE<iname:=i>" in allE, erule impE)
      apply (simp add: equiv_def, clarsimp)
      apply (case_tac "x=iname")
      apply clarsimp 
      apply (erule_tac x=x in allE, clarsimp)
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE)
    apply (erule impE) apply rule apply(simp add: sem_def)  apply fast 
    apply assumption
(*Letr*)
apply (rule vdm_conseq, erule vdm_letr, assumption, simp add: Phi2_def) 
(*Letv*)
apply (rule vdm_conseq, erule vdm_letv, assumption, simp add: Phi2_def, clarsimp) 
  apply (erule thin_rl, erule thin_rl)
  apply (subgoal_tac "\<not> (p1 \<or> p2)", clarsimp)
  prefer 2 apply (simp add: IFlow_def)
  apply (rotate_tac 2) apply (erule thin_rl) apply (rotate_tac -2)
  apply (simp add: sem_def, clarsimp) apply (erule eval_cases) 
    apply (erule_tac x="EE" in allE, clarsimp)
    apply (erule_tac x=h1a in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
    apply rule apply (simp add: sem_def) apply fast 
    apply assumption 
(*If*)
apply (rule vdm_conseq, erule vdm_if, assumption) apply (erule thin_rl, erule thin_rl)
apply clarsimp
apply (erule disjE)
apply clarsimp
  apply (simp add: Phi2_def) apply clarsimp 
  apply (subgoal_tac "\<not> IFlow_effect1 (IF iname THEN expr1 ELSE expr2) pp")
  prefer 2 apply (simp add: IFlow_def)
  apply simp
  apply (simp add: sem_def) apply clarsimp 
  apply (subgoal_tac "EE<iname>=1") 
  prefer 2 apply (simp add: equiv_def)
  apply (erule eval_cases)  
  apply clarsimp apply (erule_tac x=EE in allE, clarsimp) 
                 apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
                 apply rule apply (simp add: sem_def) apply fast
                 apply assumption
  apply clarsimp
apply clarsimp
  apply (simp add: Phi2_def) apply clarsimp 
  apply (subgoal_tac "\<not> IFlow_effect1 (IF iname THEN expr1 ELSE expr2) pp")
  prefer 2 apply (simp add: IFlow_def)
  apply simp
  apply (simp add: sem_def) apply clarsimp 
  apply (subgoal_tac "EE<iname>=0") 
  prefer 2 apply (simp add: equiv_def)
  apply (erule eval_cases)  
  apply clarsimp apply (erule_tac x=EE in allE, clarsimp) 
                 apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
                 apply rule apply (simp add: sem_def) apply fast
                 apply assumption
(*call*)
apply (rule vdm_ax) apply (simp add: G2_def)
done

lemma good2: "goodContext FST2 vMST2 sMST2 G2"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (simp add: G2_def)
apply (erule conjE)
apply (erule disjE)
(*Call*)
apply (rule disjI1) apply clarsimp
  apply (simp add: FST2_def)
  apply (subgoal_tac "G2 \<rhd>  snd (funtable
                                          f) : (\<lambda>P E h hh v p.
                                                   Phi2 (CALL f) P E h hh v (Call_effect P (CALL f, E, h) p))")
  apply (simp add: G2_def)
  apply (rule vdm_conseq) apply (rule flow2_Aux)
  apply (simp add: Phi2_def)
  apply clarsimp
  apply (erule impE) apply (simp add: HP_free)
  apply (simp add: sem_def) apply clarsimp apply (erule eval_cases) apply clarsimp
  apply (erule impE, simp add: IFlow_def)
  apply (erule_tac x=EE in allE, erule impE, assumption)
  apply (erule_tac x=h1 in allE, erule_tac x=h2 in allE, erule_tac x=w in allE, erule impE)
  apply (rule, simp add: sem_def) apply fast
  apply assumption
apply (erule disjE)
(*InvS*)
apply (rule disjI2,rule disjI2) apply clarsimp
  apply (simp add: sMST2_def) apply clarsimp
  apply (subgoal_tac "G2 \<rhd>  snd (methtable c m): (\<lambda>P E h hh v p.
\<forall>E'. E = newframe_env Nullref (fst (methtable c m)) x E' \<longrightarrow>
     Phi2 (c\<bullet>m(x)) P E' h hh v (InvS_effect P (c\<bullet>m(x), E', h) p))")
  apply (simp add: G2_def)
  apply (rule vdm_conseq) apply (rule flow2_Aux)
  apply (simp add: Phi2_def)
(*InvV*)
apply (rule disjI2,rule disjI1) apply clarsimp
  apply (simp add: vMST2_def) apply clarsimp
  apply (subgoal_tac "G2 \<rhd> snd (methtable C
                                         m) : (\<lambda>P E h hh v p.
                                                  \<forall>E'. classOf E' h B C \<and>
E = newframe_env (renv E' B) (fst (methtable C m)) x E' \<longrightarrow>
Phi2 (B\<diamondsuit>m(x)) P E' h hh v (InvV_effect P (B\<diamondsuit>m(x), E', h) p))")
  apply (simp add: G2_def)
  apply (rule vdm_conseq) apply (rule flow2_Aux)
  apply (simp add: Phi2_def)
done
  
lemma "finite G2 \<Longrightarrow> \<rhd> (Call f) : Phi2 (Call f)"
apply (erule MUTREC)
apply simp
apply (rule good2)
apply (simp add: G2_def)
done

lemma Ex1Phi: "\<lbrakk>SEC x; \<not> SEC y; e=LET y = IVar x IN IVar y END\<rbrakk> \<Longrightarrow> \<rhd> e : Phi2 e"
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: IFlow_def Phi2_def)
done

lemma "\<lbrakk>SEC x; \<not> SEC y; e=LET y = IVar x IN IVar y END\<rbrakk> \<Longrightarrow> \<rhd> e : (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> p=True)"
apply (rule vdm_conseq)
apply simp
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: IFlow_def)
done

lemma Ex2Phi: "\<lbrakk>SEC x; \<not> SEC y; e=LET x = IVar y IN IVar x END\<rbrakk> \<Longrightarrow> \<rhd> e : Phi2 e"
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: IFlow_def Phi2_def)
done

lemma "\<lbrakk>SEC x; \<not> SEC y; e=LET x = IVar y IN IVar x END\<rbrakk> \<Longrightarrow> \<rhd> e : (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> p=True)"
apply (rule vdm_conseq)
apply simp
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: IFlow_def)
done

lemma Ex3Phi: "\<lbrakk>SEC x; \<not> SEC y; e=LET x = IVar y IN IVar y END\<rbrakk> \<Longrightarrow> \<rhd> e : Phi2 e"
apply clarsimp
apply (rule vdm_conseq)
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: Phi2_def)
apply clarsimp
apply (simp add: sem_def, clarsimp)
apply (erule eval_cases)+
apply clarsimp
apply (simp add: IFlow_def)
apply (subgoal_tac "x \<noteq> y")
apply simp
apply (simp add: equiv_def)
apply fast
done

lemma "\<lbrakk>SEC x; \<not> SEC y; e=LET x = IVar y IN IVar y END\<rbrakk> \<Longrightarrow> \<rhd> e : (\<lambda> P E h hh v p . P=IFlow \<longrightarrow> p=False)"
apply (rule vdm_conseq)
apply simp
apply (rule vdm_basics)+
apply clarsimp
apply (simp add: IFlow_def)
done

