theory HeapSortProof = HPSortProg:

text {*This corresponds to the following specifications, formalised from the viewpoint of the
       method bodies: the contexts (in second parameter of @{text DAss}) are the contexts in which
       the method bodies are typed*}
constdefs SPEC::"mname \<Rightarrow> vdmassn"
"SPEC M == (if M = Insert then (DAss {t_} 1 (emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0))) (TreeET 0) 0) else
            if M = Removesome then (DAss {t_} 0 (emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0))) (ResultET 0 (TreeET 0) 0) 0) else
            if M = Removetop then (DAss {t_} 0 (emptyfinmap(t_ \<mapsto>\<^sub>f(TreeET 0))) (ResultET 0 (TreeET 0) 0) 0) else
            if M = Make_heap then (DAss {l_} 0 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) (TreeET 0) 0) else
            if M = Extract then (DAss {h_} 0 (emptyfinmap(h_ \<mapsto>\<^sub>f(TreeET 0))) (ListET 0) 0) else
            if M = Siftdown then (DAss {t1_, t2_} 1 (emptyfinmap(t1_ \<mapsto>\<^sub>f(TreeET 0))(t2_ \<mapsto>\<^sub>f(TreeET 0))) (TreeET 0) 0) else
            if M = Sort then (DAss {l_} 0 (emptyfinmap(l_ \<mapsto>\<^sub>f(ListET 0))) (ListET 0) 0) else 
            (\<lambda> E h hh v p . False))"

consts FST :: FS_T
(*"FST == \<lambda> f E h hh v p . False" -- definition is arbitrary. Could be \<lambda>..True as well*)

consts vMST :: vMS_T
(*"vMST == \<lambda> x M args E h hh v p . False" -- definition is arbitrary. Could be \<lambda>..True as well"*)

constdefs sMST :: sMS_T
"sMST == (\<lambda> C M args E h hh v p. SPEC M (newframe_env Nullref (fst (methtable C M)) args E) h hh v p)"

lemmas MFS_defs = Meth_Sort Fun_fSort 
                  Meth_Extract Fun_fExtract Fun_fzeroExtract Fun_foneExtract
                  Meth_Insert Fun_fInsert Fun_fzeroInsert Fun_foneInsert Fun_ftwoInsert Fun_fthreeInsert
                  Meth_Make_heap  Fun_fMake_heap  Fun_fzeroMake_heap Fun_foneMake_heap
                  Meth_Removesome Fun_fRemovesome Fun_fzeroRemovesome Fun_foneRemovesome Fun_ftwoRemovesome  Fun_fthreeRemovesome
                  Meth_Removetop Fun_fRemovetop Fun_fzeroRemovetop Fun_foneRemovetop Fun_ftwoRemovetop  Fun_fthreeRemovetop
                  Meth_Siftdown Fun_fSiftdown Fun_fzeroSiftdown Fun_foneSiftdown Fun_ftwoSiftdown Fun_fthreeSiftdown
                    Fun_ffourSiftdown Fun_ffiveSiftdown Fun_fsixSiftdown Fun_fsevenSiftdown Fun_feightSiftdown
                    Fun_fnineSiftdown Fun_ftenSiftdown Fun_felevenSiftdown Fun_ftwelveSiftdown Fun_fthirteenSiftdown
                    Fun_ffourteenSiftdown Fun_ffifteenSiftdown Fun_fsixteenSiftdown Fun_fseventeenSiftdown 
                    Fun_feighteenSiftdown Fun_fnineteenSiftdown

lemma LL2: "\<lbrakk>(E, h, U,C,R,m):CS; U = V\<rbrakk> \<Longrightarrow> (E, h, V,C,R,m):CS" (*<*)by simp(*>*)

lemma Siftdown_Invoke:
"\<lbrakk>sMST HS Siftdown [INarg x, RNarg y, RNarg z] E h hh v p; y \<noteq> z\<rbrakk> \<Longrightarrow>
  \<lbrace> {y,z} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))(z \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"
(*<*)
apply (simp add: sMST_def SPEC_def MFS_defs newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done
(*>*)

lemma Make_heap_Invoke:
"sMST HS Make_heap [RNarg x] E h hh v p 
 \<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)))  \<ggreater> (TreeET 0) , 0 \<rbrace> E h hh v p"
(*<*)
apply (simp add: sMST_def SPEC_def MFS_defs newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done
(*>*)

lemma Sort_Invoke:
"sMST HS Sort [RNarg x] E h hh v p 
 \<Longrightarrow> \<lbrace>{x}, 0, emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)) \<ggreater> ListET 0, 0\<rbrace> E h hh v p"
(*<*)
apply (simp add: sMST_def SPEC_def MFS_defs newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done
(*>*)

lemma Extract_Invoke:
"sMST HS Extract [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0)))  \<ggreater> (ListET 0) , 0 \<rbrace> E h hh v p"
(*<*)
apply (simp add: sMST_def SPEC_def MFS_defs newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done
(*>*)

lemma Insert_Invoke:
"sMST HS Insert [INarg x, RNarg y] E h hh v p 
\<Longrightarrow> \<lbrace> {y} , 1 , (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (TreeET 0), 0 \<rbrace> E h hh v p"
(*<*)
apply (simp add: sMST_def SPEC_def MFS_defs newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done
(*>*)

lemma Removetop_Invoke:
"sMST HS Removetop [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x} , 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (ResultET 0 (TreeET 0) 0), 0 \<rbrace> E h hh v p"
(*<*)
apply (simp add: sMST_def SPEC_def MFS_defs newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done
(*>*)

lemma Removesome_Invoke:
"sMST HS Removesome [RNarg x] E h hh v p 
\<Longrightarrow> \<lbrace> {x} , 0 , (emptyfinmap(x \<mapsto>\<^sub>f(TreeET 0))) \<ggreater>  (ResultET 0 (TreeET 0) 0), 0 \<rbrace> E h hh v p"
(*<*)
apply (simp add: sMST_def SPEC_def MFS_defs newframe_env_def evalARGS_def self_def)
apply (simp add: DAss_def, safe)
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, safe)
apply (rule_tac x=N in exI, safe)
apply (rule_tac x=P in exI, safe)
apply ( (erule CS.elims, safe, clarsimp+)+,
        ( (rule CS_NIL, fastsimp, simp+) | (rule CS_CONS, fastsimp, simp+) )+, 
        (fast, fast, simp, (drule LL2, fast))? )+
done
(*>*)

lemma vcg_int: "G \<rhd>  expr.Int i : \<lbrace> {} , n , C \<ggreater>  IntET , n \<rbrace>" by (rule DA_Int, simp)
lemma vcg_ivar: "G \<rhd>  IVar x : \<lbrace> {} , n , C \<ggreater>  IntET , n \<rbrace> " by (rule DA_IVar, simp)
lemma vcg_rvar: "GETr C x = Some T \<Longrightarrow> G \<rhd>  RVar x : \<lbrace> {x} , n , C \<ggreater>  T , n \<rbrace>" by (rule DA_RVar)
lemma vcg_prim: "G \<rhd>  Primop f x y : \<lbrace> {} , n , C \<ggreater>  IntET , n \<rbrace>" by (rule DA_Prim, simp)
lemma vcg_rprim: "\<lbrakk> GETr C x = Some T; GETr C y = Some TT\<rbrakk>
                 \<Longrightarrow> G \<rhd>  RPrimop f x y : \<lbrace> {x, y} , n , C \<ggreater> IntET , n \<rbrace>" by (rule DA_Rprim, (erule GETrSome_DOM)+, simp)

lemma vcg_call: "\<not> isMergePoint f \<and> (dominates f, G, f, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>) \<in> DOM_Call \<or>
                 isMergePoint ?f \<and> (CALL f, \<lbrace>U, n , restr C (ParList2RnameList (fst (funtable f))) \<ggreater> T , m \<rbrace>) \<in> G \<and>
                         U \<subseteq> set (ParList2RnameList (fst (funtable ?f))) \<Longrightarrow>
                 G \<rhd>  (CALL f) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>"by (rule DA_Call1_MP)
 
lemma vcg_letprim:"G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace> \<Longrightarrow> G \<rhd> (LET z =Primop f x y IN e END) : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>" by (rule DA_Let_Prim)
lemma vcg_letrprim:
 "\<lbrakk>GETr C x = Some T1; GETr C y = Some T2; G \<rhd> e : \<lbrace>U, n, C \<ggreater> T, m\<rbrace>\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET z = RPrimop f x y IN e END) : \<lbrace>{x, y} \<union> U, n, C \<ggreater> T, m\<rbrace> " by(erule DA_Let_RPrim, (erule GETrSome_DOM)+)

lemma vcg_TreeMatchD:
"\<lbrakk>GETr C t = Some (TreeET k); nk = n + k + 1; left \<noteq> right;
  G \<rhd> e : \<lbrace>U, nk, C(left\<mapsto>\<^sub>fTreeET k)(right\<mapsto>\<^sub>fTreeET k) \<ggreater> T, m\<rbrace> ; 
  t \<notin> U \<union> {left, right}\<rbrakk>
\<Longrightarrow> G \<rhd>  (LET cont =t\<bullet>V0; rf left =t\<diamondsuit>R1; rf right =t\<diamondsuit>R2;  _ =DIAM\<bullet>Free([RNarg t]) 
          IN e END) : \<lbrace>U - {left, right} \<union> {t}, n, C \<ggreater> T, m\<rbrace>"
by (rule DA_TreeMatchD)
lemma vcg_ResultMatchD: 
"\<lbrakk>GETr C l = Some (ResultET kN TT kS); nk = n+kS+1; l \<noteq> t; 
  G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>fTT) \<ggreater> T, m\<rbrace>;
  l \<notin> U\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l V0; rf t = GetFr l R1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>" by(rule DA_ResultMatchD)
lemma vcg_ListMatchD: 
"\<lbrakk>GETr C l = Some (ListET k); nk = n+k+1; l \<noteq> t; 
  G \<rhd> e : \<lbrace>U, nk, C(t\<mapsto>\<^sub>f(ListET k)) \<ggreater> T, m\<rbrace>;
  l \<notin> U\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET h = GetFi l V0; rf t = GetFr l R1; _ = DIAM\<bullet>Free ([RNarg l]) IN e END) : \<lbrace>(U-{t}) \<union> {l}, n, C \<ggreater> T, m\<rbrace>" by (rule DA_ListMatchD)

lemma vcg_letrinvokeconst: 
  "\<lbrakk>(c\<bullet>M(L), sMST c M L): G;
     \<forall> E h hh v p. sMST c M L E h hh v p \<longrightarrow> \<lbrace>U, n, C \<ggreater> T1, m\<rbrace> E h hh v p;
     \<forall> x. x:U \<longrightarrow> GETr D x = GETr C x; nk = n+k;
     mk = m+ k; T1 \<notin> {IntET, UnitET};
     G \<rhd> e : \<lbrace>V, mk, D(x\<mapsto>\<^sub>fT1) \<ggreater> T, l\<rbrace>;
     U \<inter> (V-{x})={}\<rbrakk>
   \<Longrightarrow> G \<rhd>  (LET rf x = c\<bullet>M(L) IN e END) : \<lbrace>U \<union> (V-{x}), nk, D \<ggreater> T, l\<rbrace>" by (erule DA_Letr_InvokeConst, simp+)
lemma vcg_letrmaketree:
     "\<lbrakk>GETr C y = Some (TreeET k);GETr C z = Some (TreeET k); y\<noteq>z; n=(Suc m + k);
        G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fTreeET(k)) \<ggreater> T, l\<rbrace>;
        {y,z} \<inter> (U-{x}) = {}\<rbrakk>
     \<Longrightarrow> G \<rhd> (LET rf x = DIAM\<bullet>Make_IIDD ([VALarg (IVal 3), INarg v, RNarg y, RNarg z]) IN e END): \<lbrace>({y,z} \<union> (U-{x})), n, C \<ggreater> T, l\<rbrace>" by (erule DA_LetrMakeTree, simp+)

lemma vcg_domcallnil:"\<lbrakk>finite G; G \<rhd> snd(funtable f):P\<rbrakk> \<Longrightarrow> ([],G,f,P) : DOM_Call" by (erule DOM_CallNIL, assumption)
lemma vcg_domcallcons: "\<lbrakk>G \<rhd> snd(funtable h): \<lbrace>U, n, C \<ggreater> T, m\<rbrace>;
                         (t,{(Call h, \<lbrace>U, n, C \<ggreater> T, m\<rbrace>)} \<union> G,f,P):DOM_Call\<rbrakk>
                      \<Longrightarrow> ( h # t, G, f, P):DOM_Call" by (rule DOM_CallCONS)
lemma vcg_letnull: 
"\<lbrakk>G \<rhd> e : \<lbrace>U, m, C(x\<mapsto>\<^sub>fT1) \<ggreater> T2, k\<rbrace>; T1 \<notin> {IntET, UnitET};
  G \<rhd> Null : \<lbrace>{}, n, C \<ggreater> T1, m\<rbrace>\<rbrakk>
 \<Longrightarrow> G \<rhd> (LET rf x = Null IN e END): \<lbrace>U-{x}, n, C \<ggreater> T2, k\<rbrace>" by (erule DA_Let_Null)

lemmas DA_Nullrules = DA_NullList DA_NullTree DA_NullResult 

(*lemmas vcg_matches = vcg_TreeMatchD DA_ListMatchD DA_ResultMatchD DA_TreeMatch DA_ListMatch DA_ResultMatch*)

lemmas vcg = vcg_call vcg_letprim vcg_letrprim DA_Let_Int vcg_int DA_if vcg_letrmaketree DA_MakeTree
                  DA_MakeResultSome1 DA_MakeList vcg_letrinvokeconst DA_InvokeConst vcg_letnull(* DA_Nullrules; better do these type-specific*)
(*                  vcg_matches*)


text {*In order to prove the body correct we define a 
       context which contains an one entry for each syntactic method invocation.*}
constdefs  HeapSortContext:: vdmcontext
"HeapSortContext \<equiv> {(HS\<bullet>Insert([INarg x_,RNarg r2_]), sMST HS Insert [INarg x_,RNarg r2_]),
                    (HS\<bullet>Insert([INarg v4_,RNarg r2_]), sMST HS Insert [INarg v4_,RNarg r2_]),
                    (HS\<bullet>Insert([INarg v2_,RNarg l_]), sMST HS Insert [INarg v2_,RNarg l_]),
                    (HS\<bullet>Removesome([RNarg r1_]), sMST HS Removesome [RNarg r1_]),
                    (HS\<bullet>Removetop([RNarg h_]), sMST HS Removetop [RNarg h_]),
                    (HS\<bullet>Extract([RNarg r1_]), sMST HS Extract [RNarg r1_]),
                    (HS\<bullet>Make_heap([RNarg l_]), sMST HS Make_heap [RNarg l_]),
                    (HS\<bullet>Make_heap([RNarg r1_]), sMST HS Make_heap [RNarg r1_]),
                    (HS\<bullet>Siftdown([INarg v2_, RNarg r3_, RNarg r1_]), sMST HS Siftdown [INarg v2_, RNarg r3_, RNarg r1_]),
                    (HS\<bullet>Siftdown([INarg w_, RNarg r5_, RNarg r4_]), sMST HS Siftdown [INarg w_, RNarg r5_, RNarg r4_]),
                    (HS\<bullet>Siftdown([INarg w_, RNarg r8_, RNarg r7_]), sMST HS Siftdown [INarg w_, RNarg r8_, RNarg r7_]),
                    (HS\<bullet>Sort([RNarg l_]), sMST HS Sort [RNarg l_])}"

text {*The applications of rule Cut2Call occur at the beginning 
       of the immediate dominator of the merge point:
       in f3 for f4, and in f10 for f11*}

lemma HSContext_finite[simp]: "finite HeapSortContext"
by (simp add: HeapSortContext_def)

lemma Removesome_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Removesome) : SPEC Removesome"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (simp add: MFS_defs)
(*Call*)
apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
(*domcall*)
apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
(*letrprim*)
apply (rule vcg_letrprim) apply simp apply simp
(*if*)
apply (rule DA_If)
(*branch 1*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*Null*)
  apply (simp?, rule DA_NullResult, simp)
(*branch 2*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*TreematchD*)
  apply ((rule vcg_ListMatchD, fastsimp) | (rule vcg_ResultMatchD, fastsimp) | (rule vcg_TreeMatchD, fastsimp)) apply simp apply simp 
  txt {*one side condition remains at position 2, we first have to go into the program continuation*}
  (*LetrInvoke*)
  apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                   apply (clarsimp, erule Removesome_Invoke)
                                   apply simp
                                   apply simp
                                   apply simp
                                   apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
  (*letrprim*)
  apply (rule vcg_letrprim) apply simp apply simp
  (*if*)
  apply (rule DA_If)
  (*branch 1*)
    (*Call*)
    apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
    (*domcall*)
    apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
    (*make*)
    apply (rule DA_MakeResultSome1) apply simp apply simp
  (*branch 2*)
    (*Call*)
    apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
    (*domcall*)
    apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
    (*ResultmatchD*)
    apply ((rule vcg_ListMatchD, fastsimp) | (rule vcg_ResultMatchD, fastsimp) | (rule vcg_TreeMatchD, fastsimp)) apply simp apply simp 
  txt {*one side condition remains at position 2, we first have to go into the program continuation*}
    (*make*)
    apply (rule vcg_letrmaketree) apply simp apply simp apply simp apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
    (*make*)
    apply (rule DA_MakeResultSome1) apply simp apply simp 
  apply simp (*from LetrMake*)
  apply simp (*from MatchD*)
  apply simp (*from LetrInvoke*)
  apply simp (*from MatchD*)
by fast

lemma Removetop_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Removetop) : SPEC Removetop"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (simp add: MFS_defs)
(*Call*)
apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
(*domcall*)
apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
(*letrprim*)
apply (rule vcg_letrprim) apply simp apply simp
(*if*)
apply (rule DA_If)
(*branch 1*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*Null*)
  apply (simp?,rule DA_NullResult,simp)
(*branch 2*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*ResultmatchD*)
  apply ((rule vcg_ListMatchD, fastsimp) | (rule vcg_ResultMatchD, fastsimp) | (rule vcg_TreeMatchD, fastsimp)) apply simp apply simp 
  txt {*one side condition remains at position 2, we first have to go into the program continuation*}
  (*LetrInvoke*)
  apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                   apply (clarsimp, erule Removesome_Invoke)
                                   apply simp
                                   apply simp
                                   apply simp
                                   apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
  (*letrprim*)
  apply (rule vcg_letrprim) apply simp apply simp
  (*if*)
  apply (rule DA_If)
  (*branch 1*)
    (*Call*)
    apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
    (*domcall*)
    apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
    (*make*)
    apply (rule DA_MakeResultSome1) apply simp apply simp 
  (*branch 2*)
    (*Call*)
    apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
    (*domcall*)
    apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
    (*ResultmatchD*)
    apply ((rule vcg_ListMatchD, fastsimp) | (rule vcg_ResultMatchD, fastsimp) | (rule vcg_TreeMatchD, fastsimp)) apply simp apply simp 
    txt {*one side condition remains at position 2, we first have to go into the program continuation*}
    (*LetrInvoke*)
    apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                     apply (clarsimp, erule Siftdown_Invoke, simp) (*Siftdown_Invoke has a second precondition!*)
                                     apply simp
                                     apply simp
                                     apply simp
                                     apply simp
    txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
    (*make*)
    apply (rule DA_MakeResultSome1) apply simp apply simp 
    apply simp (*invoke*)
    apply simp (*match*)
  apply simp (*invoke*)
  apply simp (*match*)
by fast

lemma Make_heap_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Make_heap) : SPEC Make_heap"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (simp add: MFS_defs)
(*Call*)
apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
(*domcall*)
apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
(*letrprim*)
apply (rule vcg_letrprim) apply simp apply simp
(*if*)
apply (rule DA_If)
(*branch 1*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*Null*)
  apply (simp?, rule DA_NullTree)
(*branch 2*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*ListmatchD*)
  apply ((rule vcg_ListMatchD, fastsimp) | (rule vcg_ResultMatchD, fastsimp) | (rule vcg_TreeMatchD, fastsimp)) apply simp apply simp 
  txt {*one side condition remains at position 2, we first have to go into the program continuation*}
  (*LetrInvoke*)
  apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                   apply (clarsimp, erule Make_heap_Invoke)
                                   apply simp
                                   apply simp
                                   apply simp
                                   apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
  (*invoke*)
  apply (rule DA_InvokeConst) apply (simp add: HeapSortContext_def)
                              apply (clarsimp, erule Insert_Invoke)
                              apply simp
                              apply simp
                              apply simp
  apply simp (*letrinvoke*)
  apply simp (*listmatchD*)
by fast

lemma Extract_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Extract) : SPEC Extract"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (simp add: MFS_defs)
(*Call*)
apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
(*domcall*)
apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
(*LetrInvoke*)
apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                 apply (clarsimp, erule Removetop_Invoke)
                                 apply simp
                                 apply simp
                                 apply simp
                                 apply simp
txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
(*letrprim*)
apply (rule vcg_letrprim) apply simp apply simp
(*if*)
apply (rule DA_If)
(*branch 1*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*Null*)
  apply (simp?, rule DA_NullList)
(*branch 2*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*ResultmatchD*)
  apply ((rule vcg_ListMatchD, fastsimp) | (rule vcg_ResultMatchD, fastsimp) | (rule vcg_TreeMatchD, fastsimp)) apply simp apply simp 
  txt {*one side condition remains at position 2, we first have to go into the program continuation*}
  (*LetrInvoke*)
  apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                   apply (clarsimp, erule Extract_Invoke)
                                   apply simp
                                   apply simp
                                   apply simp
                                   apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
  (*make*)
  apply (rule DA_MakeList) apply simp apply simp 
  apply simp (*letrinvoke*)
  apply simp (*match*)
  apply simp (*letrinvoke*)
by fast

lemma Insert_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Insert) : SPEC Insert"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (simp add: MFS_defs)
(*Call*)
apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
(*domcall*)
apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
(*letrprim*)
apply (rule vcg_letrprim) apply simp apply simp
(*if*)
apply (rule DA_If)
(*branch 1*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*letnull*)
  apply (rule vcg_letnull) 
  txt {*LetNull lets us first do the continuation, so 2 goals remain at positions 2 and 3*}
  (*letnull*)
  apply (rule vcg_letnull) 
  txt {*LetNull lets us first do the continuation, so 2 goals remain at positions 2 and 3*}
  (*make*)
  apply (rule DA_MakeTree) apply simp apply simp apply simp apply simp 
  txt {*back to second null*}
  apply simp
  (*Null*)
  apply (simp?, rule DA_NullTree)
  txt {*back to first null*}
  apply simp
  (*Null*)
  apply (simp?, rule DA_NullTree)
(*branch 2*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*TreematchD*)
  apply ((rule vcg_ListMatchD, fastsimp) | (rule vcg_ResultMatchD, fastsimp) | (rule vcg_TreeMatchD, fastsimp)) apply simp apply simp 
  txt {*one side condition remains at position 2, we first have to go into the program continuation*}
  (*letprim*)
  apply (rule vcg_letprim) 
  (*if*)
  apply (rule DA_If)
  (*branch 1*)
    (*Call*)
    apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
    (*domcall*)
    apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
    (*LetrInvoke*)
    apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                     apply (clarsimp, erule Insert_Invoke)
                                     apply simp
                                     apply simp
                                     apply simp
                                     apply simp
    txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
    (*make*)
    apply (rule DA_MakeTree) apply simp apply simp apply simp apply simp
  apply simp (*letrinvoke*)
  (*branch 2*)
    (*Call*)
    apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
    (*domcall*)
    apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
    (*LetrInvoke*)
    apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                     apply (clarsimp, erule Insert_Invoke)
                                     apply simp
                                     apply simp
                                     apply simp
                                     apply simp
    txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
    (*make*)
    apply (rule DA_MakeTree) apply simp apply simp apply simp apply simp
  apply simp (*letrinvoke*)
 apply simp (*treematchD*)
by fast

lemma Sort_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Sort) : SPEC Sort"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (simp add: MFS_defs)
(*Call*)
apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
(*domcall*)
apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
(*LetrInvoke*)
apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                 apply (clarsimp, erule Make_heap_Invoke)
                                 apply simp
                                 apply simp
                                 apply simp
                                 apply simp
txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
(*invoke*)
apply (rule DA_InvokeConst) apply (simp add: HeapSortContext_def)
                            apply (clarsimp, erule Extract_Invoke)
                            apply simp
                            apply simp
                            apply simp
apply simp (*letrinvoke*)
by fast

lemma Siftdown_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Siftdown) : SPEC Siftdown"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (simp add: MFS_defs)
(*Call*)
apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
(*domcall*)
apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
(*Letrprim*)
apply (rule vcg_letrprim) apply simp apply simp
(*If*)
apply (rule DA_If)
(*branch 1*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*letnull*)
  apply (rule vcg_letnull) 
  txt {*LetNull lets us first do the continuation, so 2 goals remain at positions 2 and 3*}
  (*letnull*)
  apply (rule vcg_letnull) 
  txt {*LetNull lets us first do the continuation, so 2 goals remain at positions 2 and 3*}
  (*make*)
  apply (rule DA_MakeTree) apply simp apply simp apply simp apply simp 
  txt {*back to second null*}
  apply simp
  (*Null*)
  apply (simp?, rule DA_NullTree)
  txt {*back to first null*}
  apply simp
  (*Null*)
  apply (simp?, rule DA_NullTree)
(*branch 2*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*TreematchD*)
  apply ((rule vcg_ListMatchD, fastsimp) | (rule vcg_ResultMatchD, fastsimp) | (rule vcg_TreeMatchD, fastsimp)) apply simp apply simp 
  txt {*one side condition remains at position 2, we first have to go into the program continuation*}
  (*Letrprim*)
  apply (rule vcg_letrprim) apply simp apply simp
  (*If*)
  apply (rule DA_If)
  (*branch 1*)
    (*Call*)
    apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
    (*domcall*)
    apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
    (*Letprim*)
    apply (rule vcg_letprim) 
    (*If*)
    apply (rule DA_If)
    (*branch 1*)
      (*Call*)
      apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
      (*domcall*)
      apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
      (*letnull*)
      apply (rule vcg_letnull) 
      txt {*LetNull lets us first do the continuation, so 2 goals remain at positions 2 and 3*}
      (*letnull*)
      apply (rule vcg_letnull) 
      txt {*LetNull lets us first do the continuation, so 2 goals remain at positions 2 and 3*}
      (*make*)
      apply (rule vcg_letrmaketree) apply simp apply simp apply simp apply simp
      txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
      (*letnull*)
      apply (rule vcg_letnull) 
      txt {*LetNull lets us first do the continuation, so 2 goals remain at positions 2 and 3*}
      (*make*)
      apply (rule DA_MakeTree) apply simp apply simp apply simp apply simp
      txt {*back to third null*}
      apply simp
      (*Null*)
      apply (simp?, rule DA_NullTree)
      apply simp (*letrmaketree*)
      txt {*back to second null*}
      apply simp
      (*Null*)
      apply (simp?, rule DA_NullTree)
      txt {*back to first null*}
      apply simp
      (*Null*)
      apply (simp?, rule DA_NullTree)
    (*branch 2*)
      (*Call*)
      apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
      (*domcall*)
      apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
      (*letnull*)
      apply (rule vcg_letnull) 
      txt {*LetNull lets us first do the continuation, so 2 goals remain at positions 2 and 3*}
      (*letnull*)
      apply (rule vcg_letnull) 
      txt {*LetNull lets us first do the continuation, so 2 goals remain at positions 2 and 3*}
      (*make*)
      apply (rule vcg_letrmaketree) apply simp apply simp apply simp apply simp
      txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
      (*letnull*)
      apply (rule vcg_letnull) 
      txt {*LetNull lets us first do the continuation, so 2 goals remain at positions 2 and 3*}
      (*make*)
      apply (rule DA_MakeTree) apply simp apply simp apply simp apply simp
      txt {*back to third null*}
      apply simp
      (*Null*)
      apply (simp?, rule DA_NullTree)
      apply simp (*letrmaketree*)
      txt {*back to second null*}
      apply simp
      (*Null*)
      apply (simp?, rule DA_NullTree)
      txt {*back to first null*}
      apply simp
      (*Null*)
      apply (simp?, rule DA_NullTree)
  (*branch 2*) (*dominator-mergepointstuff starts here*)
    (*Call*)
    apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
    (*domcall*)
    apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
    (*TreematchD STAR*)
    apply ((rule vcg_ListMatchD, fastsimp) | (rule vcg_ResultMatchD, fastsimp) | (rule vcg_TreeMatchD, fastsimp)) apply simp apply simp 
    txt {*one side condition remains at position 2, we first have to go into the program continuation*}
    (*Letprim*)
    apply (rule vcg_letprim) 
    (*If*)
    apply (rule DA_If)
    (*branch 1*)
      (*Call*)
      apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
      (*domcall*)
      apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
      (*Letprim*)
      apply (rule vcg_letprim) 
      (*If*)
      apply (rule DA_If)
      (*branch 1*)
        (*Call*)
        apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
        (*domcall*)
        apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
        (*letint*)
        apply (rule DA_Let_Int) 
        (*Call*)
        (*This is the first call to ffour*)
        apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
        (* don't try to look for an entry in HeapSortContext, but take the first disjunct*)
        apply rule apply (rule disjI1, simp)
        (* leave the subset inclusion for later. the verification of the body of ffour
           will instantiate U*) defer 1
      (*branch 2*)
        (*Call*)
        apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
        (*domcall*) 
        apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
        (*letint*)
        apply (rule DA_Let_Int) 
        (*Call*)
        (*This is the second call to ffour*)
        apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
        (* don't try to look for an entry in HeapSortContext, but take the first disjunct*)
        apply rule apply (rule disjI1, simp)
        (* leave the subset inclusion for later. the verification of the body of ffour
           will instantiate U*) defer 1
    (*branch 2*)
      (*Call*)
      apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
      (*domcall*)
      apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
      (*letint*)
      apply (rule DA_Let_Int) 
      (*Call*)
      (*This is the third call to ffour*)
      apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
      (* don't try to look for an entry in HeapSortContext, but take the first disjunct*)
      apply rule apply (rule disjI1, simp)
      (* leave the subset inclusion for later. the verification of the body of ffour
         will instantiate U*) defer 1
defer 1 txt {*this constraint came frome TreematchD STAR - but it cannot be solved yet, although we can already see that it will be fulfilled!!!!*}
(*verification of ffour*)
apply (simp add: MFS_defs)
(*Letprim*)
apply (rule vcg_letprim) 
(*If*)
apply (rule DA_If)
(*branch 1*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*make*)
  apply (rule vcg_letrmaketree) apply simp apply simp apply simp apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
  (*make*)
  apply (rule vcg_letrmaketree) apply simp apply simp apply simp apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
  (*make*)
  apply (rule DA_MakeTree) apply simp apply simp apply simp apply simp 
  apply simp (*letrmaketree*)
  apply simp (*letrmaketree*)
(*branch 2*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*Letprim*)
  apply (rule vcg_letprim) 
  (*If*)
  apply (rule DA_If)
  (*branch 1*)
    (*Call*)
    apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
    (*domcall*)
    apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
    (*Letprim*)
    apply (rule vcg_letprim) 
    (*If*)
    apply (rule DA_If)
    (*branch 1*)
      (*Call*)
      apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
      (*domcall*)
      apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
      (*letint*)
      apply (rule DA_Let_Int) 
      (*Call*)
      (*This is the first call to feleven*)
      apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
      (* don't try to look for an entry in HeapSortContext, but take the first disjunct*)
      apply rule apply (rule disjI1, simp)
      (* leave the subset inclusion for later. the verification of the body of ffour
         will instantiate U*) defer 1
    (*branch 2*)
      (*Call*)
      apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
      (*domcall*)
      apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
      (*letint*)
      apply (rule DA_Let_Int) 
      (*Call*)
      (*This is the second call to feleven*)
      apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
      (* don't try to look for an entry in HeapSortContext, but take the first disjunct*)
      apply rule apply (rule disjI1, simp)
      (* leave the subset inclusion for later. the verification of the body of ffour
         will instantiate U*) defer 1
  (*branch 2*)
    (*Call*)
    apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
    (*domcall*)
    apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
    (*letint*)
    apply (rule DA_Let_Int) 
    (*Call*)
      (*This is the second call to feleven*)
      apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
      (* don't try to look for an entry in HeapSortContext, but take the first disjunct*)
      apply rule apply (rule disjI1, simp)
      (* leave the subset inclusion for later. the verification of the body of ffour
         will instantiate U*) defer 1
(*verification of feleven*)
apply (simp add: MFS_defs)
(*Letprim*)
apply (rule vcg_letprim) 
(*If*)
apply (rule DA_If)
(*branch 1*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*make*)
  apply (rule vcg_letrmaketree) apply simp apply simp apply simp apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
  (*LetrInvoke*)
  apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                   apply (clarsimp, erule Siftdown_Invoke, simp)
                                   apply simp
                                   apply simp
                                   apply simp
                                   apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
  (*make*)
  apply (rule DA_MakeTree) apply simp apply simp apply simp apply simp
  apply simp (*invokeconst*)
  apply simp (*letrmaketree*)
(*branch 2*)
  (*Call*)
  apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def MFS_defs)
  (*domcall*)
  apply ((rule DOM_CallCONS) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs)
  (*LetrInvoke*)
  apply (rule vcg_letrinvokeconst) apply (simp add: HeapSortContext_def)
                                   apply (clarsimp, erule Siftdown_Invoke, simp)
                                   apply simp
                                   apply simp
                                   apply simp
                                   apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
  (*make*)
  apply (rule vcg_letrmaketree) apply simp apply simp apply simp apply simp
  txt {*one side conditions remains at position 2, we first have to go into the program continuation*}
  (*make*)
  apply (rule DA_MakeTree) apply simp apply simp apply simp apply simp
  apply simp (*letrmaketree*)
  apply simp (*invokeconst*)
apply fastsimp+
done

lemma HeapSortContext_good: "goodContext FST vMST sMST HeapSortContext"
apply (simp add: goodContext_def)
apply (simp only: HeapSortContext_def)
apply (rule, rule, rule)
apply (rule disjI2, rule disjI2)
apply safe
(*Insert*)
    apply clarsimp
    apply (rule vdm_conseq, rule Insert_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Insert SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Insert*)
    apply clarsimp
    apply (rule vdm_conseq, rule Insert_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Insert SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Insert*)
    apply clarsimp
    apply (rule vdm_conseq, rule Insert_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Insert SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Removesome*)
    apply clarsimp
    apply (rule vdm_conseq, rule Removesome_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Removesome SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)  
(*Removetop*)
    apply clarsimp
    apply (rule vdm_conseq, rule Removetop_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Removetop SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Extract*)
    apply clarsimp
    apply (rule vdm_conseq, rule Extract_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Extract SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst) 
(*Make_heap*)
    apply clarsimp
    apply (rule vdm_conseq, rule Make_heap_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Make_heap SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
 (*Make_heap*)
    apply clarsimp
    apply (rule vdm_conseq, rule Make_heap_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Make_heap SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Siftdown*)
    apply clarsimp
    apply (rule vdm_conseq, rule Siftdown_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Siftdown SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)  
(*Siftdown*)
    apply clarsimp
    apply (rule vdm_conseq, rule Siftdown_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Siftdown SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Siftdown*)
    apply clarsimp
    apply (rule vdm_conseq, rule Siftdown_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Siftdown SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
(*Sort*)
    apply clarsimp
    apply (rule vdm_conseq, rule Sort_DAss)
    apply (simp add: HeapSortContext_def)
    apply clarify
    apply (simp add: sMST_def Meth_Sort SPEC_def newframe_env_def evalARGS_def self_def) 
    apply (erule DAss_PConst)
done

text {*Thus, we can prove that arbitrary invocations of @{text Sort} honour
       the entry in the specification table, in the empty VDM context.*}
theorem HSCorrect: "\<rhd> HS\<bullet>Sort([RNarg x]): sMST HS Sort [RNarg x]"
apply (rule GCInvs)
apply (rule HeapSortContext_good)
apply (simp_all add: HeapSortContext_def)
apply fastsimp
done 
theorem "\<rhd> HS\<bullet>Sort([RNarg x]): \<lbrace> {x}, 0 , (emptyfinmap(x \<mapsto>\<^sub>f(ListET 0)))  \<ggreater> (ListET 0) , 0 \<rbrace>"
by (rule vdm_conseq, rule HSCorrect, simp add: Sort_Invoke)

end

lemma Removetop_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Removetop) : SPEC Removetop"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+
(*invocation of Removesome*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Removesome_Invoke, fastsimp, simp+)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
(*invocation of Siftdown*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Siftdown_Invoke, fastsimp, simp+)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
apply fast
done

lemma Removesome_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Removesome) : SPEC Removesome"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+
(*invocation of Removesome*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Removesome_Invoke, fastsimp, simp+)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
apply fast
done
lemma Make_heap_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Make_heap) : SPEC Make_heap"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
(*invocation of Make_heap*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Make_heap_Invoke, fastsimp, simp+)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
(*invocation of Insert*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Insert_Invoke, fastsimp, simp+)
done

lemma Extract_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Extract) : SPEC Extract"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
(*invocation of Removetop*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Removetop_Invoke, fastsimp, simp+)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
(*invocation of Extract*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Extract_Invoke, fastsimp, simp+)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
done

lemma Insert_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Insert) : SPEC Insert"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
(*invocation of Insert*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Insert_Invoke, fastsimp, simp+)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
(*invocation of Insert*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Insert_Invoke, fastsimp, simp+)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
apply fast
done

lemma Sort_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Sort) : SPEC Sort"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
(*invocation of Make_heap*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Make_heap_Invoke, fastsimp, simp+)
apply ( (rule DA_ListMatchD, fastsimp, simp) | 
        (rule DA_ResultMatchD, fastsimp, simp) |
        (rule DA_TreeMatchD, fastsimp, simp) |
         rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+ 
(*invocation of Extract*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Extract_Invoke, fastsimp, simp+) 
done
lemma Siftdown_DAss:
"\<lbrakk>G = HeapSortContext\<rbrakk> \<Longrightarrow> G \<rhd> snd (methtable HS Siftdown) : SPEC Siftdown"
apply (simp add: SPEC_def)
apply (rule DA_Weak)
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+
apply rule apply fastsimp defer 1 apply simp+
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+
apply rule apply fastsimp defer 1 apply simp+
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+
apply rule apply fastsimp defer 1 apply simp+

defer 1 apply simp+
(*apply (rule DA_Call2) here we don't want to follow the merge-point route !!*)
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+
apply rule apply fastsimp defer 1 apply simp+
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+
apply rule apply fastsimp defer 1 apply simp+
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+
apply rule apply fastsimp defer 1 apply simp+

(*apply (rule DA_Call2) here we don't want to follow the merge-point route !!*)
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+
(*invocation of Siftdown*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Siftdown_Invoke, fastsimp, simp+)
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+
(*invocation of Siftdown*)
apply (simp add: HeapSortContext_def) apply clarsimp apply (erule Siftdown_Invoke, fastsimp, simp+)
apply (rule DA_rules | simp add: MFS_defs dominates_def | rule DOM_CallCONS | rule DOM_CallNIL)+

apply fastsimp+
done
