theory FlattenProof = Flatten + VCG:


defs SPEC_def:"SPEC M == 
 if M = Append then \<lbrace> {l1,l2}, 0, emptyfinmap(l1 \<mapsto>\<^sub>f(ListET 0 0))(l2 \<mapsto>\<^sub>f(ListET 0 0)) \<ggreater> ListET 0 0, 0\<rbrace> else
 if M = Flatten1 then \<lbrace> {t}, 0, (emptyfinmap(t \<mapsto>\<^sub>f(TreeET 1 0))) \<ggreater> ListET 0 0, 1\<rbrace> else 
 if M = Flatten2 then \<lbrace> {t}, 0, (emptyfinmap(t \<mapsto>\<^sub>f(TreeET 0 0))) \<ggreater> ListET 0 0, 0\<rbrace> else 
 (\<lambda> E h hh v p . False)"

constdefs flattenContext:: vdmcontext
"flattenContext \<equiv> {(FL\<bullet>Append ([RNarg v2, RNarg l2]), sMST FL Append [RNarg v2, RNarg l2]),
                    (FL\<bullet>Append ([RNarg l2, RNarg t]), sMST FL Append [RNarg l2, RNarg t]),
                    (FL\<bullet>Append ([RNarg v2, RNarg t]), sMST FL Append [RNarg v2, RNarg t]),
                    (FL\<bullet>Flatten2 ([RNarg v3]), sMST FL Flatten2 [RNarg v3]),
                    (FL\<bullet>Flatten2 ([RNarg v1]), sMST FL Flatten2 [RNarg v1]),
                    (FL\<bullet>Flatten1 ([RNarg l1]), sMST FL Flatten1 [RNarg l1]),
                    (FL\<bullet>Flatten1 ([RNarg l3]), sMST FL Flatten1 [RNarg l3])}"

lemmas meth_defs = Meth_Append Meth_Flatten1 Meth_Flatten2 SPEC_def
(*Meth_Flatten1*)

lemmas fun_defs = Fun_fFlatten2 Fun_foneFlatten2  Fun_fzeroFlatten2
                  Fun_fAppend Fun_fzeroAppend Fun_foneAppend
                  Fun_fFlatten1 Fun_foneFlatten1  Fun_fzeroFlatten1
lemmas dmp_defs = dominates_def isMergePoint_def 
lemmas ctxt_def  = flattenContext_def

method_setup method_W = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) ctxt 1)) *}
  "Method for starting: use weakening, simplification with args, fast" 

method_setup Wp = {* Method.thms_ctxt_args (fn pdefs => fn ctxt => 
  Method.METHOD (fn facts => w_tac (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", pdefs, thms "ctxt_def")) ctxt 1)) *}
  "parametric Method for starting: use weakening, simplification with args, fast" 

lemma flattenContext_finite[simp]: "finite flattenContext"
by (simp add: flattenContext_def)

lemma Append_DAss:
"flattenContext \<rhd> snd (methtable FL Append) : SPEC Append"
by (Wp fun_defs)
method_setup method_leaf = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => leaf_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 1))  *}
 "Method for solving leaf cases in the derivation."    
 
method_setup method_If = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => if_tac ctxt stop stop 1)) *}
  "Method for If, reduces to two subgoals"

method_setup method_Let = {* Method.thms_ctxt_args (fn thms => fn ctxt => 
  Method.METHOD (fn facts => let_tac ctxt (thms,thms,thms) stop 1)) *}
  "Method for LetPrim/LetRPrim/LetNull, reduces to one subgoal"

method_setup method_Letinv = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for Letrinvoke"

method_setup method_Letinvs = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letinv_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             stop 1)) *}
  "Method for Letrinvoke"

(* apply (rule vcg_call) apply (simp add: dominates_def isMergePoint_def) *)
method_setup method_Call = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (stop ctxt) 1)) *}
  "Method for Call, leaves dominates subgoal"
(*
method_setup method_CallDom = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => call_tac ctxt thms (fn ctxt => fn thms => dom_tac ctxt thms (K stop)) 1)) *}
  "Method for Call, leaves dominates subgoal"
*)

(* apply (simp?, (rule DA_NullResult, simp) | rule DA_NullTree | rule DA_NullList) *)
method_setup method_Null = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => null_tac ctxt 1)) *}
  "Method for Nullresult, nulltree and nulllist"

(* FIXME: to combine method_Call with method_Dom or mergepoint stuff, we need to
   ideally need a method which accepts more than one parameter *)

(* apply ((rule vcg_domcallcons) | (rule vcg_domcallnil))+ apply simp apply (simp add: MFS_defs) *)
method_setup method_Dom = {* Method.thms_ctxt_args (fn thms => 
  fn ctxt => Method.METHOD (fn facts => dom_tac ctxt thms stop stop 1)) *}
  "Method for Dom" 

method_setup ltac = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac2 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac2 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac3 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac3 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac4 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac4 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac5 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac5 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup ltac6 = {* Method.ctxt_args (fn ctxt =>
  Method.METHOD (fn facts => l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") ctxt 1)) *}
  "Main method"

method_setup rmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for resultmatchd"

method_setup rmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => res_matchd_tac ctxt stop 1)) *}
  "test for resultmatchd"

method_setup lmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for listmatchd"

method_setup lmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_matchd_tac ctxt stop 1)) *}
  "test for listmatchd"

method_setup tmd = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_matchd_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for treematchd"

method_setup tmds = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_matchd_tac ctxt stop 1)) *}
  "test for treematchd"
method_setup method_fast = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => fst_tac 1)) *}
  "Method for fast"

method_setup tm = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_match_tac ctxt (l_tac (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "test for treematchd"

method_setup tms = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => node_match_tac ctxt stop 1)) *}
  "test for treematchd"

method_setup lms = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => cons_match_tac ctxt stop 1)) *}
  "test for treematchd"

method_setup method_simp = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => localsimp_tac ctxt 1)) *}
  "Method for simp"

method_setup method_Weaks = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") stop 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup method_Weak = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => weak_tac ctxt (thms "meth_defs") (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for starting: use weakening, simplification with args" 

method_setup method_REN = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => REN_tac 1)) *}
  "Method for starting: use weakening, simplification with args, fast"

method_setup method_LetinvRenS = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letrinvRename_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             stop 1)) *}
  "Method for Letrinvoke"
method_setup method_LetinvRen = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => letrinvRename_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def") 
                                             (l_tac6 (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")) 1)) *}
  "Method for Letrinvoke"
method_setup method_InvRen = {* Method.ctxt_args (fn ctxt => 
  Method.METHOD (fn facts => invrRename_tac ctxt (thms "dmp_defs", thms "meth_defs", thms "fun_defs", thms "ctxt_def")  1)) *}
  "Method for Letrinvoke"
method_setup match = {* Method.ctxt_args (
  fn ctxt => Method.METHOD (fn facts => match_tac ctxt stop 1)) *}
  "test for treematchd"
lemma Flatten2_DAss:
"flattenContext \<rhd> snd (methtable FL Flatten2) : SPEC Flatten2"
by (Wp fun_defs)

lemma Flatten1_DAss:
"flattenContext \<rhd> snd (methtable FL Flatten1) : SPEC Flatten1"
apply method_Weaks
apply ltac2
prefer 2 apply ltac6

apply method_Call
apply (simp add: dmp_defs)
apply (method_Dom fun_defs)
apply (rule DA_NullList)
(*verification fails since there is no free instruction which would allow us to gain
the one promised diamond associated with the LEAF constructor.
This is a general problem if a !-constructor carries a HoJo number \<noteq>0.
(Since our types are formulated for !Nil and !Leaf, introducing HoJo-numbers for these
constructors was pointless given our compilation. In principle, though, the fact that
the data item (empty list, leaf tree) does not consume memory should be independent from its
HoJo number - but then we need to introduce a free(nullref) instruction.*)
oops

lemmas DAss_lemmas = Flatten2_DAss Append_DAss

(*This lemma is absolutely trivial, but it allows us to unfold the InssortContext more cautiously*)
lemma triv: "\<lbrakk>x:S; S=S1; x:S1 \<longrightarrow> P\<rbrakk>\<Longrightarrow> P" by simp

lemma FlattenContext_good: "goodContext FST vMST sMST flattenContext"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (rule disjI2, rule disjI2)
apply (erule triv, simp add: flattenContext_def)
apply safe
(*fails since the entry for Flatten1 cannot be proven*)
by (simp only: sMST_def, clarsimp, rule vdm_conseq, rule DAss_lemmas, 
    clarify, simp add: SPEC_def , erule DAss_PConst)+

text {*Thus, we can prove that arbitrary invocations of @{text Sort} honour
       the entry in the specification table, in the empty VDM context.*}
theorem FL_Correct: "\<rhd> FL\<bullet>Flatten2([RNarg x]): sMST FL Flatten2 [RNarg x]"
apply (rule GCInvs)
apply (rule FlattenContext_good)
apply (simp_all add: flattenContext_def)
apply fastsimp
done 

theorem "\<rhd> FL\<bullet>Flatten2([RNarg y]): \<lbrace> {y}, 0, (emptyfinmap(y \<mapsto>\<^sub>f(TreeET 0))) \<ggreater> ListET 0 0, 0\<rbrace>"
apply (rule InvokeRename)
apply (rule FL_Correct)
apply (simp_all add: meth_defs newframe_env_def evalARGS_def)
apply (fastsimp intro: REN.intros)
apply simp+
done

end
