theory EH_Collecting = VDMderived + EvenOdd:

subsection{*Collecting Envs and heaps*}
consts Inv_PolicyEH::"(expr \<times> env \<times> heap) \<Rightarrow> ((env \<times> heap) list) \<Rightarrow> ((env \<times> heap) list)"
primrec
"Inv_PolicyEH (e, Eh) L = (case Eh of (E,h) \<Rightarrow> Eh # L)"

constdefs EH_Collect ::"((env \<times> heap) list) EFF"
"EH_Collect == \<lparr>
  Int_effect = (\<lambda> eEh . []),
  IVar_effect = (\<lambda> eEh . []),
  Primop_effect = (\<lambda> eEh . []),
  Null_effect = (\<lambda> eEh . []),
  RVar_effect = (\<lambda> eEh . []),
  RPrimop_effect = (\<lambda> eEh . []),
  New_effect = (\<lambda> eEh . []),
  GetFi_effect = (\<lambda> eEh . []),
  GetFr_effect = (\<lambda> eEh . []),
  PutFi_effect = (\<lambda> eEh . []),
  PutFr_effect = (\<lambda> eEh . []),
  GetStat_effect = (\<lambda> eEh . []),
  PutStat_effect = (\<lambda> eEh . []),

  InvV_effect = Inv_PolicyEH,
  InvS_effect = Inv_PolicyEH,
     
  Leti_effect = (\<lambda> eEh p1 p2 . p1 @ p2),
  Letr_effect = (\<lambda> eEh p1 p2 . p1 @ p2),
  Letv_effect = (\<lambda> eEh p1 p2 . p1 @ p2),
  If_effect = (\<lambda> eEh p. p),
  Call_effect = (\<lambda> eEh p . p)\<rparr>"

consts SysC::cname
       SysM::mname
       SysP1::iname
       SysP2::rname

axioms MTSys: "methtable SysC SysM = ([INpar SysP1, RNpar SysP2], Null)"


lemma Sys:"G \<rhd>  snd(methtable SysC SysM):
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = EH_Collect \<longrightarrow> p = []))"
apply (simp add: MTSys)
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: EH_Collect_def)
done

lemma Inv:"G \<rhd>  (SysC\<bullet>SysM(A)):
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = EH_Collect \<longrightarrow> p = [(E,h)]))"
apply (rule vdm_invokestatic)
apply (rule vdm_conseq, rule Sys)
apply (simp add: EH_Collect_def)
done

(*A first test of the policy*)
lemma "
  G \<rhd> (Letr z (SysC\<bullet>SysM([INarg x, RNarg a])) (SysC\<bullet>SysM([INarg x, RNarg a]))): 
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = EH_Collect \<longrightarrow> p = [(E,h),(E\<lfloor>z:=Nullref\<rfloor>,h)]))"
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply (rule Inv)
apply (rule Inv)
apply clarify
apply (simp add: EH_Collect_def)
done

datatype 'a LTL =
  atomLTL 'a
 | trueLTL
 | falseLTL
 | andLTL "'a LTL" "'a LTL"
 | orLTL "'a LTL" "'a LTL"
 | nextLTL "'a LTL"
 | untilLTL "'a LTL" "'a LTL"
 | releaseLTL "'a LTL" "'a LTL"

consts sat::"(((env \<times> heap) \<Rightarrow> 'a \<Rightarrow> bool) \<times> ((env \<times> heap) list) \<times> ('a LTL)) \<Rightarrow> bool"
recdef sat "measure (\<lambda> (I, L, P) . size P)"
"sat (I, L, atomLTL a) = (case L of [] \<Rightarrow> False | (s1 # s) \<Rightarrow> I s1 a)"
"sat (I, L, trueLTL) = True"
"sat (I, L, falseLTL) = False"
"sat (I, L, andLTL P Q) = ((sat (I, L, P) \<and> sat (I, L, Q)))"
"sat (I, L, orLTL P Q) = ((sat (I, L, P) \<or> sat (I, L, Q)))"
"sat (I, L, nextLTL P) = (case L of [] \<Rightarrow> False | (s1 # s) \<Rightarrow> sat (I,s,P))"
"sat (I, L, untilLTL P Q) = (\<exists> k. (sat (I, drop k L, Q) \<and> (\<forall> j . j < k \<longrightarrow> (sat (I, drop j L, P)))))"
"sat (I, L, releaseLTL P Q) = (\<forall> k. (sat (I, drop k L, Q) \<or> (\<exists> j . j < k \<longrightarrow> (sat (I, drop j L, P)))))"

constdefs eventuallyLTL::"'a LTL \<Rightarrow> 'a LTL"
"eventuallyLTL P == untilLTL trueLTL P"
constdefs generallyLTL::"'a LTL \<Rightarrow> 'a LTL"
"generallyLTL P == releaseLTL falseLTL P"

datatype AT = 
  rvar_isnull rname
  | ivar_is iname int

consts myI::"(env \<times> heap) \<Rightarrow> AT \<Rightarrow> bool"
primrec
"myI Eh (rvar_isnull z) = ((fst Eh)\<lfloor>z\<rfloor> = Nullref)"
"myI Eh (ivar_is z i) = ((fst Eh)<z> = i)"

lemma "
  G \<rhd> (Letr z (SysC\<bullet>SysM([INarg x, RNarg a])) (SysC\<bullet>SysM([INarg x, RNarg a]))): 
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = EH_Collect \<longrightarrow> sat (myI, p, nextLTL (atomLTL (rvar_isnull z)))))"
apply (rule vdm_conseq)
apply (rule vdm_letr)
apply (rule Inv)
apply (rule Inv)
apply clarify
apply (simp add: EH_Collect_def)
done

constdefs evenSpec::"ARGTYPE \<Rightarrow> ((env \<times> heap) list) vdmassn"
"evenSpec z ==  (\<lambda> P E h hh v p. (\<forall> w. z = [INarg w] \<longrightarrow> (\<exists> n. E<w> = 2 * n) \<longrightarrow> P = EH_Collect \<longrightarrow> 
                         ((0 = E<w> \<longrightarrow> sat (myI, p, (atomLTL (ivar_is w 0)))) \<and> 
                          (0 < E<w> \<longrightarrow> sat (myI, p, eventuallyLTL(orLTL (atomLTL (ivar_is x 0)) (atomLTL (ivar_is y 0))))))))"
(*
lemma "\<lbrakk>E<abc> = 0; EH_Collect | E \<turnstile> h,(SysC\<bullet>Even([INarg abc])) \<Down> hh,v,p\<rbrakk> \<Longrightarrow> p=sat (myI, p, eventuallyLTL(orLTL (atomLTL (ivar_is x 0)) (atomLTL (ivar_is y 0))))"
apply (simp add: sem_def, clarsimp)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_even, clarsimp)
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp apply (simp add: b_def x_def)
apply (erule eval_cases) apply clarsimp
apply (simp add: EH_Collect_def)
defer 1 apply (clarsimp) apply (simp add: b_def x_def)
apply (erule eval_cases) apply clarsimp
apply (simp add: EH_Collect_def)

lemma "evenSpec [INarg z] = (\<lambda> P E h hh v p . (E<z> = 6 \<and> P = EH_Collect) \<longrightarrow> sat (myI, p, eventuallyLTL(orLTL (atomLTL (ivar_is x 0)) (atomLTL (ivar_is y 0)))))"
apply (simp add: evenSpec_def)
apply (rule, rule, rule, rule, rule, rule)
apply clarsimp
apply rule
defer 1 apply clarsimp
oops
*)

constdefs oddSpec::"ARGTYPE \<Rightarrow> ((env \<times> heap) list) vdmassn"
"oddSpec z ==  (\<lambda> P E h hh v p. (\<forall> w . z = [INarg w] \<longrightarrow> 0 <= E<w> \<longrightarrow> (\<exists> n. E<w> = 1 + 2 * n)\<longrightarrow> 
                                 P = EH_Collect \<longrightarrow> sat (myI, p, eventuallyLTL(orLTL (atomLTL (ivar_is x 0)) (atomLTL (ivar_is y 0))))))"

consts FST ::"((env \<times> heap) list) FS_T"
       vMST::"((env \<times> heap) list) vMS_T"
constdefs sMST::"((env \<times> heap) list) sMS_T"
"sMST == (\<lambda> c m y . if c=SysC \<and> m = Even then evenSpec y else
                    if c=SysC \<and> m = Odd then oddSpec y else (\<lambda> P E h hh v p . False))"

constdefs G::"((env \<times> heap) list) vdmcontext"
"G == {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}"

lemma Int_Triv: "1 + 2 * (n::int) = 0 \<Longrightarrow> P" 
by (subgoal_tac "1 + 2 * (n::int) = 0 \<longrightarrow> False", simp, arith)


lemma G_good: "goodContext FST vMST sMST G"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (simp add: G_def)
apply (erule disjE)
apply (rule disjI2, rule disjI2)
apply clarsimp
  apply (simp add: MT_even)
  apply (rule vdm_conseq)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_if) 
  apply (rule vdm_int)
  apply (rule vdm_ax) 
    apply (subgoal_tac "(SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])
         \<in> {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}",
            assumption) apply simp
  apply clarsimp apply (case_tac "E<x>=0")
  apply clarsimp apply (simp add: x_def y_def b_def sMST_def newframe_env_def evalARGS_def evenSpec_def EH_Collect_def)
   apply clarsimp 
  apply clarsimp apply (simp add: x_def b_def sMST_def newframe_env_def evalARGS_def evenSpec_def EH_Collect_def)
   apply clarsimp  apply (simp add: Even_def Odd_def oddSpec_def evenSpec_def x_def ) 
    apply (subgoal_tac "\<exists>na. 2 * n = 2 + 2 * na") prefer 2 apply (rule_tac x="n - 1" in exI) apply simp 
    apply (erule impE, assumption) apply (erule exE) apply (simp add: EH_Collect_def) 
    apply (simp add: eventuallyLTL_def) apply clarsimp 
    apply (rule_tac x="Suc k" in exI, simp)
apply clarsimp
  apply (simp add: MT_odd)
  apply (rule vdm_conseq)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_if) 
  apply (rule vdm_int)
  apply (rule vdm_ax) 
    apply (subgoal_tac "(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y])
         \<in> {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}",
            assumption) apply simp
  apply clarsimp apply (case_tac "E<y>=0")
  apply clarsimp apply (simp add: x_def y_def b_def sMST_def newframe_env_def evalARGS_def oddSpec_def EH_Collect_def)
   apply clarsimp apply (simp add: Even_def Odd_def) apply clarsimp apply (erule Int_Triv)
  apply clarsimp apply (simp add: x_def y_def b_def sMST_def newframe_env_def evalARGS_def evenSpec_def oddSpec_def EH_Collect_def)
    apply (simp add: Even_def Odd_def) apply clarsimp
    apply (case_tac "n=0")
    apply clarsimp apply (simp add: eventuallyLTL_def) 
      apply (rule_tac x="Suc 0" in exI, simp)
    apply clarsimp apply (simp add: eventuallyLTL_def) apply clarsimp
      apply (rule_tac x="Suc k" in exI, simp)
done

lemma Even1: "\<rhd> (SysC\<bullet>Even([INarg y])) : evenSpec [INarg y]" 
apply (rule MUTREC)
apply (subgoal_tac "finite G", assumption, simp add: G_def)
apply (simp add: G_def)
apply (rule G_good)
apply (simp add: G_def Even_def Odd_def sMST_def)
done
lemma Even2: "\<rhd> (SysC\<bullet>Even([INarg z])) : sMST SysC Even [INarg z]" 
apply (rule GCInvs)
apply (rule G_good)
apply (simp add: G_def)
apply (simp add: G_def Even_def Odd_def)
apply fast
done
lemma Even3: "\<rhd> (SysC\<bullet>Even([INarg z])) : evenSpec [INarg z]" 
apply (rule vdm_conseq)
apply (rule Even2)
apply (simp add: sMST_def)
done
lemma Odd1: "\<rhd> (SysC\<bullet>Odd([INarg x])) : oddSpec [INarg x]" 
apply (rule MUTREC)
apply (subgoal_tac "finite G", assumption, simp add: G_def)
apply (simp add: G_def)
apply (rule G_good)
apply (simp add: G_def Even_def Odd_def sMST_def)
done
lemma Odd2: "\<rhd> (SysC\<bullet>Odd([INarg z])) : sMST SysC Odd [INarg z]" 
apply (rule GCInvs)
apply (rule G_good)
apply (simp add: G_def)
apply (simp add: G_def Even_def Odd_def)
apply fast
done
lemma Odd3: "\<rhd> (SysC\<bullet>Odd([INarg z])) : oddSpec [INarg z]" 
apply (rule vdm_conseq)
apply (rule Odd2)
apply (simp add: sMST_def Odd_def Even_def)
done

lemma "\<rhd> (SysC\<bullet>Odd([INarg a])) : (\<lambda> P E h hh v p . P = EH_Collect \<longrightarrow> E<a> = 55 \<longrightarrow> sat (myI, p, eventuallyLTL(orLTL (atomLTL (ivar_is x 0)) (atomLTL (ivar_is y 0)))))"
apply (rule vdm_conseq) apply (rule Odd3)
apply clarsimp
apply (simp add: oddSpec_def)
done

end


done

(*Policies for invokestatics may be specified later*)
consts Inv_policy:: "(expr \<times> env \<times> heap) \<Rightarrow> 'a \<Rightarrow> 'a"

constdefs Collect ::"('a list) EFF"
"Collect == \<lparr>
  Int_effect = (\<lambda> eEh . []),
  IVar_effect = (\<lambda> eEh . []),
  Primop_effect = (\<lambda> eEh . []),
  Null_effect = (\<lambda> eEh . []),
  RVar_effect = (\<lambda> eEh . []),
  RPrimop_effect = (\<lambda> eEh . []),
  New_effect = (\<lambda> eEh . []),
  GetFi_effect = (\<lambda> eEh . []),
  GetFr_effect = (\<lambda> eEh . []),
  PutFi_effect = (\<lambda> eEh . []),
  PutFr_effect = (\<lambda> eEh . []),
  GetStat_effect = (\<lambda> eEh . []),
  PutStat_effect = (\<lambda> eEh . []),

  InvV_effect = Inv_policy,
  InvS_effect = Inv_policy,
     
  Leti_effect = (\<lambda> eEh p1 p2 . p1 @ p2),
  Letr_effect = (\<lambda> eEh p1 p2 . p1 @ p2),
  Letv_effect = (\<lambda> eEh p1 p2 . p1 @ p2),
  If_effect = (\<lambda> eEh p. p),
  Call_effect = (\<lambda> eEh p . p)\<rparr>"


subsection{*Policies*}
consts Inv_Policy1::"(expr \<times> env \<times> heap) \<Rightarrow> (expr list) \<Rightarrow> (expr list)"
primrec
"Inv_Policy1 (e, Eh) L =
 (case Eh of (E,h) \<Rightarrow> e # L)"

constdefs Policy1::"bool"
"Policy1 == Inv_policy = Inv_Policy1"

lemma Sys:"Policy1 \<Longrightarrow> G \<rhd>  snd(methtable SysC SysM):
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = Collect \<longrightarrow> p = []))"
apply (simp add: MTSys)
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: Collect_def)
done

lemma Inv:"Policy1 \<Longrightarrow> G \<rhd>  (SysC\<bullet>SysM(y)):
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = Collect \<longrightarrow> p = [SysC\<bullet>SysM(y)]))"
apply (rule vdm_invokestatic)
apply (rule vdm_conseq, erule Sys)
apply (simp add: Collect_def)
apply (simp add: Policy1_def)
done

(*A first test of the policy*)
lemma "Policy1 \<Longrightarrow> 
  G \<rhd> (Leti x (expr.Int 21) (SysC\<bullet>SysM([INarg x, RNarg a]))): 
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = Collect \<longrightarrow> p = [SysC\<bullet>SysM([INarg x, RNarg a])]))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule Inv)
apply clarify
apply (simp add: Collect_def)
done

consts 
       M::mname
axioms MTSys: "methtable C M = ([], Null)"

lemma M_lemma:"Policy1 \<Longrightarrow> G \<rhd>  snd(methtable C M):
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = Collect \<longrightarrow> p = []))"
apply (simp add: MTSys)
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: Collect_def)
done

lemma InvM:"Policy1 \<Longrightarrow> G \<rhd>  (r\<diamondsuit>M([])):
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = Collect \<longrightarrow> p = [r\<diamondsuit>M([])]))"
apply (rule vdm_invoke)
apply clarsimp
apply (rule vdm_conseq)
apply (erule M_lemma)
apply (simp only: Policy1_def Collect_def)
apply simp
done

(*Second test*)
lemma "Policy1 \<Longrightarrow> \<rhd> (LET x = (expr.Int 21);
                             _ = (SysC\<bullet>SysM([INarg x, RNarg a]));
                          rf r = New C [] []
                          IN r\<diamondsuit>M([]) END): (\<lambda> P E h hh v p.  P = Collect \<longrightarrow> 
                                                p = [SysC\<bullet>SysM([INarg x, RNarg a]),r\<diamondsuit>M([])])"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letv, erule Inv)
apply (rule vdm_letr, rule vdm_new)
apply (erule InvM) 
apply clarify
apply (simp add: Collect_def)
done

(*Third test: the invocation trace of even/odd*)
constdefs Even::mname
"Even == MN ''Even''"
constdefs Odd::mname
"Odd == MN ''Odd''"
constdefs x::iname
"x == In ''x''"
constdefs y::iname
"y == In ''y''"
constdefs b::iname
"b == In ''b''"

axioms MT_even:
  "methtable SysC Even = ([INpar x], LET   b = x :0?; x = x :-- IN IF b THEN tt ELSE SysC\<bullet>Odd([INarg x]) END)"
axioms MT_odd:
  "methtable SysC Odd = ([INpar y], LET   b = y :0?; y = y :-- IN IF b THEN ff ELSE SysC\<bullet>Even([INarg y]) END)"

consts mkEOlist::"nat \<Rightarrow> (expr list)"
primrec
"mkEOlist 0 = []"
"mkEOlist (Suc n) = [SysC\<bullet>Even([INarg y]),SysC\<bullet>Odd([INarg x])] @ (mkEOlist n)"

constdefs mkListNat::"nat \<Rightarrow> (expr list)" 
"mkListNat n == (case (n mod 2) of
               0 \<Rightarrow> ((mkEOlist (n div 2)) @ [SysC\<bullet>Even([INarg y])])
             | Suc m \<Rightarrow> (mkEOlist (Suc (n div 2))))"
constdefs mkList::"int \<Rightarrow> (expr list)" 
"mkList i == (if i < 0 then [] else mkListNat (nat i))"
            
lemma "mkList 0 = [SysC\<bullet>Even([INarg y])]"
by (simp add: mkList_def mkListNat_def)
lemma "mkList 1 = [SysC\<bullet>Even([INarg y]), SysC\<bullet>Odd([INarg x])]"
by (simp add: mkList_def mkListNat_def)
lemma "mkList 2 = [SysC\<bullet>Even([INarg y]), SysC\<bullet>Odd([INarg x]), SysC\<bullet>Even([INarg y])]"
by (simp add: mkList_def mkListNat_def)

constdefs evenSpec::"ARGTYPE \<Rightarrow> (expr list) vdmassn"
"evenSpec z ==  (\<lambda> P E h hh v p. z = [INarg y] \<longrightarrow> 0 <= E<y> \<longrightarrow> (\<exists> n. E<y> = 2 * n) \<longrightarrow> P = Collect \<longrightarrow> p = mkList (E<y>))"

constdefs oddSpec::"ARGTYPE \<Rightarrow> (expr list) vdmassn"
"oddSpec z ==  (\<lambda> P E h hh v p. z = [INarg x] \<longrightarrow> 0 <= E<x> \<longrightarrow> (\<exists> n. E<x> = 1 + 2 * n)\<longrightarrow> P = Collect \<longrightarrow> p = (SysC\<bullet>Odd([INarg (In ''x'')])) # mkList ((E<x>) - 1))"

consts FST ::"(expr list) FS_T"
       vMST::"(expr list) vMS_T"
constdefs sMST::"(expr list) sMS_T"
"sMST == (\<lambda> c m y . if c=SysC \<and> m = Even then evenSpec y else
                    if c=SysC \<and> m = Odd then oddSpec y else (\<lambda> P E h hh v p . False))"

constdefs G::"(expr list) vdmcontext"
"G == {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}"

lemma mkListNat_1: "(SysC\<bullet>Even([INarg y])) # ((SysC\<bullet>Odd([INarg x])) # mkListNat (2 * n)) = mkListNat (2 * n + 2)"
apply (induct n)
apply (simp add: mkListNat_def)
apply (subgoal_tac "Suc (Suc 0) div 2 = 1", simp) apply arith
apply (simp add: mkListNat_def)
done

lemma mkList_1: "0 <= n \<Longrightarrow> (SysC\<bullet>Even([INarg y])) # ((SysC\<bullet>Odd([INarg x])) # mkList (2 * n)) = mkList (2 + 2 * n)"
apply (simp add: mkList_def) 
apply (subgoal_tac "nat (2 * n) = 2 * (nat n)",clarsimp)
apply (subgoal_tac "nat (2 + 2 * n ) = 2 * (nat n) + 2", clarsimp)
apply (rule mkListNat_1[simplified])
apply arith
apply arith
done

lemma G_good: "Policy1 \<Longrightarrow> goodContext FST vMST sMST G"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (simp add: G_def)
apply (erule disjE)
apply (rule disjI2, rule disjI2)
apply clarsimp
  apply (simp add: MT_even)
  apply (rule vdm_conseq)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_if) 
  apply (rule vdm_int)
  apply (rule vdm_ax) 
    apply (subgoal_tac "(SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])
         \<in> {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}",
            assumption) apply simp
  apply clarsimp apply (case_tac "E<x>=0")
  apply clarsimp apply (simp add: x_def y_def b_def sMST_def newframe_env_def evalARGS_def evenSpec_def Collect_def)
   apply clarsimp apply (simp add: Policy1_def mkList_def mkListNat_def x_def y_def)
  apply clarsimp apply (simp add: x_def b_def sMST_def newframe_env_def evalARGS_def evenSpec_def Collect_def)
   apply clarsimp apply (simp add: Even_def Odd_def Policy1_def  x_def oddSpec_def Collect_def)
    apply (subgoal_tac "\<exists>na. 2 * n = 2 + 2 * na") prefer 2 apply (rule_tac x="n - 1" in exI) apply simp 
    apply (erule impE, assumption) apply (erule exE) apply clarsimp
    apply (subgoal_tac "0 <= na", rotate_tac -1)
    apply (drule mkList_1) apply (simp add: Even_def Odd_def x_def) apply simp
apply clarsimp
  apply (simp add: MT_odd)
  apply (rule vdm_conseq)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_if) 
  apply (rule vdm_int)
  apply (rule vdm_ax) 
    apply (subgoal_tac "(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y])
         \<in> {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}",
            assumption) apply simp
  apply clarsimp apply (case_tac "E<y>=0")
  apply clarsimp apply (simp add: x_def y_def b_def sMST_def newframe_env_def evalARGS_def evenSpec_def Collect_def)
  apply clarsimp apply (simp add: x_def b_def sMST_def newframe_env_def evalARGS_def oddSpec_def Collect_def Even_def Odd_def)
   apply clarsimp apply (simp add: Policy1_def mkList_def) 
  apply clarsimp apply (simp add: x_def y_def b_def sMST_def newframe_env_def evalARGS_def
                                  evenSpec_def oddSpec_def Collect_def Even_def Odd_def)
    apply clarsimp apply (simp add:Policy1_def)
done

lemma Even1: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Even([INarg y])) : evenSpec [INarg y]" 
apply (rule MUTREC)
apply (subgoal_tac "finite G", assumption, simp add: G_def)
apply (simp add: G_def)
apply (erule G_good)
apply (simp add: G_def Even_def Odd_def sMST_def)
done
lemma Even2: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Even([INarg z])) : sMST SysC Even [INarg z]" 
apply (rule GCInvs)
apply (erule G_good)
apply (simp add: G_def)
apply (simp add: G_def Even_def Odd_def)
apply fast
done
lemma Even3: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Even([INarg z])) : evenSpec [INarg z]" 
apply (rule vdm_conseq)
apply (erule Even2)
apply (simp add: sMST_def)
done
lemma Odd1: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Odd([INarg x])) : oddSpec [INarg x]" 
apply (rule MUTREC)
apply (subgoal_tac "finite G", assumption, simp add: G_def)
apply (simp add: G_def)
apply (erule G_good)
apply (simp add: G_def Even_def Odd_def sMST_def)
done
lemma Odd2: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Odd([INarg z])) : sMST SysC Odd [INarg z]" 
apply (rule GCInvs)
apply (erule G_good)
apply (simp add: G_def)
apply (simp add: G_def Even_def Odd_def)
apply fast
done
lemma Odd3: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Odd([INarg z])) : oddSpec [INarg z]" 
apply (rule vdm_conseq)
apply (erule Odd2)
apply (simp add: sMST_def Odd_def Even_def)
done


end
