(*<*)
theory DAssU3 = NILList:
(*>*)

subsection {* Definition of derived assertions*}

subsubsection {* Types, contexts, regions, size of contexts*}
(*<*)
lemma SubsetTriv:"\<lbrakk>x:X; X \<subseteq> Y\<rbrakk> \<Longrightarrow> x:Y" by fast
(*>*)

datatype Type = UnitET | IntET | ListET nat

text{*Contexts*}
types Context = "(rname \<leadsto>\<^sub>f Type)"

constdefs DOM:: "Context \<Rightarrow> rname set"
"DOM == fmap_dom"

constdefs GETr :: "Context \<Rightarrow> rname \<Rightarrow> (Type option)"
"GETr G x \<equiv> fmap_lookup G x"

(*<*)
lemma GetNONE1: "x \<notin> DOM C \<Longrightarrow> None = GETr C x"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GetNONE2: "GETr C x = None \<Longrightarrow> x \<notin> DOM C"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_Update: "{x} \<union> (DOM b) = DOM (b(x\<mapsto>\<^sub>fk))" by (simp add: DOM_def)

lemma DOM_Update1: "\<lbrakk>y \<in> DOM (C(x\<mapsto>\<^sub>fT)); x \<noteq> y\<rbrakk> \<Longrightarrow> y:DOM C"
by (subgoal_tac "y \<noteq> x", insert DOM_Update, fast,fast)

lemma GETr_Update1: "x \<noteq> y \<Longrightarrow> GETr (G(x\<mapsto>\<^sub>fk)) y = GETr G y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (insert FMAPlookup2 [of y x G], auto)
done

lemma GETr_Update1a: "x \<noteq> y \<Longrightarrow> GETr G y = GETr (G(x\<mapsto>\<^sub>fk)) y"
apply (subgoal_tac "y \<noteq> x")
apply (simp add: GETr_def)
apply (insert FMAPlookup2 [of y x G], auto)
done

lemma GETr_Update2: "\<lbrakk>GETr G xa = Some T; x \<noteq> xa\<rbrakk> \<Longrightarrow> GETr (G(x\<mapsto>\<^sub>fk)) xa = Some T"
by (subgoal_tac "GETr (G(x\<mapsto>\<^sub>fk)) xa = GETr G xa", clarsimp, erule GETr_Update1)
lemma GETr_Trans1:"\<lbrakk>GETr C y = S; S=T; x\<noteq>y\<rbrakk> \<Longrightarrow> GETr (C(x\<mapsto>\<^sub>fTT)) y = T"
by (clarsimp, erule GETr_Update1)

lemma GETr_Trans2:"\<lbrakk>S = GETr C y; S=T; x\<noteq>y\<rbrakk> \<Longrightarrow> T = GETr (C(x\<mapsto>\<^sub>fTT)) y"
by (clarsimp, subgoal_tac "GETr (C(x\<mapsto>\<^sub>fTT)) y = GETr C y", clarsimp, erule GETr_Update1)

lemma GETrSome_DOM:"GETr G x = Some T \<Longrightarrow> x \<in> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma GETrNone_DOM:"GETr G x = None \<Longrightarrow> x \<notin> DOM G"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETrSome:"x \<in> DOM G \<Longrightarrow> (\<exists> T . GETr G x = Some T)"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETrNone:"x \<notin> DOM G \<Longrightarrow> GETr G x = None"
by (simp add: DOM_def fmap_dom_def dom_def GETr_def fmap_lookup_def)

lemma DOM_GETr_DOM: "\<lbrakk>x \<in> DOM D; x \<in> U; GETr C x = GETr D x\<rbrakk> \<Longrightarrow> x \<in> DOM C"
apply (subgoal_tac "\<exists> T. GETr D x = Some T", clarsimp)
apply (rule GETrSome_DOM, clarsimp, simp)
apply (erule DOM_GETrSome)
done

lemma UsedVarsDOM1:
"\<lbrakk>\<forall>x. x \<in> U \<longrightarrow> GETr D x = GETr C x; DOM C \<subseteq> DOM D; x \<in> U; x \<in> DOM D\<rbrakk> \<Longrightarrow> x:DOM C"
apply (erule_tac x=x in allE,clarsimp)
apply (subgoal_tac "\<exists> T . GETr D x = Some T",clarsimp)
apply (rule GETrSome_DOM) apply fast
apply (erule DOM_GETrSome)
done

(*>*)
text {*Region calculation*}
consts reg :: "(val \<times> heap \<times> (Type option) \<times> (locn set) \<times> nat) set"
inductive reg intros
regList:  "\<lbrakk>(n, r, R, h) : mLIST; m = k*n\<rbrakk> \<Longrightarrow> (RVal r, h, Some(ListET k), R, m): reg"
regInt:   "(IVal i ,h,Some IntET,{}, 0): reg"
regUnit:   "(v,h,Some UnitET,{}, 0): reg"

lemma Ref_reg: "(RVal (Ref a), h, Some (ListET k), Rx, Sx) \<in> reg \<Longrightarrow> a : Rx"
(*<*) by (erule reg.elims, simp_all, clarsimp, erule mLIST.elims, simp_all) (*>*)

lemma reg_DOM:"(RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, n) \<in> reg \<Longrightarrow> x:DOM G"
(*<*)
apply (subgoal_tac "\<exists> T . GETr G x = Some T", clarsimp) apply (erule GETrSome_DOM)
apply (case_tac "GETr G x", clarsimp) 
apply (erule reg.elims, clarsimp, clarsimp,clarsimp)
apply (rule_tac x=a in exI, assumption)
done
(*>*)

lemma reg_Preserved:"\<lbrakk>(v,h,T,R,S):reg; \<forall> l. l : R \<longrightarrow> sameOH {l} h h1\<rbrakk> \<Longrightarrow> (v,h1,T,R,S):reg"
(*<*)
apply (erule reg.elims, safe)
apply (rule regList)
  apply (subgoal_tac "(n, r, R, h1) \<in> mLIST", assumption) apply (erule mLIST_Preserved, fast)
  apply simp
apply (rule regInt)
apply (rule regUnit)
done
(*>*)

lemma reg_Unique[rule_format]: "(v, h, T, R, S) : reg \<Longrightarrow> (\<forall> RR SS . (v, h, T, RR, SS) : reg \<longrightarrow> (R=RR \<and> S=SS))"
(*<*)
apply (erule reg.induct)
apply clarsimp
apply (erule reg.elims, simp_all, clarsimp)
apply (subgoal_tac "n = na \<and> R = Ra", clarsimp)
apply (rule mLIST_Unique, assumption, assumption)
apply clarsimp
apply (erule reg.elims, simp_all)
apply clarsimp
apply (erule reg.elims, simp_all)
done
(*>*)

lemma reg_region_in_heap:"(v,h,T,R,S): reg \<Longrightarrow> R \<subseteq> Dom h"
(*<*)
apply (erule reg.elims) apply(rule mLIST_region_in_heap) apply (clarsimp,assumption)
apply clarify+
done
(*>*)

lemma reg_region_in_heap1:"\<lbrakk>(v,h,T,R,S): reg; a:R\<rbrakk> \<Longrightarrow> a: Dom h"
(*<*)
by (insert reg_region_in_heap, fastsimp)
(*>*)

lemma reg_F1: "\<lbrakk>(RVal (Ref a),h, Some(ListET k),R,n):reg\<rbrakk> \<Longrightarrow> (RVal (h\<lfloor>a\<diamondsuit>F1\<rfloor>),h,Some(ListET k), R-{a},n-k):reg"
(*<*)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule mLIST.elims, simp_all, clarsimp)
apply (erule regList, simp)
done
(*>*)

text{*Size of contexts, i.e. the region inhabited, and the number
      of freelist-cells owned by a context.*}
consts CS::"(env \<times> heap \<times> (rname set) \<times> Context \<times> (locn set) \<times> nat) set"
inductive CS intros
CS_NIL: "\<lbrakk>U={}; S=0 \<rbrakk> \<Longrightarrow> (E,h,U,C,{},S) : CS"
CS_CONS: "\<lbrakk>x: U;  (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R1,n): reg;
           (E,h,U-{x},C,R2,m):CS; R1 \<inter> R2 = {}; R = R1 \<union> R2;S = n+m\<rbrakk>
        \<Longrightarrow> (E,h,U,C,R,S) : CS"

lemma CS_containsRegion1[rule_format]:
 "(E, h, U, C, R, m) \<in> CS \<Longrightarrow> (\<forall> x . x \<in> U \<longrightarrow> (\<forall> R1 n . (RVal (renv E x), h, GETr C x, R1, n) \<in> reg \<longrightarrow> R1 \<subseteq> R))" 
(*<*)
apply (erule CS.induct)
apply clarsimp
apply clarsimp
apply (erule_tac x=xa in allE)
apply (case_tac "xa=x", clarsimp)
apply (subgoal_tac "R1=R1a \<and> n=na", fast)
apply (erule reg_Unique, assumption)
apply clarsimp
apply (erule_tac x=R1a in allE)
apply (erule impE, fast)
apply fast
done
(*>*)

lemma CS_containsRegion2[rule_format]:
 "(E, h, U, C, R, m) \<in> CS \<Longrightarrow> (\<forall> x . x \<in> U \<longrightarrow> (\<forall> R1 n . (RVal (renv E x), h, GETr C x, R1, n) \<in> reg \<longrightarrow> n \<le> m))" 
(*<*)
apply (erule CS.induct)
apply clarsimp
apply clarsimp
apply (erule_tac x=xa in allE)
apply (case_tac "xa=x", clarsimp)
apply (subgoal_tac "R1=R1a \<and> n=na", fastsimp)
apply (erule reg_Unique, assumption)
apply clarsimp
apply (erule_tac x=R1a in allE)
apply fastsimp 
done
(*>*)

lemma CS_containsRegion[rule_format]:
 "(E, h, U, C, R, m) \<in> CS \<Longrightarrow> (\<forall> x . x \<in> U \<longrightarrow> (\<forall> R1 n . (RVal (renv E x), h, GETr C x, R1, n) \<in> reg \<longrightarrow> R1 \<subseteq> R \<and> n \<le> m))" 
(*<*)
by (insert CS_containsRegion1 CS_containsRegion2, fast)
(*>*)

lemma CS_SPLIT[rule_format]: 
"(E, h, U, C, R, S) \<in> CS \<Longrightarrow> (\<forall> U1 U2 . U1 \<union> U2 = U \<longrightarrow> U1 \<inter> U2 = {} \<longrightarrow>
 (\<exists> R1 n1 R2 n2 . (E, h, U1, C, R1, n1) \<in> CS \<and> (E, h, U2, C, R2, n2) \<in> CS \<and> R1 \<inter> R2 = {} \<and> R = R1 \<union> R2 \<and> n1 + n2 = S))"
(*<*)
apply (erule CS.induct, simp_all)
apply (rule_tac x="{}" in exI, rule_tac x=0 in exI)
apply (rule, rule CS_NIL, simp, simp)
apply (rule_tac x="{}" in exI)
apply (rule, rule CS_NIL, simp, simp) apply simp 
(*Case CONS*)
apply clarsimp apply (erule disjE)
(* x:U1*)
  apply (erule_tac x="U1-{x}" in allE, erule_tac x=U2 in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x="R1 \<union> R1a" in exI, rule_tac x="n+n1" in exI, clarsimp)
  apply (rule, erule CS_CONS, assumption+, fast, simp, simp)
  apply (rule_tac x="R2a" in exI, fastsimp) 
(* x:U2*)
  apply (erule_tac x=U1 in allE, erule_tac x="U2-{x}" in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x="R1a" in exI, rule_tac x="n1" in exI, clarsimp)
  apply (rule_tac x="R1 \<union> R2a" in exI) 
  apply (rule, erule CS_CONS, assumption+, fast, simp, simp)
  apply fast
done
(*>*)

lemma CS_split[rule_format]:
"(E, h, U, G, R, S) \<in> CS \<Longrightarrow> (\<forall> x RR SS . x:U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, RR, SS) \<in> reg \<longrightarrow>
  (\<exists> R1 n . (E,h,U-{x},G,R1,n):CS \<and> R1 \<inter> RR = {} \<and> R = R1 \<union> RR \<and> S = SS + n))" 
(*<*)
apply (erule CS.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply (subgoal_tac "R1=RR \<and> n=SS",clarsimp)
apply (rule_tac x=R2 in exI, fastsimp) 
apply (erule reg_Unique, assumption)
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule_tac x=RR in allE, erule_tac x=SS in allE, clarsimp)
apply (rule_tac x="R1 \<union> R1a" in exI)
apply (rule, rule CS_CONS) apply fast apply simp 
apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp) apply assumption
apply fastsimp+
done
(*>*)

lemma CS_Unique: "(E,h,U,C,R,S):CS  \<Longrightarrow> (\<forall> RR n . (E,h,U,C,RR,n):CS \<longrightarrow> R=RR \<and> S = n)"
(*<*)
apply (erule CS.induct)
(*1*)
apply clarsimp apply (erule CS.elims, clarsimp) apply clarsimp 
(*2*)
apply (rule, rule, rule)  
apply (rotate_tac -1, erule CS.elims)
(*2a*) apply(fast)
(*2b*) apply clarify
  apply (case_tac "x=xa", clarify)
  apply (erule_tac x=R2a in allE, erule_tac x=ma in allE,  clarsimp)
  apply (subgoal_tac "R1 = R1a \<and> n=nb", fast)
  apply (erule reg_Unique, assumption)
  (*x \<noteq> xa*)
  apply (subgoal_tac "\<exists> RR N .(Ea,ha,Ua-{xa}-{x},Ca,RR,N):CS \<and> RR \<inter> R1 = {} \<and> R2a = RR \<union> R1 \<and> ma = n + N",clarify)
  prefer 2 apply (erule CS_split) apply fast apply assumption
  apply (subgoal_tac "\<exists> RR N .(Ea,ha,Ua-{x}-{xa},Ca,RR,N):CS \<and> RR \<inter> R1a = {} \<and> R2 = RR \<union> R1a \<and> m = nb + N",clarify)
  prefer 2 apply (erule CS_split) apply fast apply assumption
  apply (erule_tac x="RRa \<union> R1a" in allE, erule_tac x="nb + N" in allE, clarsimp)
  apply (erule impE)
  prefer 2 apply clarsimp apply fast
  apply (rule CS_CONS) apply fast 
  apply assumption 
  prefer 4 apply simp
  apply (subgoal_tac "Ua - {xa} - {x} = Ua - {x} - {xa}", clarsimp,fast)
  apply fast
  apply fast
  apply fast
done
(*>*)

lemma CS_regionsExist[rule_format]:
"(E,h,U,C,R,S):CS \<Longrightarrow> (\<forall> x . x:(U \<inter> DOM C)\<longrightarrow> (\<exists> RR n . (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, RR, n) \<in> reg))"
(*<*)
apply (erule CS.induct)
apply clarsimp 
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply fast
apply (erule_tac x=xa in allE, clarsimp)
done
(*>*)

lemma CS_reg[rule_format]:
"(E, h, U, C, R, m) \<in> CS \<Longrightarrow> 
  (\<forall> l . l : R \<longrightarrow> (\<exists> z . z \<in> U \<and> z \<in> DOM C \<and> (\<exists> Rz Sz. (RVal (renv E z), h, GETr C z, Rz, Sz) \<in> reg \<and> l:Rz)))"
(*<*)
apply (erule CS.induct)
apply clarsimp
apply safe
apply (rule_tac x=x in exI, safe) apply (erule reg_DOM) apply fastsimp
apply fastsimp
done
(*>*)

lemma CS_SameOnU[rule_format]:
"(E,h,U,C,R,S) : CS \<Longrightarrow> ((\<forall>x. x \<in> U \<longrightarrow> GETr C x = GETr D x) \<longrightarrow> (E,h,U,D,R,S) : CS)"
(*<*)
apply (erule CS.induct, clarsimp)
apply (rule CS_NIL, clarsimp+)
apply (erule CS_CONS, simp+)
done
(*>*)

lemma CS_monotone[rule_format]:
"(E, h, U, C, R, n) \<in> CS \<Longrightarrow>
       (\<forall> V S m . (E, h, V, C, S, m) \<in> CS \<longrightarrow> U \<subseteq> V \<longrightarrow>  R \<subseteq> S \<and> n \<le> m)"
(*<*)
apply (erule CS.induct)
apply clarsimp 
apply clarsimp
apply (rotate_tac -2)
apply (drule CS_split) apply fast apply assumption apply clarsimp
apply (erule_tac x="V-{x}" in allE, erule_tac x="R1a" in allE, erule_tac x="na" in allE,
       clarsimp, fast)
done
(*>*)

lemma CS_PreservedU[rule_format]:
"(E,h,U,C,R,S):CS \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) \<longrightarrow> 
                       (\<forall> D . (\<forall> x . x : U \<longrightarrow> (\<forall> T . GETr C x = Some T \<longrightarrow> GETr D x = Some T)) \<longrightarrow>
                              (EE,h,U,D,R,S):CS))"
(*<*)
apply (erule CS.induct)
(*NIL*)
apply clarsimp
apply (rule CS_NIL) apply (simp, simp)
(*CONS*)
apply clarsimp
apply (frule reg_DOM) 
apply (erule_tac x=x in allE,clarsimp)
apply (frule DOM_GETrSome, clarsimp)
apply (subgoal_tac "GETr D x = Some T") prefer 2 apply (erule_tac x=x in allE, clarsimp) 
apply (erule CS_CONS) 
apply (simp) 
apply (erule_tac x=D in allE, erule impE) apply (clarsimp, assumption)
apply simp+
done
(*>*)

lemma CS_UnusedU_Extension[rule_format]:
"(E, h, U, C, R, n) \<in> CS \<Longrightarrow> (\<forall> x . x \<notin> U \<longrightarrow> (E, h, U, C(x\<mapsto>\<^sub>fT), R, n) \<in> CS)"
(*<*)
apply clarsimp
apply (erule CS_PreservedU)
apply simp
apply (erule GETr_Update2)
apply fast
done
(*>*)

lemma CS_LessList[rule_format]:
"(E, h, U, C, R, n) \<in> CS \<Longrightarrow> (\<forall> x. x : U \<longrightarrow> E\<lfloor>x\<rfloor> = Ref a \<longrightarrow> GETr C x = Some (ListET k) \<longrightarrow> k \<le> n)"
(*<*)
apply (erule CS.induct)
apply clarsimp
apply clarsimp
apply (case_tac "xa=x", clarsimp)
apply (erule reg.elims, simp_all, clarsimp)
apply (erule mLIST.elims, simp_all)
apply fastsimp
done
(*>*)

subsubsection {*The heap assertion*}
constdefs freelist::"heap \<Rightarrow> locn set \<Rightarrow> nat \<Rightarrow> bool"
"freelist h F N == (N, h\<lbrace>DIAM\<struct>DOLLAR_F\<rbrace>, F, h) : FL"

constdefs mod2::"locn set \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> bool"
"mod2 R h hh == \<forall> l . (l: Dom h - R \<longrightarrow> sameOH {l} h hh)"
lemma mod2_Sameheap[simp]: "mod2 R h h" (*<*) by (simp add: mod2_def sameOH_def)(*>*)
lemma mod2_monotone: "\<lbrakk>mod2 X h hh; X \<subseteq> Y\<rbrakk>  \<Longrightarrow> mod2 Y h hh" (*<*)by (simp add: mod2_def, fast)(*>*)

(*constdefs DAss::"(rname set) \<Rightarrow> nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<ggreater>  _ , _ \<rbrace>" 1000)
"DAss U n G T m E h hh v p \<equiv>
  (\<forall> q F R. 
    (\<exists> N P. freelist h F N \<and> (E,h,U,G,R,P):CS \<and> R \<inter> F = {} \<and> n + P + q \<le> N) \<longrightarrow>
    (\<exists> Rv S M FF. (freelist hh FF M) \<and> 
                 (v,hh,Some T,Rv,S) : reg \<and>
                 (mod2 (F \<union> R) h hh) \<and>
                 (Rv \<inter> FF = {}) \<and>  
                 (Rv \<union> FF) \<subseteq> (R \<union> F) \<and>
                 (m + S + q \<le> M) \<and> 
                 oheap h = oheap hh))"
*)

constdefs preDAss::"nat \<Rightarrow> (locn set) \<Rightarrow> (locn set) \<Rightarrow> env \<Rightarrow> Context \<Rightarrow> (rname set) \<Rightarrow> heap \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> bool"
"preDAss q F R E G U h n N P == (freelist h F N \<and> (E,h,U,G,R,P):CS \<and> R \<inter> F = {} \<and> n + P + q \<le> N)"
constdefs postDAss::"nat \<Rightarrow> (locn set) \<Rightarrow> (locn set) \<Rightarrow> Type \<Rightarrow> heap \<Rightarrow> heap \<Rightarrow> nat \<Rightarrow> val \<Rightarrow> locn set \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> locn set \<Rightarrow> bool"
"postDAss q F R T h hh m v Rv S M FF == (freelist hh FF M) \<and> 
                                            (v,hh,Some T,Rv,S) : reg \<and>
                                            (mod2 (F \<union> R) h hh) \<and>
                                            (Rv \<inter> FF = {}) \<and>  
                                            (Rv \<union> FF) \<subseteq> (R \<union> F) \<and>
                                            (m + S + q \<le> M) \<and> 
                                            oheap h = oheap hh"

constdefs DASS:: "(rname set) \<Rightarrow> nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<ggreater>  _ , _ \<rbrace>" 1000)
"DASS U n G T m E h hh v p \<equiv>
  (\<forall> q F R. ((\<exists> N . \<exists> P. preDAss q F R E G U h n N P) \<longrightarrow> (\<exists> Rv . \<exists> S . \<exists> M . \<exists> FF. postDAss q F R T h hh m v Rv S M FF)))"
(*
lemma "DAss = DASS"
apply (rule, rule, rule, rule, rule)
apply (rule, rule, rule, rule, rule)
apply (simp add: DAss_def DASS_def preDAss_def postDAss_def)
done
*)

lemma CS_Preserved_h_h1[rule_format]:
"(E, h, U, C, R, n) \<in> CS \<Longrightarrow> (\<forall> RR. mod2 RR h hh \<longrightarrow> RR \<inter> R = {} \<longrightarrow> (E, hh, U, C, R, n) \<in> CS)"
(*<*)
apply (erule CS.induct)
apply clarsimp apply (rule CS_NIL, simp, simp)
apply clarsimp
apply (erule CS_CONS)
apply (rule reg_Preserved, assumption) defer 1 
apply (erule_tac x= RR in allE)
apply (erule impE, fast)
apply (erule impE, fast)
apply assumption+
apply simp+
apply (simp add: mod2_def, clarsimp)
apply (rotate_tac 2, erule thin_rl)
apply (erule_tac x=l in allE, erule impE, safe)
apply (erule reg_region_in_heap1, assumption)
apply fast
done
(*>*)

(*<*)
end
(*>*)

(*
lemma regionsExist_Lookup: "\<lbrakk>regionsExist U G h E; x:U; GETr G x = Some T\<rbrakk> \<Longrightarrow> (\<exists> R S . (RVal (E\<lfloor>x\<rfloor>),h,Some T,R,S):reg)"
by (simp add: regionsExist_def, erule_tac x=x in allE, insert GETrSome_DOM, auto)

lemma regionsExist_antimonotone:"\<lbrakk>regionsExist XX G h E; X \<subseteq> XX\<rbrakk> \<Longrightarrow> regionsExist X G h E"
by (simp add: regionsExist_def, fast)

lemma regionsDistinct_antimonotone:"\<lbrakk>regionsDistinct XX G h E; X \<subseteq> XX\<rbrakk> \<Longrightarrow> regionsDistinct X G h E"
by (simp add: regionsDistinct_def, fast)

lemma L1[rule_format]:
     "(E, h, V, C, Ra, m) \<in> CS \<Longrightarrow> 
       (\<forall> x U R n . V = U - {x} \<longrightarrow> x \<in> U \<longrightarrow> (RVal (renv E x), h, GETr C x, R, n) \<in> reg \<longrightarrow> 
                    regionsExist U C h E \<longrightarrow> regionsDistinct U C h E \<longrightarrow> R \<inter> Ra = {})"
apply (erule CS.induct)
apply simp
apply clarsimp
apply (erule_tac x=xa in allE)
apply (erule_tac x="Ua-{x}" in allE)
apply (erule impE, fast)
apply (erule impE, fast)
apply (erule_tac x=Ra in allE, erule impE,fastsimp)
apply (erule impE)
apply (erule regionsExist_antimonotone,fast)
apply (erule impE)
apply (erule regionsDistinct_antimonotone,fast)
apply (subgoal_tac "Ra \<inter> R1 = {}", fast)
apply (subgoal_tac "x : DOM C")
apply (subgoal_tac "xa : DOM C")
apply (simp add: regionsDistinct_def)
apply (erule_tac x=x in allE, erule_tac x=xa in allE) apply fastsimp
apply (erule reg_DOM)+
done

lemma L2[rule_format]:
"(E,h,U,G,S):ContextSize \<Longrightarrow> (regionsExist U G h E \<longrightarrow> regionsDistinct U G h E \<longrightarrow> (\<exists> R . (E,h,U,G,R,S):CS))"
apply (erule ContextSize.induct)
apply clarsimp
apply (rule_tac x="{}" in exI)
apply (rule CS_NIL, simp, simp)
apply clarsimp
apply (erule impE)
apply (erule regionsExist_antimonotone,fast)
apply (erule impE)
apply (erule regionsDistinct_antimonotone,fast)
apply clarsimp
apply (rule_tac x="R \<union> Ra" in exI)
apply (rule CS_CONS, assumption)
apply simp
apply simp
apply (erule L1) apply simp+
done
lemma L4[rule_format]:
  "(E,h,U,G,R,S):CS \<Longrightarrow> ((E,h,U,G,S):ContextSize \<and> regionsExist U G h E \<and> regionsDistinct U G h E)"
apply (erule CS.induct)
apply clarsimp
apply rule
apply (rule ContextSizeNIL, simp, simp)
apply (simp add: regionsExist_def regionsDistinct_def)
apply clarsimp
apply rule
apply (erule ContextSizeCONS) apply simp apply simp apply simp
apply rule
apply (simp add: regionsExist_def, clarsimp)
apply (case_tac "xa=x", fastsimp)
apply clarsimp
apply (simp add: regionsDistinct_def, clarsimp)
apply (case_tac "xa=x", clarsimp)
(%xa=x%)
  apply (rotate_tac 6, erule thin_rl)
  apply (subgoal_tac "R1 = Rx \<and> n=Sx", clarsimp)
  prefer 2 apply (erule reg_Unique, assumption)
  apply (subgoal_tac "Rxx \<subseteq> R2", fast)
  apply (erule L3) apply fastsimp apply simp
(%xa \<noteq> x%)
  apply (case_tac "xx=x", clarsimp)
  (%xx=x%)
    apply (rotate_tac 6, erule thin_rl)
    apply (subgoal_tac "R1 = Rxx \<and> n=Sxx", clarsimp)
    prefer 2 apply (erule reg_Unique, assumption)
    apply (subgoal_tac "Rx \<subseteq> R2", fast)
    apply (erule L3) apply fastsimp apply simp
  (%xx \<noteq> x%)
    apply (erule_tac x=xa in allE, erule_tac x=xx in allE, fastsimp)
done

consts ContextSize::"(env \<times> heap \<times> (rname set) \<times> Context \<times> nat) set"
inductive ContextSize intros
ContextSizeNIL: "\<lbrakk>U={}; S=0 \<rbrakk> \<Longrightarrow> (E,h,U,C, S) : ContextSize"
ContextSizeCONS: "\<lbrakk>x: U;  (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R,n): reg;
                   (E,h,U-{x},C,m):ContextSize; S = n+m\<rbrakk>
                  \<Longrightarrow> (E,h,U,C,S) : ContextSize"

lemma ContextSize_regionsExist[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> (\<forall> x . x:(U \<inter> DOM C)\<longrightarrow> (\<exists> R S . (RVal (E\<lfloor>x\<rfloor>), h, GETr C x, R, S) \<in> reg))"
apply (erule ContextSize.induct)
apply clarsimp 
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply fast
apply (erule_tac x=xa in allE, clarsimp)
done

lemma ContextSize_contains_region[rule_format]:
"(E, h, U, G, n) \<in> ContextSize \<Longrightarrow> (\<forall> x R S . x:U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, S) \<in> reg \<longrightarrow> S \<le> n)" 
apply (erule ContextSize.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply (subgoal_tac "R=Ra \<and> n=Sa",clarsimp) 
apply (erule reg_Unique, assumption)
apply ( erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule_tac x=Ra in allE, erule_tac x=Sa in allE, clarsimp)
done

lemma ContextSize_delete_nonUsed[rule_format]:
 "(E, h, U, G, n) \<in> ContextSize \<Longrightarrow> (\<forall> x. x \<notin> DOM G \<longrightarrow> (E,h,U-{x},G,n):ContextSize)"
apply (erule ContextSize.induct)
apply clarsimp apply (rule ContextSizeNIL,simp+)
apply clarsimp apply (erule_tac x=xa in allE,clarsimp)
  apply (subgoal_tac "x:DOM C") prefer 2 apply (erule reg_DOM)
  apply (case_tac "x=xa",clarsimp) apply (rule ContextSizeCONS) prefer 2 apply assumption apply fast
  apply (subgoal_tac "U - {xa} - {x} = U - {x} - {xa}", clarsimp, assumption) apply fast apply simp
done

lemma ContextSize_delete_Used[rule_format]:
 "(E, h, U, G, n) \<in> ContextSize \<Longrightarrow> 
  (\<forall> x . x:U \<longrightarrow> (\<forall> R S .(RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, S) \<in> reg \<longrightarrow>(E,h,U-{x},G,n-S):ContextSize))"
apply (erule ContextSize.induct)
apply clarsimp
apply clarsimp 
  apply (case_tac "xa=x",clarsimp) apply (subgoal_tac "R=Ra \<and> n=Sa",clarsimp) apply (erule reg_Unique, assumption)
  apply (erule_tac x=xa in allE,clarsimp)
  apply (erule_tac x=Ra in allE, erule_tac x=Sa in allE, clarsimp) 
  apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp) apply (rule ContextSizeCONS) prefer 3 apply assumption
    apply (fast, assumption) apply (subgoal_tac "Sa \<le> m",clarsimp) 
    apply (erule ContextSize_contains_region) prefer 2 apply (assumption, fast)
  apply fast
done

lemma ContextSize_split[rule_format]:
"(E, h, U, G, n) \<in> ContextSize \<Longrightarrow> (\<forall> x R S . x:U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, R, S) \<in> reg \<longrightarrow>
  (\<exists> m . (E,h,U-{x},G,m):ContextSize \<and> n = S + m))" 
apply (erule ContextSize.induct)
apply clarsimp
apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply (subgoal_tac "R=Ra \<and> n=Sa",clarsimp) 
apply (erule reg_Unique, assumption)
apply (erule_tac x=xa in allE, erule impE, clarsimp)
apply (erule_tac x=Ra in allE, erule_tac x=Sa in allE, clarsimp)
apply (rule ContextSizeCONS)
apply (subgoal_tac "x: U -{xa}", assumption,fast)
apply assumption
prefer 2 apply simp
apply (subgoal_tac "U - {x} - {xa} = U - {xa} - {x}", clarsimp)
apply fast
done

lemma ContextSize_Unique[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> (\<forall> n . (E,h,U,C,n):ContextSize \<longrightarrow> S = n)"
apply (erule ContextSize.induct)
(%1%)
apply clarsimp apply (erule ContextSize.elims, clarsimp,clarsimp)
(%2%)
apply (rule, rule) 
apply (rotate_tac -1, erule ContextSize.elims)
(%2a%) apply(fast)
(%2b%) apply clarify
  apply (case_tac "x=xa", clarify)
  apply (erule_tac x=ma in allE, clarsimp)
  apply (simp add: reg_Unique)
  (%x \<noteq> xa%)
  apply (subgoal_tac "\<exists> N .(Ea,ha,Ua-{xa}-{x},Ca,N):ContextSize \<and> ma = n + N",clarify)
  prefer 2 apply (erule ContextSize_split) apply fast apply assumption
  apply (subgoal_tac "\<exists> N .(Ea,ha,Ua-{x}-{xa},Ca,N):ContextSize \<and> m = nb + N",clarify)
  prefer 2 apply (erule ContextSize_split) apply fast apply assumption
  apply (erule_tac x="nb+N" in allE, erule impE)
  prefer 2 apply clarsimp
  apply (rule ContextSizeCONS) apply (subgoal_tac "xa : Ua - {x}", assumption,fast)
  apply assumption 
  prefer 2 apply simp
  apply (subgoal_tac "Ua - {xa} - {x} = Ua - {x} - {xa}", clarsimp,fast)
done

lemma SizePreserved_h_h1[rule_format]:
"(E, h, U, C, n) \<in> ContextSize \<Longrightarrow> 
   (\<forall> h1 . (\<forall> x R S . x : U \<longrightarrow> (RVal (E\<lfloor>x\<rfloor>),h, GETr C x, R, S) : reg \<longrightarrow> (\<forall> l . l : R \<longrightarrow> sameOH {l} h h1))
          \<longrightarrow> (E, h1, U, C, n) \<in> ContextSize)"
apply (erule ContextSize.induct)
apply clarsimp apply (rule ContextSizeNIL, simp, simp)
apply clarsimp
apply (rule ContextSizeCONS) 
apply (assumption)
apply (rule reg_Preserved, assumption) apply (erule_tac x=x in allE,clarsimp) 
  apply (erule_tac x=R in allE,erule impE,fast)
  apply fast
apply fast
apply simp
done

lemma ContextSize_SPLIT[rule_format]: 
"(E, h, U, C, n) \<in> ContextSize \<Longrightarrow> (\<forall> U1 U2 . U1 \<union> U2 = U \<longrightarrow> U1 \<inter> U2 = {} \<longrightarrow>
 (\<exists> n1 n2 . (E, h, U1, C, n1) \<in> ContextSize \<and> (E, h, U2, C, n2) \<in> ContextSize \<and> n1 + n2 = n))"
apply (erule ContextSize.induct, simp_all)
apply (rule ContextSizeNIL, simp,simp)
(%Case CONS%)
apply clarsimp apply (erule disjE)
(% x:U1%)
  apply (erule_tac x="U1-{x}" in allE, erule_tac x=U2 in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x="n+n1" in exI, clarsimp)
  apply (erule ContextSizeCONS,assumption+, simp)
(% x:U2%)
  apply (erule_tac x=U1 in allE, erule_tac x="U2-{x}" in allE, erule impE)
  apply fast
  apply (erule impE, fast)
  apply clarsimp
  apply (rule_tac x=n1 in exI, clarsimp)
  apply (erule ContextSizeCONS,assumption+, simp)
done

lemma ContextSizePreserved[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) \<longrightarrow> (EE,h,U,C,S):ContextSize)"
apply (erule ContextSize.induct)
(%NIL%)
apply clarsimp
apply (rule ContextSizeNIL) apply (simp, simp)
(%CONS%)
apply clarsimp
apply (subgoal_tac "x:DOM C")
prefer 2 apply (erule reg_DOM)
apply (erule ContextSizeCONS)
apply (assumption+,simp)
done

lemma ContextSizePreservedU[rule_format]:
"(E,h,U,C,S):ContextSize \<Longrightarrow> ((\<forall> x . x : U \<longrightarrow> E\<lfloor>x\<rfloor> = EE\<lfloor>x\<rfloor>) \<longrightarrow> 
                              (\<forall> D . (\<forall> x . x : U \<longrightarrow> (\<forall> T . GETr C x = Some T \<longrightarrow> GETr D x = Some T)) \<longrightarrow>
                                     (EE,h,U,D,S):ContextSize))"
apply (erule ContextSize.induct)
(%NIL%)
apply clarsimp
apply (rule ContextSizeNIL) apply (simp, simp)
(%CONS%)
apply clarsimp
apply (subgoal_tac "x:DOM C")
prefer 2 apply (erule reg_DOM) 
apply (erule_tac x=x in allE,clarsimp)
apply (subgoal_tac "GETr C x = GETr D x")
prefer 2 apply (subgoal_tac "\<exists> T . GETr C x = Some T") apply (erule_tac x=x in allE,clarsimp) 
         apply (erule DOM_GETrSome)
apply (erule ContextSizeCONS) 
apply (simp) 
apply (erule_tac x=D in allE) apply (clarsimp, assumption)
apply simp
done

constdefs regionsExist::"(rname set) \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"regionsExist U G h E == (\<forall> x. (x:(DOM G) \<inter> U) \<longrightarrow> (\<exists> Rx Sx . (RVal (E\<lfloor>x\<rfloor>),h,GETr G x,Rx,Sx): reg))"

constdefs regionsDistinct::"rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"regionsDistinct X G h E == 
  (\<forall> x xx Rx Rxx Sx Sxx. (x : (X \<inter> DOM G) \<and> xx : (X \<inter> DOM G) \<and> x \<noteq> xx \<and> (RVal (E\<lfloor>x\<rfloor>),h,GETr G x,Rx,Sx): reg \<and> 
                           (RVal (E\<lfloor>xx\<rfloor>),h,GETr G xx,Rxx,Sxx): reg) \<longrightarrow>
                          Rx \<inter> Rxx = {})"

constdefs distinctFrom::"rname set \<Rightarrow> Context => heap \<Rightarrow> env \<Rightarrow> locn set \<Rightarrow> bool"
"distinctFrom X G h E F == (\<forall> x . x:(X \<inter> DOM G) \<longrightarrow> (\<forall> Rx Sx. (RVal (E\<lfloor>x\<rfloor>), h, GETr G x,Rx,Sx):reg \<longrightarrow>  Rx \<inter> F = {}))"

constdefs modified::"locn set \<Rightarrow> rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> heap \<Rightarrow> bool"
"modified F Z G h E hh == (\<forall> l . (l \<notin> F \<and> l:Dom h \<and> (\<forall> z Rz Sz. (z : (Z \<inter> DOM G) \<and> (RVal (E\<lfloor>z\<rfloor>), h, GETr G z, Rz, Sz):reg) \<longrightarrow> l \<notin> Rz))
                             \<longrightarrow> sameOH {l} h hh)"

constdefs Bounded::"locn set \<Rightarrow> locn set \<Rightarrow> rname set \<Rightarrow> Context \<Rightarrow> heap \<Rightarrow> env \<Rightarrow> bool"
"Bounded L F U G h E == (\<forall> l. l:L \<longrightarrow> l:F \<or> (\<exists> x Rx Sx. x:(U \<inter> (DOM G)) \<and> (RVal (E\<lfloor>x\<rfloor>), h, GETr G x, Rx, Sx):reg \<and> l:Rx))"

constdefs DAss::"(rname set) \<Rightarrow> nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" ("\<lbrace> _ , _ , _ \<ggreater>  _ , _ \<rbrace>" 1000)
"DAss U n G T m E h hh v p \<equiv>
  (\<forall> q P F N. 
    (freelist h F N \<and> (regionsExist U G h E) \<and> (regionsDistinct U G h E) \<and> 
     (distinctFrom U G h E F) \<and> (E,h,U,G,P):ContextSize \<and> n + P + q \<le> N) \<longrightarrow>
    (\<exists> R S M FF. (freelist hh FF M) \<and> 
                 (v,hh,Some T,R,S) : reg \<and>
                 (modified F U G h E hh) \<and>
                 (R \<inter> FF = {}) \<and>  
                 (Bounded R F U G h E) \<and>
                 (Bounded FF F U G h E) \<and> 
                 (m + S + q \<le> M) \<and> 
                 oheap h = oheap hh))"

constdefs DDAss::"(rname set) \<Rightarrow> nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn" 
"DDAss U n G T m E h hh v p \<equiv>
  (\<forall> q R P F N. 
    (freelist h F N \<and> (E,h,U,G,R,P):CS \<and> R \<inter> F = {} \<and> n + P + q \<le> N) \<longrightarrow>
    (\<exists> R S M FF. (freelist hh FF M) \<and> 
                 (v,hh,Some T,R,S) : reg \<and>
                 (modified F U G h E hh) \<and>
                 (R \<inter> FF = {}) \<and>  
                 (Bounded (R \<union> FF) F U G h E) \<and>
                 (m + S + q \<le> M) \<and> 
                 oheap h = oheap hh))"

constdefs DDDAss::"(rname set) \<Rightarrow> nat \<Rightarrow> Context \<Rightarrow>  Type \<Rightarrow> nat \<Rightarrow> vdmassn"
"DDDAss U n G T m E h hh v p \<equiv>
  (\<forall> q F. 
    (\<exists> R N P. freelist h F N \<and> (E,h,U,G,R,P):CS \<and> R \<inter> F = {} \<and> n + P + q \<le> N) \<longrightarrow>
    (\<exists> R S M FF. (freelist hh FF M) \<and> 
                 (v,hh,Some T,R,S) : reg \<and>
                 (modified F U G h E hh) \<and>
                 (R \<inter> FF = {}) \<and>  
                 (Bounded (R \<union> FF) F U G h E) \<and>
                 (m + S + q \<le> M) \<and> 
                 oheap h = oheap hh))"

lemma "DDAss U n C T m E h hh v p = DDDAss U n C T m E h hh v p"
apply rule
apply (simp add: DDAss_def DDDAss_def)
apply fast
apply (simp add: DDAss_def DDDAss_def)
apply fast
done

lemma "D4Ass U n C T m E h hh v p = DDDAss U n C T m E h hh v p"
apply (simp add: D4Ass_def DDDAss_def)
apply safe
apply (erule_tac x=q in allE, erule_tac x=F in allE, erule_tac x=R in allE, erule impE, fastsimp, clarsimp)
apply (rule_tac x=Rv in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
apply (rule, simp add: modified_def mod2_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (frule CS_reg) apply assumption apply fastsimp
apply (simp add: Bounded_def, clarsimp,rule, rule)
apply (subgoal_tac "l : R \<or> l: F") prefer 2 apply fast
apply (erule disjE, rule disjI2)
apply (frule CS_reg, assumption) apply fastsimp 
apply simp
apply rule
apply (subgoal_tac "l : R \<or> l: F") prefer 2 apply fast
apply (erule disjE, rule disjI2)
apply (frule CS_reg, assumption) apply fastsimp 
apply simp

apply (erule_tac x=q in allE, erule_tac x=F in allE, erule impE, fastsimp, clarsimp)
apply (rule_tac x=Ra in exI, rule_tac x=S in exI, rule_tac x=M in exI, rule_tac x=FF in exI, clarsimp)
apply (rule, simp add: modified_def mod2_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (subgoal_tac "Rz \<subseteq> R", fastsimp)
apply (erule L3, assumption+)
apply (simp add: Bounded_def)
apply (erule_tac x=x in allE, clarsimp)
apply (subgoal_tac "Rx \<subseteq> R", fast)
apply (erule L3, assumption+)
apply (simp add: Bounded_def)
apply (erule_tac x=x in allE, clarsimp)
apply (subgoal_tac "Rx \<subseteq> R", fast)
apply (erule L3, assumption+)
done


lemma L5[rule_format]:
"(E, h, U, C, R, P) \<in> CS \<Longrightarrow> (\<forall> F. (distinctFrom U C h E F \<longrightarrow> R \<inter> F = {}))"
apply (erule CS.induct)
apply (simp add: distinctFrom_def)
apply clarsimp
apply (erule_tac x=F in allE)
apply (erule impE)
apply (simp add: distinctFrom_def) apply fastsimp
apply (subgoal_tac "R1 \<inter> F = {}", fast)
apply (simp add: distinctFrom_def)
apply (erule_tac x=x in allE, erule impE, clarsimp)
apply (erule reg_DOM)
apply fastsimp
done
lemma L6[rule_format]: "(E, h, U, C, R, P) \<in> CS \<Longrightarrow> (\<forall> F. R \<inter> F = {} \<longrightarrow> distinctFrom U C h E F)"
apply (erule CS.induct)
apply (simp add: distinctFrom_def)
apply clarsimp
apply (erule_tac x=F in allE, erule impE, fast)
apply (simp add: distinctFrom_def) apply clarsimp
apply (case_tac "x=xa", clarsimp)
apply (subgoal_tac "R1 = Rx \<and> n=Sx", clarsimp) apply fast
apply (erule reg_Unique, assumption)
apply (erule_tac x=xa in allE, fastsimp)
done

lemma "DDAss U n C T m E h hh v p = DAss U n C T m E h hh v p"
apply (simp add: DDAss_def DAss_def, safe)
apply (subgoal_tac "\<exists> R . (E,h,U,C,R,P):CS", clarsimp)
prefer 2 apply (erule L2, assumption, assumption)
apply (erule_tac x=q in allE, erule_tac x=R in allE, erule_tac x=P in allE, erule_tac x=F in allE, erule impE)
apply (rule_tac x=N in exI, clarsimp)
apply (erule L5, assumption)
apply clarsimp
apply (subgoal_tac "Bounded Ra F U C h E \<and> Bounded FF F U C h E", fastsimp)
apply (simp add: Bounded_def)
apply (erule_tac x=q in allE, erule_tac x=P in allE, erule_tac x=F in allE, erule impE)
apply (rule_tac x=N in exI, clarsimp)
apply (simp add: L4 L6)
apply clarsimp
apply (subgoal_tac "Bounded (Ra \<union> FF) F U C h E", fastsimp)
apply (simp add: Bounded_def)
done


lemma distinctFrom_antimonotone:"\<lbrakk>distinctFrom XX G h E R; X \<subseteq> XX\<rbrakk> \<Longrightarrow> distinctFrom X G h E R"
by (simp add: distinctFrom_def, fast)

lemma modified_monotone:"\<lbrakk>modified F Z G h E hh; Z \<subseteq> ZZ\<rbrakk> \<Longrightarrow> modified F ZZ G h E hh"
by (simp add: modified_def, fast)

lemma Bounded_monotone:
"\<lbrakk>Bounded L F U G h E; LL \<subseteq> L; F \<subseteq> FF; U \<subseteq> UU\<rbrakk> \<Longrightarrow> Bounded LL FF UU G h E"
by (simp add: Bounded_def, fast)

lemma ContextSize_monotone_in_U[rule_format]:
"(E, h, U, D, NN) \<in> ContextSize \<Longrightarrow>
       (\<forall> UU N . (E, h, UU, D, N) \<in> ContextSize \<longrightarrow> U \<subseteq> UU \<longrightarrow>  NN \<le> N)"
apply (erule ContextSize.induct)
apply clarsimp 
apply clarsimp
apply (subgoal_tac "\<exists> M . (E,h,UU-{x},C,M):ContextSize \<and> N = n + M")
prefer 2 apply (erule ContextSize_split) apply fast apply assumption
apply clarsimp
apply (erule_tac x="UU-{x}" in allE, erule_tac x=M in allE, erule impE,clarsimp)
apply fast
done

lemma ContextSize_existsAux[rule_format]: 
"\<forall> U . ((U,N) : cardR \<longrightarrow> (\<forall> E h C UU. UU \<subseteq> U \<longrightarrow> U \<subseteq> DOM C \<longrightarrow> 
                      regionsExist U C h E \<longrightarrow> (\<exists> S . (E,h,UU,C,S):ContextSize)))"
apply (induct N) 
apply clarsimp apply (rule_tac x=0 in exI, rule ContextSizeNIL) 
  apply (erule cardR.elims, simp,simp, simp)
apply clarsimp
apply (erule cardR.elims,clarsimp,clarsimp)
apply (erule_tac x=A in allE, clarsimp)
apply (erule_tac x= E in allE, erule_tac x=h in allE, erule_tac x=C in allE)
apply (case_tac "a:UU")
apply (erule_tac x="UU-{a}" in allE, erule impE)
apply fast
apply (erule impE, clarsimp)
apply (erule impE)
apply (erule regionsExist_antimonotone,fast)
apply clarsimp 
apply (simp add: regionsExist_def) apply (erule_tac x=a in allE, clarsimp)
apply (rule_tac x="Sx+S" in exI, rule ContextSizeCONS)
prefer 2 apply assumption+ apply simp
apply (erule_tac x="UU" in allE, erule impE)
apply fast
apply (erule impE,clarsimp)
apply (erule impE)
apply (erule regionsExist_antimonotone,fast)
apply clarsimp 
done

lemma ContextSize_exists[rule_format]: 
"\<lbrakk>UU \<subseteq> U; U \<subseteq> DOM C; regionsExist U C h E\<rbrakk> \<Longrightarrow> (\<exists> S . (E,h,UU,C,S):ContextSize)"
apply (subgoal_tac "\<exists> n . (U,n):cardR", clarsimp)
apply (erule ContextSize_existsAux,assumption+)
apply (simp add: finite_dom_fmap DOM_def finite_imp_cardR finite_subset)
done

lemma distinctFrom_Triv1: "distinctFrom {} G h E F" by (simp add: distinctFrom_def)

lemma distinctFrom_Triv2: "distinctFrom X G h E {}" by (simp add: distinctFrom_def)

lemma modified_Sameheap: "modified F Z G h E h" by (simp add: modified_def sameOH_def)

lemma Bounded_SameF: "Bounded F F U G h E" by (simp add: Bounded_def)

lemma Bounded_Empty: "Bounded {} F U G h E" by (simp add: Bounded_def)

lemma distinctFrom_Lookup:"\<lbrakk>distinctFrom U G h E F; (RVal (renv E x), h, GETr G x, R, S) \<in> reg; x:U;
                            xa \<in> R; xa \<in> F\<rbrakk> \<Longrightarrow> A"
apply (simp add: distinctFrom_def)
apply (erule_tac x=x in allE, erule impE)
apply (erule reg.elims, safe) apply (erule GETrSome_DOM)
apply auto
done

lemma Bounded_lookup:
"\<lbrakk>regionsExist U G h E; x:U; (RVal (renv E x), h, GETr G x, R, S) \<in> reg\<rbrakk> \<Longrightarrow> Bounded R F U G h E"
apply (simp add: Bounded_def)
apply (rule, rule)
apply (subgoal_tac "\<exists>x. x: U \<and> x \<in> DOM G \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv E x), h, GETr G x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",clarsimp)
apply (rule_tac x=x in exI, safe)
apply (erule reg_DOM)
apply fast
done

lemma regionsExist1:
"\<lbrakk>regionsExist U C h E; \<forall>x. x \<in> U \<inter> (DOM D) \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> regionsExist U D h EE"
by (simp add: regionsExist_def)

lemma regionsDistinct1:
"\<lbrakk>regionsDistinct X C h E; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> regionsDistinct X D h EE"
apply (simp add: regionsDistinct_def, clarsimp)
apply (erule_tac x=x in allE, rotate_tac -1, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, safe)
apply auto
done

lemma distinctFrom1:
"\<lbrakk>distinctFrom X C h E R; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> distinctFrom X D h EE R"
apply (simp add: distinctFrom_def)
done

lemma modified1:
"\<lbrakk>modified F Z C h E hh; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; DOM C = DOM D; renv E = renv EE\<rbrakk> \<Longrightarrow> modified F Z D h EE hh"
apply (simp add: modified_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (erule_tac x=z in allE, erule impE)
apply (subgoal_tac "z:DOM C", clarsimp, erule reg_DOM)
apply (erule_tac x=z in allE, erule_tac x=Rz in allE, auto)
done

lemma Bounded1:
"\<lbrakk>Bounded R F U D h EE; \<forall>x. x \<in> DOM D \<longrightarrow> GETr D x = GETr C x; renv E = renv EE\<rbrakk> \<Longrightarrow> Bounded R F U C h E"
apply (simp add: Bounded_def, rule, rule)
apply (erule_tac x=l in allE, erule impE, simp)
apply (erule disjE, simp)
apply (subgoal_tac "\<exists>x. x: U  \<and> x \<in> DOM C \<and> (\<exists>Rx. (\<exists>Sx. (RVal (renv EE x), h, GETr C x, Rx, Sx) \<in> reg) \<and> l \<in> Rx)",simp)
apply clarsimp
apply (erule_tac x=x in allE, clarsimp)
apply (rule_tac x=x in exI, safe)
apply (erule reg_DOM)
apply fast
done

lemma regionsExist2:
"\<lbrakk>regionsExist U C h E; \<forall>x. x \<in> U \<longrightarrow> GETr C x = GETr D x\<rbrakk> \<Longrightarrow> regionsExist U D h E"
apply (simp add: regionsExist_def, clarsimp)
apply (erule_tac x=x in allE)+
apply clarsimp
apply (subgoal_tac "x: DOM C", simp)
apply (erule DOM_GETr_DOM, assumption, assumption)
done

lemma regionsDistinct2:
"\<lbrakk>regionsDistinct U C h E; \<forall>x. x \<in> U \<longrightarrow> GETr C x = GETr D x\<rbrakk> \<Longrightarrow> regionsDistinct U D h E"
apply (simp add: regionsDistinct_def, clarsimp)
apply (erule_tac x=x in allE, erule_tac x=xx in allE, erule_tac x=Rx in allE, erule_tac x=Rxx in allE, erule impE, safe)
apply (erule_tac x=x in allE,clarsimp) apply (erule DOM_GETr_DOM, assumption, assumption)
apply (erule_tac x=xx in allE,clarsimp) apply (erule DOM_GETr_DOM, assumption, assumption)
apply (erule_tac x=x in allE,fastsimp) 
apply (erule_tac x=xx in allE,fastsimp) 
done

lemma distinctFrom2:
"\<lbrakk>distinctFrom U C h E R; \<forall>x. x \<in> U \<longrightarrow> GETr C x = GETr D x\<rbrakk> \<Longrightarrow> distinctFrom U D h E R"
apply (simp add: distinctFrom_def, clarsimp)
apply ((erule_tac x=x in allE)+, clarsimp)
apply (erule impE)
apply (erule DOM_GETr_DOM, assumption, assumption)
apply fast
done

lemma modified2:
"\<lbrakk>modified F U C h E hh; \<forall>x. x \<in> U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> modified F U D h E hh"
apply (simp add: modified_def, clarsimp)
apply (erule_tac x=l in allE, erule impE, safe)
apply (erule_tac x=z in allE, clarsimp)
apply (erule_tac x=z in allE, erule_tac x=Rz in allE, erule impE, safe)
apply (erule DOM_GETr_DOM, assumption+)
apply fastsimp
done

lemma Bounded2:
"\<lbrakk>Bounded R F U D h E; \<forall>x. x \<in> U \<longrightarrow> GETr D x = GETr C x\<rbrakk> \<Longrightarrow> Bounded R F U C h E"
apply (simp add: Bounded_def, rule, rule)
apply (erule_tac x=l in allE, erule impE, simp)
apply (erule disjE, simp)
apply (rule disjI2)
apply clarsimp
apply (erule_tac x=x in allE, clarsimp)
apply (rule_tac x=x in exI, safe)
apply (erule reg_DOM)
apply fast
done

lemma ContextSize2[rule_format]:
"(E,h,U,D,S) : ContextSize \<Longrightarrow> ((\<forall>x. x \<in> U \<longrightarrow> GETr D x = GETr C x) \<longrightarrow> (E,h,U,C,S) : ContextSize)"
apply (erule ContextSize.induct, clarsimp)
apply (rule ContextSizeNIL, clarsimp+)
apply (erule ContextSizeCONS, simp+)
done
*)

