theory Counting = VDMderived + TREELIST:

(*Instruction Counters*)

consts New_InvV_InvS_effect::"expr \<Rightarrow> rescomp"
primrec
"New_InvV_InvS_effect (New c iflds rflds) = \<langle>(int(1 + (length iflds) + (length rflds))) 0 0 0\<rangle>"
"New_InvV_InvS_effect (A\<diamondsuit>m(y)) = \<langle>(int(5 + (length y))) 0 0 0\<rangle>"
"New_InvV_InvS_effect (C\<bullet>m(y)) = \<langle>(int(3 + (length y))) 0 0 0\<rangle>"

constdefs Rescomp ::"rescomp EFF"
"Rescomp == \<lparr>
  Int_effect = (\<lambda> eEh . tickRo),
  IVar_effect = (\<lambda> eEh . tickRo),
  Primop_effect = (\<lambda> eEh . \<langle>3 0 0 0\<rangle>),
  Null_effect = (\<lambda> eEh . tickRo),
  RVar_effect = (\<lambda> eEh . tickRo),
  RPrimop_effect = (\<lambda> eEh . \<langle>3 0 0 0\<rangle>),
  New_effect = (\<lambda> eEh . (New_InvV_InvS_effect (fst eEh))),
  GetFi_effect = (\<lambda> eEh . \<langle>2 0 0 0\<rangle>),
  GetFr_effect = (\<lambda> eEh . \<langle>2 0 0 0\<rangle>),
  PutFi_effect = (\<lambda> eEh . \<langle>3 0 0 0\<rangle>),
  PutFr_effect = (\<lambda> eEh . \<langle>3 0 0 0\<rangle>),
  GetStat_effect = (\<lambda> eEh . \<langle>2 0 0 0\<rangle>),
  PutStat_effect = (\<lambda> eEh . \<langle>3 0 0 0\<rangle>),

  InvV_effect = (\<lambda> eEh p. ((New_InvV_InvS_effect (fst eEh)) \<oplus> p)),
  InvS_effect = (\<lambda> eEh p. ((New_InvV_InvS_effect (fst eEh)) \<oplus> p)),
     
  Leti_effect = (\<lambda> eEh p1 p2 . (tk (p1 \<smile> p2))),
  Letr_effect = (\<lambda> eEh p1 p2 . (tk (p1 \<smile> p2))),
  Letv_effect = (\<lambda> eEh p1 p2 . (p1 \<smile> p2)),
  If_effect = (\<lambda> eEh p. (tkn 2 p)),
  Call_effect = (\<lambda> eEh p . (tkcall p))\<rparr>"


consts
  q_       :: iname   
  tag_     :: iname
  b_       :: iname    
  h_       :: iname  

  t_       :: rname  
  l_       :: rname
  acc_     :: rname 

  f_       :: funame  
  g_       :: funame   
  
  Revv     :: cname

  revMeth     :: mname
  revFun     :: mname

  callcA :: nat 
  callcB :: nat 
  clockA :: nat 
  clockB :: nat 
  invkcA :: nat 
  invkcB :: nat 
  invkdpthA :: nat 
  invkdpthB :: nat 

translations
 "q_" == "(In ''q'') "
 "b_" == "(In ''b'') "
 "h_" == "(In ''h'') "
 "tag_" == "(In ''tag'') "

 "acc_" == "(RN ''ll'') "

 "t_" == "(RN ''t'') "

 "h_" == "(RN ''h'') "

 "f_" == "(FN ''f'') "
 "g_" == "(FN ''g'') "

 "revMeth" == "(MN ''RevMeth'') "
 "revFun" == "(MN ''RevFun'') "

syntax TAG :: "ifldname"
translations
"TAG" => "DOLLAR"

syntax NIL_TAG :: "int"
translations
"NIL_TAG" => "2"

syntax CONS_TAG :: "int"
translations
"CONS_TAG" => "1"

syntax HD :: "ifldname"
translations
"HD" => "IFN ''HD''"

syntax TL :: "rfldname"
translations
"TL" => "RFN ''TL''"

(*List reverse with tail recursion using static method*)
axioms  methRevV[simp]:
 "methtable Revv revMeth = ([RNpar l_, RNpar acc_], CALL f_)"
   
axioms  funtf[simp]:
 "funtable f_ == ([RNpar l_, RNpar acc_],
                  LET tag_ = GetFi l_ TAG ;
                        b_ = Primop (% x y. if x = NIL_TAG then 1 else 0) tag_ tag_
                  IN IF b_ 
                      THEN RVar acc_ 
                      ELSE LET   h_ = GetFi l_ HD;
                              rf t_ = GetFr l_ TL;
                               tag_ = expr.Int CONS_TAG;
                                  _ = PutFi l_ TAG tag_; 
                                  _ = PutFi l_ HD h_;
                                  _ = PutFr l_ TL acc_
                           IN 
                            Revv\<bullet>revMeth([RNarg t_, RNarg l_])
                           END
                  END)"

(*List reverse with tail recursion using function call*)
axioms  methRevF[simp]:
 "methtable Revv revFun = ([RNpar l_, RNpar acc_], CALL g_)"
   
axioms  funtg[simp]:
 "funtable g_ == ([RNpar l_, RNpar acc_],
                  LET tag_ = GetFi l_ TAG ;
                        b_ = Primop (% x y. if x = NIL_TAG then 1 else 0) tag_ tag_
                  IN IF b_ 
                      THEN RVar acc_ 
                      ELSE LET   h_ = GetFi l_ HD;
                              rf t_ = GetFr l_ TL;
                               tag_ = expr.Int CONS_TAG;
                                  _ = PutFi l_ TAG tag_; 
                                  _ = PutFi l_ HD h_;
                                  _ = PutFr l_ TL acc_;
                               rf acc = RVar l; 
                               rf l = RVar t
                           IN  CALL g_ END
                  END)"

end
