theory Collecting = VDMderived + EvenOdd:

(*Policies for invokestatics may be specified later*)
consts Inv_policy:: "(expr \<times> env \<times> heap) \<Rightarrow> 'a \<Rightarrow> 'a"

constdefs Collect ::"('a list) EFF"
"Collect == \<lparr>
  Int_effect = (\<lambda> eEh . []),
  IVar_effect = (\<lambda> eEh . []),
  Primop_effect = (\<lambda> eEh . []),
  Null_effect = (\<lambda> eEh . []),
  RVar_effect = (\<lambda> eEh . []),
  RPrimop_effect = (\<lambda> eEh . []),
  New_effect = (\<lambda> eEh . []),
  GetFi_effect = (\<lambda> eEh . []),
  GetFr_effect = (\<lambda> eEh . []),
  PutFi_effect = (\<lambda> eEh . []),
  PutFr_effect = (\<lambda> eEh . []),
  GetStat_effect = (\<lambda> eEh . []),
  PutStat_effect = (\<lambda> eEh . []),

  InvV_effect = Inv_policy,
  InvS_effect = Inv_policy,
     
  Leti_effect = (\<lambda> eEh p1 p2 . p1 @ p2),
  Letr_effect = (\<lambda> eEh p1 p2 . p1 @ p2),
  Letv_effect = (\<lambda> eEh p1 p2 . p1 @ p2),
  If_effect = (\<lambda> eEh p. p),
  Call_effect = (\<lambda> eEh p . p)\<rparr>"

consts SysC::cname
       SysM::mname
       SysP1::iname
       SysP2::rname

axioms MTSys: "methtable SysC SysM = ([INpar SysP1, RNpar SysP2], Null)"

subsection{*Policies*}
consts Inv_Policy1::"(expr \<times> env \<times> heap) \<Rightarrow> (expr list) \<Rightarrow> (expr list)"
primrec
"Inv_Policy1 (e, Eh) L =
 (case Eh of (E,h) \<Rightarrow> e # L)"

constdefs Policy1::"bool"
"Policy1 == Inv_policy = Inv_Policy1"

lemma Sys:"Policy1 \<Longrightarrow> G \<rhd>  snd(methtable SysC SysM):
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = Collect \<longrightarrow> p = []))"
apply (simp add: MTSys)
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: Collect_def)
done

lemma Inv:"Policy1 \<Longrightarrow> G \<rhd>  (SysC\<bullet>SysM(A)):
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = Collect \<longrightarrow> p = [SysC\<bullet>SysM(A)]))"
apply (rule vdm_invokestatic)
apply (rule vdm_conseq, erule Sys)
apply (simp add: Collect_def)
apply (simp add: Policy1_def)
done

(*A first test of the policy*)
lemma "Policy1 \<Longrightarrow> 
  G \<rhd> (Leti x (expr.Int 21) (SysC\<bullet>SysM([INarg x, RNarg a]))): 
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = Collect \<longrightarrow> p = [SysC\<bullet>SysM([INarg x, RNarg a])]))"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (erule Inv)
apply clarify
apply (simp add: Collect_def)
done

consts M::mname
axioms MTSys: "methtable C M = ([], Null)"

lemma M_lemma:"Policy1 \<Longrightarrow> G \<rhd>  snd(methtable C M):
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = Collect \<longrightarrow> p = []))"
apply (simp add: MTSys)
apply (rule vdm_conseq, rule vdm_null)
apply (simp add: Collect_def)
done

lemma InvM:"Policy1 \<Longrightarrow> G \<rhd>  (r\<diamondsuit>M([])):
   (\<lambda> P E h hh v p.  h=hh \<and> v= RVal Nullref \<and> (P = Collect \<longrightarrow> p = [r\<diamondsuit>M([])]))"
apply (rule vdm_invoke)
apply clarsimp
apply (rule vdm_conseq)
apply (erule M_lemma)
apply (simp only: Policy1_def Collect_def)
apply simp
done

(*Second test*)
lemma "Policy1 \<Longrightarrow> \<rhd> (LET x = (expr.Int 21);
                             _ = (SysC\<bullet>SysM([INarg x, RNarg a]));
                          rf r = New C [] []
                          IN r\<diamondsuit>M([]) END): (\<lambda> P E h hh v p.  P = Collect \<longrightarrow> 
                                                p = [SysC\<bullet>SysM([INarg x, RNarg a]),r\<diamondsuit>M([])])"
apply (rule vdm_conseq)
apply (rule vdm_leti, rule vdm_int)
apply (rule vdm_letv, erule Inv)
apply (rule vdm_letr, rule vdm_new)
apply (erule InvM) 
apply clarify
apply (simp add: Collect_def)
done

(*Third test: the invocation trace of even/odd*)
lemma "\<lbrakk>E<abc> = 0; Policy1; Collect | E \<turnstile> h,(SysC\<bullet>Even([INarg abc])) \<Down> hh,v,p\<rbrakk> \<Longrightarrow> p=[SysC\<bullet>Even([INarg abc])]"
apply (simp add: sem_def, clarsimp)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_even, clarsimp)
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp apply (simp add: b_def x_def)
apply (erule eval_cases) apply clarsimp
apply (simp add: Collect_def) apply (simp add: Policy1_def)
apply (clarsimp) apply (simp add: b_def x_def)
done
lemma "\<lbrakk>E<abc> = 1; Policy1; Collect | E \<turnstile> h,(SysC\<bullet>Even([INarg abc])) \<Down> hh,v,p\<rbrakk> \<Longrightarrow> p=[SysC\<bullet>Even([INarg abc]),SysC\<bullet>Odd([INarg x])]"
apply (simp add: sem_def, clarsimp)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_even, clarsimp)
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp apply (simp add: b_def x_def)
apply clarsimp apply (simp add: b_def x_def)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_odd, clarsimp) 
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp 
apply (erule eval_cases) apply clarsimp apply (simp add: b_def x_def y_def)
  apply (simp add: Collect_def) apply (simp add: Policy1_def)
apply (clarsimp) apply (simp add: b_def x_def y_def)
done
lemma "\<lbrakk>E<abc> = 2; Policy1; Collect | E \<turnstile> h,(SysC\<bullet>Even([INarg abc])) \<Down> hh,v,p\<rbrakk> \<Longrightarrow> p=[SysC\<bullet>Even([INarg abc]),SysC\<bullet>Odd([INarg x]),SysC\<bullet>Even([INarg y])]"
apply (simp add: sem_def, clarsimp)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_even, clarsimp)
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp apply (simp add: b_def x_def)
apply clarsimp apply (simp add: b_def x_def)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_odd, clarsimp) 
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp 
apply (erule eval_cases) apply clarsimp apply (simp add: b_def x_def y_def)
apply clarsimp apply (simp add: b_def x_def y_def)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_even, clarsimp) 
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp 
apply (erule eval_cases) apply clarsimp apply (simp add: b_def x_def y_def)
  apply (simp add: Collect_def) apply (simp add: Policy1_def)
apply (clarsimp) apply (simp add: b_def x_def y_def)
done
lemma "\<lbrakk>E<abc> = 0; Policy1; Collect | E \<turnstile> h,(SysC\<bullet>Odd([INarg abc])) \<Down> hh,v,p\<rbrakk> \<Longrightarrow> p=[SysC\<bullet>Odd([INarg abc])]"
apply (simp add: sem_def, clarsimp)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_odd, clarsimp)
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp apply (simp add: b_def y_def)
apply (erule eval_cases) apply clarsimp
apply (simp add: Collect_def) apply (simp add: Policy1_def)
apply (clarsimp) apply (simp add: b_def y_def)
done
lemma "\<lbrakk>E<abc> = 1; Policy1; Collect | E \<turnstile> h,(SysC\<bullet>Odd([INarg abc])) \<Down> hh,v,p\<rbrakk> \<Longrightarrow> p=[SysC\<bullet>Odd([INarg abc]),SysC\<bullet>Even([INarg y])]"
apply (simp add: sem_def, clarsimp)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_odd, clarsimp)
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp apply (simp add: b_def y_def)
apply clarsimp apply (simp add: b_def y_def)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_even, clarsimp) 
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp 
apply (erule eval_cases) apply clarsimp apply (simp add: b_def x_def y_def)
  apply (simp add: Collect_def) apply (simp add: Policy1_def)
apply (clarsimp) apply (simp add: b_def x_def y_def)
done
lemma "\<lbrakk>E<abc> = 2; Policy1; Collect | E \<turnstile> h,(SysC\<bullet>Odd([INarg abc])) \<Down> hh,v,p\<rbrakk> \<Longrightarrow> p=[SysC\<bullet>Odd([INarg abc]),SysC\<bullet>Even([INarg y]),SysC\<bullet>Odd([INarg x])]"
apply (simp add: sem_def, clarsimp)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_odd, clarsimp)
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp apply (simp add: b_def y_def)
apply clarsimp apply (simp add: b_def x_def)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_even, clarsimp) 
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp 
apply (erule eval_cases) apply clarsimp apply (simp add: b_def x_def y_def)
apply clarsimp apply (simp add: b_def x_def y_def)
apply (erule eval_cases) apply (simp add: newframe_env_def evalARGS_def MT_odd, clarsimp) 
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp
apply (erule eval_cases) apply clarsimp 
apply (erule eval_cases) apply clarsimp apply (simp add: b_def x_def y_def)
  apply (simp add: Collect_def) apply (simp add: Policy1_def)
apply (clarsimp) apply (simp add: b_def x_def y_def)
done

consts ESpec::"nat \<Rightarrow> (expr list)"
primrec
"ESpec 0 = []"
"ESpec (Suc n) = (if (\<exists> k. Suc n= 2 * k) then (ESpec n) @ [SysC\<bullet>Even([INarg y])] else  (ESpec n) @ [SysC\<bullet>Odd([INarg x])])"

consts OSpec::"nat \<Rightarrow> (expr list)"
primrec
"OSpec 0 = []"
"OSpec (Suc n) = (if (\<exists> k. Suc n= 2 * k) then (OSpec n) @ [SysC\<bullet>Odd([INarg x])] else  (OSpec n) @ [SysC\<bullet>Even([INarg y])])"

constdefs ESpecI::"int \<Rightarrow> (expr list)"
"ESpecI n == (if n<0 then [] else ESpec (nat n))"

constdefs OSpecI::"int \<Rightarrow> (expr list)"
"OSpecI n == (if n<0 then [] else OSpec (nat n))"

constdefs evenSpec::"ARGTYPE \<Rightarrow> (expr list) vdmassn"
"evenSpec z ==  (\<lambda> P E h hh v p. (\<forall> w . z = [INarg w] \<longrightarrow> 0 <= E<w> \<longrightarrow> (\<exists> n. E<w> = 2 * n) \<longrightarrow> 
                                         P = Collect \<longrightarrow> p = ((SysC\<bullet>Even([INarg w])) # (ESpecI (E<w>)))))"

constdefs oddSpec::"ARGTYPE \<Rightarrow> (expr list) vdmassn"
"oddSpec z ==  (\<lambda> P E h hh v p. \<forall> w . z = [INarg w] \<longrightarrow> 0 <= E<w> \<longrightarrow> (\<exists> n. E<w> = 1 + 2 * n)\<longrightarrow>
                                       P = Collect \<longrightarrow> p = ((SysC\<bullet>Odd([INarg w])) # (OSpecI (E<w>))))"

consts FST ::"(expr list) FS_T"
       vMST::"(expr list) vMS_T"
constdefs sMST::"(expr list) sMS_T"
"sMST == (\<lambda> c m y . if c=SysC \<and> m = Even then evenSpec y else
                    if c=SysC \<and> m = Odd then oddSpec y else (\<lambda> P E h hh v p . False))"

constdefs G::"(expr list) vdmcontext"
"G == {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}"

lemma L0: "0 <= na \<Longrightarrow> 0 < (nat (1 + (2 * (na::int))))"
by clarsimp

lemma L1: "\<lbrakk>0 <= na; (nat (1 + (2 * (na::int)))) = 0\<rbrakk> \<Longrightarrow> P"
by (drule L0,auto) 
lemma L2a:"\<forall> k l . (n = Suc (2 * (k::nat)) \<longrightarrow> n \<noteq>  (2 * l))"
apply (induct n)
apply simp
apply clarsimp
apply (erule_tac x=k in allE)
apply clarsimp
apply fast
done
lemma L2b:"(Suc (2 * (k::nat))) \<noteq>  (2 * l)"
by (insert L2a [of "Suc (2 * (k::nat))"], clarsimp)
lemma L2:"(Suc (2 * (k::nat))) =  (2 * l) \<Longrightarrow> P"
by (insert L2b, clarsimp)
lemma L3: "\<exists> k . (Suc n) = (2 * k) \<or> ((Suc (Suc n)) = (2 * k))"
apply (induct n)
apply clarsimp
apply clarsimp
apply (erule disjE)
apply clarsimp
apply (rule_tac x="Suc k" in exI, simp)
apply clarsimp
apply (rule_tac x="k" in exI, simp)
done
lemma L4: "\<lbrakk>(\<forall>k. ((Suc n) \<noteq> (2 * k))); (\<forall>k. ((Suc (Suc n)) \<noteq> (2 * k)))\<rbrakk> \<Longrightarrow> False"
by (insert L3,fast)

lemma L5:"m = Suc n \<Longrightarrow> (SysC\<bullet>(MN ''Odd'')([(INarg (In ''x''))])) # (OSpec n) = 
                        (ESpec m)"
apply clarsimp
apply (induct n)
apply clarsimp apply (simp add: Odd_def x_def)
apply clarsimp
apply rule
apply clarsimp apply (drule L2) apply simp 
apply clarsimp
apply (drule L4, assumption) apply simp
done

lemma L6:"0 <= na \<Longrightarrow> (((SysC\<bullet>(MN ''Odd'')([(INarg (In ''x''))])) # (OSpec (nat (1 + (2 * (na::int)))))) = (ESpec (nat (2 + (2 * na)))))"
apply (rule L5)
apply arith
done

lemma L7:"Suc m = n \<Longrightarrow> (SysC\<bullet>(MN ''Even'')([(INarg (In ''y''))])) # (ESpec m) = (OSpec n)"
apply clarsimp
apply (induct m)
apply clarsimp apply (simp add: Even_def y_def)
apply clarsimp
apply rule
apply clarsimp apply (erule impE) apply clarsimp apply (erule L2)
 apply (simp add: Even_def Odd_def x_def y_def)
apply clarsimp
apply (drule L4)
apply assumption
apply simp
done
lemma L8: "0 <= n \<Longrightarrow> (((SysC\<bullet>(MN ''Even'')([(INarg (In ''y''))])) # (ESpec (nat (2 * n)))) = (OSpec (nat (1 + (2 * n)))))"
by (rule L7, arith)

lemma G_good: "Policy1 \<Longrightarrow> goodContext FST vMST sMST G"
apply (simp add: goodContext_def)
apply (rule, rule, rule)
apply (simp add: G_def)
apply (erule disjE)
apply (rule disjI2, rule disjI2)
apply clarsimp
  apply (simp add: MT_even)
  apply (rule vdm_conseq)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_if) 
  apply (rule vdm_int)
  apply (rule vdm_ax) 
    apply (subgoal_tac "(SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])
         \<in> {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}",
            assumption) apply simp
  apply clarsimp apply (case_tac "E<x>=0")
  apply clarsimp apply (simp add: x_def y_def b_def sMST_def newframe_env_def evalARGS_def evenSpec_def Collect_def)
   apply clarsimp apply (simp add: Policy1_def) apply (simp add: ESpecI_def)
  apply clarsimp apply (simp add: x_def b_def sMST_def newframe_env_def evalARGS_def evenSpec_def Collect_def)
   apply clarsimp apply (simp add: Even_def Odd_def Policy1_def  x_def oddSpec_def Collect_def)
    apply (subgoal_tac "\<exists>na. 2 * n = 2 + 2 * na") prefer 2 apply (rule_tac x="n - 1" in exI) apply simp 
    apply (erule impE, assumption) apply (erule exE) apply clarsimp 
     apply (simp add: ESpecI_def OSpecI_def) apply (rule L6) apply simp
apply clarsimp
  apply (simp add: MT_odd)
  apply (rule vdm_conseq)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_leti, rule vdm_prim)
  apply (rule vdm_if) 
  apply (rule vdm_int)
  apply (rule vdm_ax) 
    apply (subgoal_tac "(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y])
         \<in> {(SysC\<bullet>Even([INarg y]), sMST SysC Even [INarg y]), (SysC\<bullet>Odd([INarg x]), sMST SysC Odd [INarg x])}",
            assumption) apply simp
  apply clarsimp apply (case_tac "E<y>=0")
  apply clarsimp apply (simp add: x_def y_def b_def sMST_def newframe_env_def evalARGS_def evenSpec_def Collect_def)
    apply clarsimp  apply (simp add: x_def b_def sMST_def newframe_env_def evalARGS_def oddSpec_def Collect_def Even_def Odd_def)
   apply clarsimp apply (simp add: Policy1_def OSpecI_def)
  apply clarsimp apply (simp add: x_def y_def b_def sMST_def newframe_env_def evalARGS_def evenSpec_def Collect_def)
   apply (simp add: Even_def Odd_def Policy1_def  x_def oddSpec_def Collect_def)
  apply clarsimp
    apply (simp add: ESpecI_def OSpecI_def)
    apply (rule L8) apply simp
done

lemma Even1: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Even([INarg y])) : evenSpec [INarg y]" 
apply (rule MUTREC)
apply (subgoal_tac "finite G", assumption, simp add: G_def)
apply (simp add: G_def)
apply (erule G_good)
apply (simp add: G_def Even_def Odd_def sMST_def)
done
lemma Even2: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Even([INarg z])) : sMST SysC Even [INarg z]" 
apply (rule GCInvs)
apply (erule G_good)
apply (simp add: G_def)
apply (simp add: G_def Even_def Odd_def)
apply fast
done
lemma Even3: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Even([INarg z])) : evenSpec [INarg z]" 
apply (rule vdm_conseq)
apply (erule Even2)
apply (simp add: sMST_def)
done
lemma "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Even([INarg u])) : (\<lambda> P E h hh v p . E<u>=6 \<longrightarrow> P = Collect \<longrightarrow> 
                                                              p = ((SysC\<bullet>Even([INarg u])) # (ESpecI 6)))"
apply (drule Even3 [of u])
apply (erule vdm_conseq)
apply clarsimp apply (simp add: evenSpec_def Collect_def)done
lemma "(SysC\<bullet>Even([INarg u])) # (ESpec (Suc (Suc (Suc (Suc (Suc (Suc 0))))))) =
    [SysC\<bullet>Even([INarg u]), SysC\<bullet>Odd([INarg x]), SysC\<bullet>Even([INarg y]), 
                           SysC\<bullet>Odd([INarg x]), SysC\<bullet>Even([INarg y]),
                           SysC\<bullet>Odd([INarg x]), SysC\<bullet>Even([INarg y])]"
apply (simp add: ESpecI_def)
apply (simp add: Even_def Odd_def x_def y_def)
apply auto
apply arith
apply arith
apply arith
done

lemma Odd1: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Odd([INarg x])) : oddSpec [INarg x]" 
apply (rule MUTREC)
apply (subgoal_tac "finite G", assumption, simp add: G_def)
apply (simp add: G_def)
apply (erule G_good)
apply (simp add: G_def Even_def Odd_def sMST_def)
done
lemma Odd2: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Odd([INarg z])) : sMST SysC Odd [INarg z]" 
apply (rule GCInvs)
apply (erule G_good)
apply (simp add: G_def)
apply (simp add: G_def Even_def Odd_def)
apply fast
done
lemma Odd3: "Policy1 \<Longrightarrow> \<rhd> (SysC\<bullet>Odd([INarg z])) : oddSpec [INarg z]" 
apply (rule vdm_conseq)
apply (erule Odd2)
apply (simp add: sMST_def Odd_def Even_def)
done


end
